/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.simantics.ConsoleUserAgent;
import org.simantics.Logger;
import org.simantics.PlatformException;
import org.simantics.SimanticsPlatform;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ServerAddress;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.indexing.IndexUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.management.SessionContextProvider;
import org.simantics.db.management.SingleSessionContextProviderSource;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.utils.FileUtils;
import org.simantics.utils.TempFiles;
import org.simantics.utils.threads.ThreadUtils;

public class Simantics {
    private static ISessionContextProviderSource providerSource = null;
    public static TempFiles TEMP_FILES = new TempFiles(){

        public File getTempfile(String directory, String suffix) {
            return Simantics.getTempfile(directory, suffix);
        }
    };

    public static ISessionContext startUpHeadless(IArguments args, IProgressMonitor progress) throws PlatformException {
        SimanticsPlatform.OntologyRecoveryPolicy ontologyPolicy;
        if (SimanticsPlatform.INSTANCE.sessionContext != null) {
            throw new RuntimeDatabaseException("Simantics is already up and running.");
        }
        SimanticsPlatform.RecoveryPolicy workspacePolicy = Platform.inDevelopmentMode() ? SimanticsPlatform.RecoveryPolicy.FixError : SimanticsPlatform.RecoveryPolicy.ThrowError;
        SimanticsPlatform.OntologyRecoveryPolicy ontologyRecoveryPolicy = ontologyPolicy = Platform.inDevelopmentMode() ? SimanticsPlatform.OntologyRecoveryPolicy.Merge : SimanticsPlatform.OntologyRecoveryPolicy.ThrowError;
        if (args.contains(SimanticsArguments.RECOVERY_POLICY_FIX_ERRORS)) {
            workspacePolicy = SimanticsPlatform.RecoveryPolicy.FixError;
            ontologyPolicy = SimanticsPlatform.OntologyRecoveryPolicy.Merge;
        }
        if (args.contains(SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL)) {
            ontologyPolicy = SimanticsPlatform.OntologyRecoveryPolicy.ReinstallDatabase;
        }
        if (args.contains(SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL)) {
            ontologyPolicy = SimanticsPlatform.OntologyRecoveryPolicy.ReinstallDatabase;
        }
        int localPort = 0;
        if (args.contains(SimanticsArguments.LOCAL_SERVER_PORT)) {
            try {
                localPort = (Integer)args.get(SimanticsArguments.LOCAL_SERVER_PORT);
            }
            catch (IllegalArgumentException e) {
                throw new PlatformException("Failed to open database session", e);
            }
        }
        ServerAddress remoteDatabase = null;
        if (args.contains(SimanticsArguments.SERVER)) {
            String serverAddress = (String)args.get(SimanticsArguments.SERVER);
            try {
                remoteDatabase = new ServerAddress(serverAddress);
            }
            catch (IllegalArgumentException e) {
                throw new PlatformException("Failed to open database session", e);
            }
        }
        return Simantics.startUpHeadless(progress, workspacePolicy, ontologyPolicy, localPort, remoteDatabase);
    }

    public static ISessionContext startUpHeadless(IProgressMonitor progress, SimanticsPlatform.RecoveryPolicy workspacePolicy, SimanticsPlatform.OntologyRecoveryPolicy ontologyPolicy, int localPort, ServerAddress remoteDatabase) throws PlatformException {
        if (SimanticsPlatform.INSTANCE.sessionContext != null) {
            throw new RuntimeDatabaseException("Simantics is already up and running.");
        }
        SessionContextProvider provider = new SessionContextProvider(null);
        SingleSessionContextProviderSource source = new SingleSessionContextProviderSource((ISessionContextProvider)provider);
        Simantics.setSessionContextProviderSource((ISessionContextProviderSource)source);
        org.simantics.db.layer0.util.Simantics.setSessionContextProviderSource((ISessionContextProviderSource)source);
        if (progress == null) {
            progress = new NullProgressMonitor();
        }
        return SimanticsPlatform.INSTANCE.startUp(progress, workspacePolicy, ontologyPolicy, localPort, remoteDatabase, new ConsoleUserAgent());
    }

    public static void shutdown(IProgressMonitor progress) throws PlatformException {
        SimanticsPlatform.INSTANCE.shutdown(progress);
    }

    public static void async(Runnable runnable) {
        ThreadUtils.getBlockingWorkExecutor().execute(runnable);
    }

    public static void async(Runnable runnable, int delay, TimeUnit unit) {
        ThreadUtils.getTimer().schedule(runnable, (long)delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, int initialDelay, int period, TimeUnit unit) {
        return ThreadUtils.getTimer().scheduleAtFixedRate(runnable, initialDelay, period, unit);
    }

    public static void asyncNonblocking(Runnable runnable) {
        ThreadUtils.getNonBlockingWorkExecutor().execute(runnable);
    }

    public static void asyncNonblocking(Runnable runnable, int initialDelay, int period) {
        ThreadUtils.getNonBlockingWorkExecutor().scheduleAtFixedRate(runnable, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public static synchronized ISessionContext setSessionContext(ISessionContext ctx) {
        return Simantics.getSessionContextProvider().setSessionContext(ctx);
    }

    public static void setSessionContextProviderSource(ISessionContextProviderSource source) {
        if (source == null) {
            throw new IllegalArgumentException("null provider source");
        }
        providerSource = source;
    }

    public static ISessionContextProviderSource getProviderSource() {
        if (providerSource == null) {
            throw new IllegalStateException("providerSource must be initialized by the application before using class Simantics");
        }
        return providerSource;
    }

    public static ISessionContextProvider getSessionContextProvider() {
        return Simantics.getProviderSource().getActive();
    }

    public static ISessionContext getSessionContext() {
        ISessionContextProvider provider = Simantics.getSessionContextProvider();
        return provider != null ? provider.getSessionContext() : null;
    }

    public static Session getSession() {
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("Session unavailable, no database session open");
        }
        return ctx.getSession();
    }

    public static Session peekSession() {
        ISessionContext ctx = Simantics.getSessionContext();
        return ctx == null ? null : ctx.peekSession();
    }

    public static Resource getProjectResource() {
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("No current database session");
        }
        Resource project = (Resource)ctx.getHint(SimanticsKeys.KEY_PROJECT);
        if (project == null) {
            throw new IllegalStateException("No current project resource in session context " + ctx);
        }
        return project;
    }

    public static Resource peekProjectResource() {
        ISessionContext ctx = Simantics.getSessionContext();
        return ctx != null ? (Resource)ctx.getHint(SimanticsKeys.KEY_PROJECT) : null;
    }

    public static IProject getProject() {
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("No current database session");
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            throw new IllegalStateException("No current project in session context " + ctx);
        }
        return project;
    }

    public static IProject peekProject() {
        ISessionContext ctx = Simantics.getSessionContext();
        return ctx == null ? null : (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
    }

    public static void setClipboard(SimanticsClipboard content) {
        org.simantics.db.layer0.util.Simantics.setClipboard((SimanticsClipboard)content);
    }

    public static SimanticsClipboard getClipboard() {
        return org.simantics.db.layer0.util.Simantics.getClipboard();
    }

    public static Layer0 getLayer0() throws DatabaseException {
        return Layer0.getInstance((RequestProcessor)Simantics.getSession());
    }

    public static <T> T sync(ReadInterface<T> r) throws DatabaseException {
        return (T)Simantics.getSession().sync(r);
    }

    public static <T> T sync(WriteInterface<T> r) throws DatabaseException {
        return (T)Simantics.getSession().sync(r);
    }

    public static <T> void async(ReadInterface<T> r) {
        Simantics.getSession().async(r, (Procedure)new ProcedureAdapter());
    }

    public static <T> void async(WriteInterface<T> r) {
        Simantics.getSession().async(r);
    }

    public static void clearTemporaryDirectory() {
        FileUtils.deleteDir((File)Simantics.getTemporaryDirectory());
    }

    public static File getTempfile(String directory, String suffix) {
        File dir = Simantics.getTemporaryDirectory(directory);
        return new File(dir, String.valueOf(UUID.randomUUID().toString()) + "." + suffix);
    }

    public static File getTemporaryDirectory(String directory) {
        File sub = new File(Simantics.getTemporaryDirectory(), directory);
        sub.mkdirs();
        return sub;
    }

    public static File getTemporaryDirectory() {
        File workspace = Platform.getLocation().toFile();
        File temp = new File(workspace, "tempFiles");
        temp.mkdirs();
        return temp;
    }

    public static TempFiles getTempFiles() {
        return TEMP_FILES;
    }

    public static void flushIndexCaches(IProgressMonitor progress, Session session) {
        try {
            IndexUtils.flushIndexCaches((IProgressMonitor)progress, (Session)session);
        }
        catch (Exception e) {
            Logger.defaultLogError(e);
        }
    }

    public static <T> T applySCL(String module, String function, ReadGraph graph, Object ... args) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        try {
            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
            Object t = ((Function)SCLOsgi.INSTANCE.getValue(String.valueOf(module) + "/" + function)).applyArray(args);
            sclContext.put((Object)"graph", oldGraph);
            return (T)t;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
    }

    public static boolean ensureMemoryBytes(long bytes) {
        Runtime runtime = Runtime.getRuntime();
        long consumedMemory = runtime.totalMemory() - runtime.freeMemory();
        long available = runtime.maxMemory() - consumedMemory;
        return available > bytes;
    }

    public static long getDiskBytes() {
        File ws = new File(Platform.getInstanceLocation().getURL().getFile());
        return ws.getUsableSpace();
    }
}

