/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.Root;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;

public class OntologyImportAdvisor
implements IImportAdvisor2 {
    Map<String, Resource> roots = new HashMap<String, Resource>();
    private final GraphBundle tg;
    private final DatabaseManagement mgmt;
    private final String rootName;
    private Resource ontology;

    public OntologyImportAdvisor(GraphBundle tg, DatabaseManagement mgmt) {
        this.tg = tg;
        this.mgmt = mgmt;
        this.rootName = String.valueOf(tg.getName().substring(tg.getName().lastIndexOf("/") + 1)) + "-" + tg.getMajor() + "." + tg.getMinor();
    }

    public Resource getTarget() {
        return null;
    }

    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        return null;
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        return this.createRoot(graph, root, null);
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
        if (resource == null) {
            resource = graph.newResource();
        }
        this.roots.put(root.name, resource);
        return resource;
    }

    public Resource getRoot(String name) {
        return this.roots.get(name);
    }

    public Collection<Resource> getRoots() {
        return this.roots.values();
    }

    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        this.ontology = graph.newResource(graph.getRootLibrary());
        graph.newClusterSet(this.ontology);
        graph.setClusterSet4NewResource(this.ontology);
    }

    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        try {
            long[] ids = process.getResourceIds((SerialisationSupport)graph.getService(SerialisationSupport.class));
            this.tg.setResourceArray(ids);
            this.mgmt.createGraphBundle(graph, this.tg);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public boolean allowImmutableModifications() {
        return true;
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, String name) throws DatabaseException {
        if (this.rootName.equals(name)) {
            return process.createChild(graph, parent, this.ontology, name);
        }
        return process.createChild(graph, parent, null, name);
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child, String name) throws DatabaseException {
        if (this.rootName.equals(name)) {
            return process.createChild(graph, parent, this.ontology, name);
        }
        return process.createChild(graph, parent, null, name);
    }
}

