/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.util.Properties;
import org.simantics.LogManager;

public class Logger {
    public static final boolean ECHO = true;
    public static final Properties defaultProperties = new Properties();
    private static LogManager defaultLogManager;
    private static final Logger defaultErrorLogger;
    private org.apache.log4j.Logger logger;

    static {
        defaultProperties.put("log4j.rootCategory", "INFO, default");
        defaultProperties.put("log4j.appender.default", "org.apache.log4j.FileAppender");
        defaultProperties.put("log4j.appender.default.File", "simantics.log");
        defaultProperties.put("log4j.appender.default.append", "false");
        defaultProperties.put("log4j.appender.default.layout", "org.apache.log4j.PatternLayout");
        defaultProperties.put("log4j.appender.default.layout.ConversionPattern", "%d{ISO8601} %-6r [%15.15t] %-5p %30.30c - %m%n");
        defaultLogManager = new LogManager(defaultProperties);
        defaultErrorLogger = new Logger(LogManager.class);
    }

    Logger(Class<?> clazz) {
        this.logger = defaultLogManager.getLogger(clazz);
    }

    public void logTrace(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.logger.trace((Object)message, exception);
    }

    public void logInfo(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.logger.info((Object)message, exception);
    }

    public void logWarning(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.logger.warn((Object)message, exception);
    }

    public void logError(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.logger.error((Object)message, exception);
    }

    public static Logger getDefault() {
        return defaultErrorLogger;
    }

    public static LogManager getDefaultLogManager() {
        return defaultLogManager;
    }

    public static void defaultLogError(Throwable exception) {
        Logger.getDefault().logError(exception.getLocalizedMessage(), exception);
        exception.printStackTrace();
    }

    public static void defaultLogError(String message) {
        Logger.getDefault().logError(message, null);
        System.err.println(message);
    }

    public static void defaultLogError(String message, Throwable exception) {
        Logger.getDefault().logError(message, exception);
        System.err.println(message);
    }

    public static void defaultLogInfo(String message) {
        Logger.getDefault().logInfo(message, null);
        System.err.println(message);
    }

    public static void defaultLogTrace(String message) {
        Logger.getDefault().logTrace(message, null);
        System.err.println(message);
    }
}

