/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.history.HistoryException;
import org.simantics.history.util.ValueBand;

public class Stream {
    public ArrayAccessor accessor;
    public RecordType sampleType;
    public RecordBinding sampleBinding;
    public int timeIndex;
    public Datatype timeType;
    public Binding timeBinding;
    public int endTimeIndex;
    public Datatype endTimeType;
    public Binding endTimeBinding;
    public int valueIndex;
    public Datatype valueType;
    public Binding valueBinding;
    public int qualityIndex = -1;
    public NumberType qualityType;
    public NumberBinding qualityBinding;

    public Stream(ArrayAccessor accessor) {
        this.accessor = accessor;
        this.sampleType = (RecordType)accessor.type().componentType();
        this.sampleBinding = (RecordBinding)Bindings.getBeanBinding((Datatype)this.sampleType);
        this.valueIndex = this.sampleType.getComponentIndex2("value");
        if (this.valueIndex < 0) {
            throw new IllegalArgumentException("Array is not a sample array, value field is missing");
        }
        this.valueType = this.sampleType.getComponentType(this.valueIndex);
        this.valueBinding = this.sampleBinding.getComponentBinding(this.valueIndex);
        this.timeIndex = this.sampleType.getComponentIndex2("time");
        if (this.timeIndex < 0) {
            throw new IllegalArgumentException("Array is not a sample array, time field is missing");
        }
        this.timeType = this.sampleType.getComponentType(this.timeIndex);
        this.timeBinding = this.sampleBinding.getComponentBinding(this.timeIndex);
        this.endTimeIndex = this.sampleType.getComponentIndex2("endTime");
        this.qualityIndex = this.sampleType.getComponentIndex2("quality");
        this.qualityType = this.qualityIndex >= 0 ? (NumberType)this.sampleType.getComponentType(this.qualityIndex) : null;
        this.qualityBinding = this.qualityType != null ? (NumberBinding)this.sampleBinding.getComponentBinding(this.qualityIndex) : null;
    }

    public Stream(ArrayAccessor accessor, RecordBinding recordBinding) {
        this.accessor = accessor;
        this.sampleType = (RecordType)accessor.type().componentType();
        if (!this.sampleType.equals((Object)recordBinding.type())) {
            throw new IllegalArgumentException("Wrong binding. Got " + recordBinding.type() + ", expected " + this.sampleType);
        }
        this.sampleBinding = recordBinding;
        this.valueIndex = this.sampleType.getComponentIndex2("value");
        this.timeIndex = this.sampleType.getComponentIndex2("time");
        this.endTimeIndex = this.sampleType.getComponentIndex2("endTime");
        if (this.valueIndex < 0) {
            throw new IllegalArgumentException("Array is not a sample array, value field is missing");
        }
        if (this.timeIndex < 0) {
            throw new IllegalArgumentException("Array is not a sample array, time field is missing");
        }
        this.valueType = this.sampleType.getComponentType(this.valueIndex);
        this.timeType = this.sampleType.getComponentType(this.timeIndex);
        this.endTimeType = this.endTimeIndex >= 0 ? this.sampleType.getComponentType(this.endTimeIndex) : null;
        this.valueBinding = this.sampleBinding.getComponentBinding("value");
        this.timeBinding = this.sampleBinding.getComponentBinding("time");
        this.endTimeBinding = this.endTimeIndex >= 0 ? this.sampleBinding.getComponentBinding("endTime") : null;
    }

    public void close() {
        if (this.accessor instanceof CloseableAccessor) {
            CloseableAccessor ca = (CloseableAccessor)this.accessor;
            try {
                ca.close();
            }
            catch (AccessorException accessorException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        if (this.accessor instanceof StreamAccessor) {
            StreamAccessor sa = (StreamAccessor)this.accessor;
            try {
                sa.reset();
            }
            catch (AccessorException accessorException) {
                // empty catch block
            }
        }
    }

    public int binarySearch(Binding timeBinding, Object time) throws HistoryException {
        try {
            Object time_ = Bindings.adapt((Object)time, (Binding)timeBinding, (Binding)this.timeBinding);
            int fromIndex = 0;
            int toIndex = this.accessor.size();
            int ix = this.binarySearch0(fromIndex, toIndex, time_);
            return ix;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    private int binarySearch0(int fromIndex, int toIndex, Object key) throws AccessorException, BindingException {
        int low = fromIndex;
        int high = toIndex - 1;
        Binding timeBinding = this.sampleBinding.getComponentBinding(this.timeIndex);
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midSam = this.accessor.get(mid, (Binding)this.sampleBinding);
            Object midVal = this.sampleBinding.getComponent(midSam, this.timeIndex);
            int cmp = timeBinding.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Object getLowerSample(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block8: {
            block7: {
                block6: {
                    try {
                        index = this.binarySearch(timeBinding, time);
                        if (index != 0) break block6;
                        return null;
                    }
                    catch (AccessorException e) {
                        throw new HistoryException(e);
                    }
                }
                if (index > 0) {
                    return this.accessor.get(index - 1, (Binding)this.sampleBinding);
                }
                if ((index = -index - 2) >= 0) break block7;
                return null;
            }
            if (index < this.accessor.size()) break block8;
            return null;
        }
        return this.accessor.get(index, (Binding)this.sampleBinding);
    }

    public Object getFloorSample(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block6: {
            block5: {
                try {
                    index = this.binarySearch(timeBinding, time);
                    if (index >= 0) {
                        return this.accessor.get(index, (Binding)this.sampleBinding);
                    }
                    if ((index = -index - 2) >= 0) break block5;
                    return null;
                }
                catch (AccessorException e) {
                    throw new HistoryException(e);
                }
            }
            if (index < this.accessor.size()) break block6;
            return null;
        }
        return this.accessor.get(index, (Binding)this.sampleBinding);
    }

    public Object getSample(Binding timeBinding, Object time) throws HistoryException {
        try {
            int pos = this.binarySearch(timeBinding, time);
            if (pos >= 0) {
                return this.accessor.get(pos, (Binding)this.sampleBinding);
            }
            return null;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
    }

    public boolean getSample(Binding timeBinding, Object time, Object sample) throws HistoryException {
        try {
            int pos = this.binarySearch(timeBinding, time);
            if (pos >= 0) {
                this.accessor.get(pos, (Binding)this.sampleBinding, sample);
                return true;
            }
            return false;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
    }

    public Object getCeilingSample(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block6: {
            block5: {
                try {
                    index = this.binarySearch(timeBinding, time);
                    if (index >= 0) {
                        return this.accessor.get(index, (Binding)this.sampleBinding);
                    }
                    if ((index = -index - 1) >= 0) break block5;
                    return null;
                }
                catch (AccessorException e) {
                    throw new HistoryException(e);
                }
            }
            if (index < this.accessor.size()) break block6;
            return null;
        }
        return this.accessor.get(index, (Binding)this.sampleBinding);
    }

    public Object getHigherSample(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block3: {
            try {
                index = this.binarySearch(timeBinding, time);
                int count = this.accessor.size();
                index = index >= 0 ? ++index : -index - 1;
                if (index >= 0 && index < count) break block3;
                return null;
            }
            catch (AccessorException e) {
                throw new HistoryException(e);
            }
        }
        return this.accessor.get(index, (Binding)this.sampleBinding);
    }

    private Object _getTime(Object sample, Binding timeBinding) throws HistoryException {
        try {
            Object time__ = this.sampleBinding.getComponent(sample, this.timeIndex);
            return Bindings.adapt((Object)time__, (Binding)this.timeBinding, (Binding)timeBinding);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    public Object getLowerTime(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block8: {
            block7: {
                block6: {
                    try {
                        index = this.binarySearch(timeBinding, time);
                        if (index != 0) break block6;
                        return null;
                    }
                    catch (AccessorException e) {
                        throw new HistoryException(e);
                    }
                }
                if (index > 0) {
                    return time;
                }
                if ((index = -index - 2) >= 0) break block7;
                return null;
            }
            if (index < this.accessor.size()) break block8;
            return null;
        }
        return this._getTime(this.accessor.get(index, (Binding)this.sampleBinding), timeBinding);
    }

    public Object getFloorTime(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block6: {
            block5: {
                try {
                    index = this.binarySearch(timeBinding, time);
                    if (index >= 0) {
                        return time;
                    }
                    if ((index = -index - 2) >= 0) break block5;
                    return null;
                }
                catch (AccessorException e) {
                    throw new HistoryException(e);
                }
            }
            if (index < this.accessor.size()) break block6;
            return null;
        }
        return this._getTime(this.accessor.get(index, (Binding)this.sampleBinding), timeBinding);
    }

    public Object getCeilingTime(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block6: {
            block5: {
                try {
                    index = this.binarySearch(timeBinding, time);
                    if (index >= 0) {
                        return time;
                    }
                    if ((index = -index - 1) >= 0) break block5;
                    return null;
                }
                catch (AccessorException e) {
                    throw new HistoryException(e);
                }
            }
            if (index < this.accessor.size()) break block6;
            return null;
        }
        return this._getTime(this.accessor.get(index, (Binding)this.sampleBinding), timeBinding);
    }

    public Object getHigherTime(Binding timeBinding, Object time) throws HistoryException {
        int index;
        block3: {
            try {
                index = this.binarySearch(timeBinding, time);
                int count = this.accessor.size();
                index = index >= 0 ? ++index : -index - 1;
                if (index >= 0 && index < count) break block3;
                return null;
            }
            catch (AccessorException e) {
                throw new HistoryException(e);
            }
        }
        return this._getTime(this.accessor.get(index, (Binding)this.sampleBinding), timeBinding);
    }

    public Object getValue(Binding timeBinding, Object time, Binding valueBinding) throws HistoryException {
        try {
            int pos = this.binarySearch(timeBinding, time);
            if (pos >= 0) {
                Object sample = this.accessor.get(pos, (Binding)this.sampleBinding);
                Object value = this.sampleBinding.getComponent(sample, this.valueIndex);
                if (valueBinding != this.valueBinding) {
                    value = Bindings.adapt((Object)value, (Binding)this.valueBinding, (Binding)valueBinding);
                }
                return value;
            }
            return null;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    public Object getValue(Binding timeBinding, Object time) throws HistoryException {
        try {
            int pos = this.binarySearch(timeBinding, time);
            if (pos >= 0) {
                Object sample = this.accessor.get(pos, (Binding)this.sampleBinding);
                Object value = this.sampleBinding.getComponent(sample, this.valueIndex);
                return value;
            }
            return null;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    public Object getQuality(Binding timeBinding, Object time) throws HistoryException {
        try {
            int pos = this.binarySearch(timeBinding, time);
            if (pos >= 0) {
                Object sample = this.accessor.get(pos, (Binding)this.sampleBinding);
                Object value = this.sampleBinding.getComponent(sample, this.qualityIndex);
                return value;
            }
            return null;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    public Object getPossibleValue(Binding timeBinding, Object time) throws HistoryException {
        block4: {
            Object sample;
            block5: {
                Object quality;
                int pos = this.binarySearch(timeBinding, time);
                if (pos < 0) break block4;
                sample = this.accessor.get(pos, (Binding)this.sampleBinding);
                if (this.qualityBinding == null || this.qualityBinding.getValue(quality = this.sampleBinding.getComponent(sample, this.qualityIndex)).equals(ValueBand.QUALITY_GOOD)) break block5;
                return null;
            }
            try {
                Object value = this.sampleBinding.getComponent(sample, this.valueIndex);
                return value;
            }
            catch (AccessorException e) {
                throw new HistoryException(e);
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
        }
        return null;
    }

    public int count() throws HistoryException {
        try {
            return this.accessor.size();
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
    }

    public Object getFirstTime(Binding binding) throws HistoryException {
        block6: {
            if (this.accessor.size() != 0) break block6;
            return null;
        }
        try {
            Object sample = this.accessor.get(0, (Binding)this.sampleBinding);
            Object time = this.sampleBinding.getComponent(sample, this.timeIndex);
            if (this.timeBinding != binding) {
                time = Bindings.adapt((Object)time, (Binding)this.timeBinding, (Binding)binding);
            }
            return time;
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    public Object getEndTime(Binding binding) throws HistoryException {
        block8: {
            if (this.accessor.size() != 0) break block8;
            return null;
        }
        try {
            Object sample = this.accessor.get(0, (Binding)this.sampleBinding);
            if (this.endTimeIndex >= 0) {
                Object endtime = this.sampleBinding.getComponent(sample, this.endTimeIndex);
                if (this.endTimeBinding != binding) {
                    endtime = Bindings.adapt((Object)endtime, (Binding)this.endTimeBinding, (Binding)binding);
                }
                return endtime;
            }
            Object time = this.sampleBinding.getComponent(sample, this.timeIndex);
            if (this.timeBinding != binding) {
                time = Bindings.adapt((Object)time, (Binding)this.timeBinding, (Binding)binding);
            }
            return time;
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    public boolean isEmpty() throws HistoryException {
        try {
            return this.accessor.size() == 0;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
    }
}

