/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.binary.InputStreamReadable;
import org.simantics.history.HistoryAndCollectorItem;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.util.Stream;

public class HistoryExportUtil {
    Binding beanArrayBinding = Bindings.getBindingUnchecked(Bean[].class);
    Serializer beanArraySerializer = Bindings.getSerializerUnchecked((Binding)this.beanArrayBinding);
    Serializer intSerializer = Bindings.getSerializerUnchecked((Binding)Bindings.INTEGER);

    public void exportHistory(HistoryManager history, Binding timeBinding, Object from, Object end, OutputStream out) throws IOException, HistoryException {
        try {
            Bean[] items = history.getItems();
            this.beanArraySerializer.serialize(out, (Object)items);
            Bean[] beanArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Bean item = beanArray[n2];
                Datatype format = (Datatype)item.getField("format");
                String id = (String)item.getField("id");
                RecordBinding sampleBinding = (RecordBinding)Bindings.getBinding((Datatype)format);
                Serializer sampleSerializer = Bindings.getSerializer((Binding)sampleBinding);
                Object sample = sampleBinding.createDefault();
                StreamAccessor sa = history.openStream(id, "r");
                Stream stream = new Stream((ArrayAccessor)sa, sampleBinding);
                try {
                    int startIndex = stream.binarySearch((Binding)Bindings.DOUBLE, from);
                    if (startIndex < -stream.count()) {
                        this.intSerializer.serialize((Object)0, out);
                    } else {
                        int endIndex;
                        if (startIndex < 0) {
                            startIndex = -2 - startIndex;
                        }
                        if (startIndex == -1) {
                            startIndex = 0;
                        }
                        if ((endIndex = stream.binarySearch((Binding)Bindings.DOUBLE, end)) == -1) {
                            this.intSerializer.serialize((Object)0, out);
                        } else {
                            if (endIndex < 0) {
                                endIndex = -1 - endIndex;
                            }
                            if (endIndex == sa.size()) {
                                endIndex = sa.size() - 1;
                            }
                            if (endIndex < startIndex) {
                                this.intSerializer.serialize((Object)0, out);
                            } else {
                                int count = endIndex - startIndex + 1;
                                this.intSerializer.serialize((Object)count, out);
                                int i = 0;
                                while (i < count) {
                                    sa.get(i, (Binding)sampleBinding, sample);
                                    sampleSerializer.serialize(sample, out);
                                    ++i;
                                }
                            }
                        }
                    }
                }
                finally {
                    sa.close();
                }
                ++n2;
            }
        }
        catch (AccessorException ae) {
            throw new HistoryException(ae);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    public void importHistory(HistoryManager history, InputStream is) throws IOException, HistoryException {
        try {
            Bean[] items;
            ArrayList ids = new ArrayList();
            InputStreamReadable in = new InputStreamReadable(is, Long.MAX_VALUE);
            Bean[] beanArray = items = (Bean[])this.beanArraySerializer.deserialize((DataInput)in);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Bean item = beanArray[n2];
                StreamAccessor sa = null;
                try {
                    Datatype format = (Datatype)item.getField("format");
                    String id = (String)item.getField("id");
                    history.create(item);
                    RecordBinding sampleBinding = (RecordBinding)Bindings.getBinding((Datatype)format);
                    Serializer sampleSerializer = Bindings.getSerializer((Binding)sampleBinding);
                    Object sample = sampleBinding.createDefault();
                    sa = history.openStream(id, "rw");
                    int count = (Integer)this.intSerializer.deserialize((DataInput)in);
                    ids.clear();
                    int i = 0;
                    while (i < count) {
                        sample = sampleSerializer.deserializeToTry((DataInput)in, ids, sample);
                        sa.add((Binding)sampleBinding, sample);
                        ++i;
                    }
                }
                finally {
                    try {
                        if (sa != null) {
                            sa.close();
                        }
                    }
                    catch (AccessorException accessorException) {}
                }
                ++n2;
            }
        }
        catch (AccessorException ae) {
            throw new HistoryException(ae);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    public static class HistoryExport {
        public HistoryAndCollectorItem[] subscriptionItems;
        public Variant[] items;
    }
}

