/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.test;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.impl.CollectorState;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.utils.FileUtils;

public class TestPerformance {
    static final double NaN = Double.NaN;
    double[] data1 = new double[]{5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, Double.NaN, 10.0, Double.NaN, Double.NaN, Double.NaN};
    double[] data2 = new double[]{5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 9.0, 5.0, 4.0, 3.0};
    byte[] data3 = new byte[]{5, 6, 7, 8, 9, 10, 9, 5, 4, 3};
    SamplingFormat simple;
    SamplingFormat allfields;
    SamplingFormat vector;
    SamplingFormat minmax;
    SamplingFormat byteformat;
    SamplingFormat string;
    HistoryManager historian;
    File workarea;
    Collector collector;

    @Test
    public void testPerformance() throws Exception {
        File workarea = FileUtils.createTmpDir();
        this.byteformat = new SamplingFormat();
        this.byteformat.formatId = "byte";
        this.byteformat.format = new RecordType();
        this.byteformat.format = new RecordType();
        RecordType format = this.byteformat.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.BYTE);
        format.addComponent("lastValue", (Datatype)Datatypes.BYTE);
        format.addComponent("min", (Datatype)Datatypes.BYTE);
        format.addComponent("max", (Datatype)Datatypes.BYTE);
        format.addComponent("avg", (Datatype)Datatypes.DOUBLE);
        format.addComponent("median", (Datatype)Datatypes.BYTE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        this.byteformat.interval = Double.NaN;
        this.byteformat.deadband = Double.NaN;
        int z = 0;
        while (z < 20) {
            CollectorState cs = new CollectorState();
            this.historian = History.openFileHistory(workarea);
            this.collector = new CollectorImpl(this.historian);
            SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", this.byteformat);
            this.historian.create(hi);
            this.collector.addItem(hi);
            System.gc();
            long startTime = System.nanoTime();
            double[] data = this.data2;
            int j = 0;
            while (j < 10000) {
                int i = 0;
                while (i < data.length) {
                    this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                    this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                    this.collector.endStep();
                    ++i;
                }
                ++j;
            }
            this.collector.close();
            long elapsedtime = System.nanoTime() - startTime;
            System.out.println("Elapsed: " + elapsedtime / 1000L + "\u00b5s");
            ++z;
        }
        if (workarea != null) {
            try {
                FileUtils.deleteAll((File)workarea);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

