/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.impl.CollectorState;
import org.simantics.history.util.ProgressMonitor;
import org.simantics.history.util.Stream;
import org.simantics.history.util.StreamIterator;
import org.simantics.history.util.ValueBand;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.utils.FileUtils;

public class TestHistory {
    static final double NaN = Double.NaN;
    double[] data1 = new double[]{5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, Double.NaN, 10.0, Double.NaN, Double.NaN, Double.NaN};
    double[] data2 = new double[]{5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 9.0, 5.0, 4.0, 3.0};
    byte[] data3 = new byte[]{5, 6, 7, 8, 9, 10, 9, 5, 4, 3};
    SamplingFormat simple;
    SamplingFormat allfields;
    SamplingFormat vector;
    SamplingFormat minmax;
    SamplingFormat byteformat;
    SamplingFormat string;
    HistoryManager historian;
    File workarea;
    Collector collector;

    @Before
    public void initSubscriptionFormats() {
        this.simple = new SamplingFormat();
        this.simple.formatId = "simple";
        this.simple.format = new RecordType();
        RecordType format = this.simple.format;
        format.addComponent("time", (Datatype)Datatypes.FLOAT);
        format.addComponent("endTime", (Datatype)Datatypes.FLOAT);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        this.simple.interval = Double.NaN;
        this.simple.deadband = Double.NaN;
        this.string = new SamplingFormat();
        this.string.formatId = "string";
        this.string.format = new RecordType();
        format = this.string.format;
        format.addComponent("time", (Datatype)Datatypes.FLOAT);
        format.addComponent("endTime", (Datatype)Datatypes.FLOAT);
        format.addComponent("value", (Datatype)Datatypes.STRING);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        this.string.interval = Double.NaN;
        this.string.deadband = Double.NaN;
        this.allfields = new SamplingFormat();
        this.allfields.formatId = "alldata";
        this.allfields.format = new RecordType();
        format = this.allfields.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("lastValue", (Datatype)Datatypes.DOUBLE);
        format.addComponent("min", (Datatype)Datatypes.DOUBLE);
        format.addComponent("max", (Datatype)Datatypes.DOUBLE);
        format.addComponent("avg", (Datatype)Datatypes.DOUBLE);
        format.addComponent("median", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        this.allfields.interval = Double.NaN;
        this.allfields.deadband = Double.NaN;
        this.byteformat = new SamplingFormat();
        this.byteformat.formatId = "byte";
        this.byteformat.format = new RecordType();
        this.byteformat.format = new RecordType();
        format = this.byteformat.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.BYTE);
        format.addComponent("lastValue", (Datatype)Datatypes.BYTE);
        format.addComponent("min", (Datatype)Datatypes.BYTE);
        format.addComponent("max", (Datatype)Datatypes.BYTE);
        format.addComponent("avg", (Datatype)Datatypes.DOUBLE);
        format.addComponent("median", (Datatype)Datatypes.BYTE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        this.byteformat.interval = Double.NaN;
        this.byteformat.deadband = Double.NaN;
        this.vector = new SamplingFormat();
        this.vector.formatId = "vector";
        this.vector.format = new RecordType();
        this.vector.format = new RecordType();
        format = this.vector.format;
        format.addComponent("time", (Datatype)Datatypes.FLOAT);
        format.addComponent("endTime", (Datatype)Datatypes.FLOAT);
        format.addComponent("value", (Datatype)new ArrayType((Datatype)Datatypes.DOUBLE, Range.between((Limit)Limit.inclusive((Integer)3), (Limit)Limit.inclusive((Integer)3))));
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        this.vector.interval = Double.NaN;
        this.vector.deadband = Double.NaN;
        this.minmax = new SamplingFormat();
        this.minmax.formatId = "minmax";
        this.minmax.format = new RecordType();
        this.minmax.format = new RecordType();
        format = this.minmax.format;
        format.addComponent("time", (Datatype)Datatypes.FLOAT);
        format.addComponent("endTime", (Datatype)Datatypes.FLOAT);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("min", (Datatype)Datatypes.DOUBLE);
        format.addComponent("max", (Datatype)Datatypes.DOUBLE);
        this.minmax.interval = Double.MAX_VALUE;
        this.minmax.deadband = Double.MAX_VALUE;
    }

    @Before
    public void initHistory() {
        CollectorState cs = new CollectorState();
        this.workarea = FileUtils.createTmpDir();
        System.out.println(this.workarea);
        this.historian = History.openFileHistory(this.workarea);
        this.collector = new CollectorImpl(this.historian);
    }

    @After
    public void uninitHistory() {
        if (this.collector != null) {
            this.collector.close();
        }
        if (this.historian != null) {
            this.historian.close();
        }
        if (this.workarea != null) {
            try {
                FileUtils.deleteAll((File)this.workarea);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void testGetModifySubscription() throws Exception {
        SubscriptionItem hi = SubscriptionItem.createItem("NotMyVariable", "MySubscription", this.allfields);
        this.historian.create(hi);
        this.collector.addItem(hi);
        SubscriptionItem[] items = this.collector.getItems();
        Assert.assertEquals((long)1L, (long)items.length);
        SubscriptionItem hii = new SubscriptionItem();
        hii.readAvailableFields(items[0]);
        Assert.assertTrue((boolean)hii.equalContents((Object)hi));
        hi.variableId = "MyVariable";
        this.collector.setItem(hi);
        items = this.collector.getItems();
        Assert.assertEquals((long)1L, (long)items.length);
        hii.readAvailableFields(items[0]);
        Assert.assertTrue((boolean)hii.equalContents((Object)hi));
        this.collector.removeItem(hi.id);
        Assert.assertEquals((long)0L, (long)this.collector.getItems().length);
        this.collector.addItem(hi);
        this.collector.beginStep((NumberBinding)Bindings.DOUBLE, 5.0);
        hi.interval = 1.2;
        this.collector.setItem(hi);
        this.collector.endStep();
        this.collector.close();
        Bean bean = this.historian.getItem(hi.id);
        hi.interval = 0.0;
        hi.readAvailableFields(bean);
        Assert.assertEquals((double)1.2, (double)hi.interval, (double)0.1);
    }

    @Test
    public void failtestRecreateSubscription() throws HistoryException {
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", this.allfields);
        this.historian.create(hi);
        this.collector.addItem(hi);
        CollectorImpl collector2 = new CollectorImpl(this.historian);
        collector2.addItem(hi);
        try {
            this.collector.beginStep((NumberBinding)Bindings.DOUBLE, 0.0);
            collector2.beginStep((NumberBinding)Bindings.DOUBLE, 0.0);
            Assert.fail((String)"Recreate subscription should have failed");
        }
        catch (HistoryException historyException) {
            // empty catch block
        }
        collector2.close();
    }

    @Test
    public void failtestReopenStream() throws HistoryException {
        SamplingFormat format = this.allfields.clone();
        format.deadband = 2.5;
        Bean[] his = SubscriptionItem.createItems("MyVariable", "MySubscription", this.allfields, this.minmax);
        this.historian.create(his);
        StreamAccessor sa1 = null;
        StreamAccessor sa2 = null;
        try {
            sa1 = this.historian.openStream(his[0].id, "r");
            sa2 = this.historian.openStream(his[1].id, "r");
            Assert.fail((String)"HistoryManager must not allow to open two handles to same subscription");
        }
        catch (HistoryException historyException) {
            // empty catch block
        }
        try {
            if (sa1 != null) {
                sa1.close();
            }
            if (sa2 != null) {
                sa2.close();
            }
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        this.historian.delete(his[0].id, his[1].id);
    }

    @Test
    public void testDisableItem() throws Exception {
        ValueBand se;
        Object sample;
        Binding sampleBinding;
        SamplingFormat format = this.allfields.clone();
        format.deadband = 2.5;
        Bean[] hi = SubscriptionItem.createItems("MyVariable", "MySubscription", this.allfields, this.minmax);
        this.historian.create(hi);
        this.collector.addItems(hi);
        try {
            double[] data = this.data1;
            int i = 0;
            while (i < 4) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
            hi[0].enabled = false;
            this.collector.setItem(hi[0]);
            i = 4;
            while (i < 12) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
            hi[0].enabled = true;
            this.collector.setItem(hi[0]);
            i = 12;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi[0].id, "r");
        try {
            sampleBinding = Bindings.getBinding((Datatype)this.allfields.format);
            sample = aa.get(0, sampleBinding);
            se = new ValueBand(sampleBinding, sample);
            if (se.supportsNullValue()) {
                Assert.assertEquals((double)0.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
                Assert.assertEquals((double)0.3, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
                Assert.assertFalse((boolean)se.isNullValue());
                aa.get(1, sampleBinding, sample);
                Assert.assertEquals((double)0.4, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
                Assert.assertEquals((double)1.1, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
                Assert.assertTrue((boolean)se.isNullValue());
                aa.get(2, sampleBinding, sample);
                Assert.assertEquals((double)1.2, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            }
        }
        finally {
            aa.close();
        }
        aa = this.historian.openStream(hi[1].id, "r");
        try {
            Assert.assertEquals((long)1L, (long)aa.size());
            sampleBinding = Bindings.getBinding((Datatype)this.minmax.format);
            sample = aa.get(0, sampleBinding);
            se = new ValueBand(sampleBinding, sample);
            Assert.assertEquals((double)0.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)1.4, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMin((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)10.0, (double)((Double)se.getMax((Binding)Bindings.DOUBLE)), (double)0.01);
        }
        finally {
            aa.close();
        }
    }

    @Test
    public void testDeadband() throws Exception {
        SamplingFormat format = this.allfields.clone();
        format.deadband = 2.5;
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            Binding sampleBinding = Bindings.getBinding((Datatype)format.format);
            Object sample = aa.get(0, sampleBinding);
            ValueBand se = new ValueBand(sampleBinding, sample);
            Assert.assertEquals((double)0.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)0.7, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getValue((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMin((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)7.0, (double)((Double)se.getMax((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((long)8L, (long)se.getCount());
            aa.get(1, sampleBinding, sample);
            Assert.assertEquals((double)0.8, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)1.1, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)8.0, (double)((Double)se.getValue((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)9.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)8.0, (double)((Double)se.getMin((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)10.0, (double)((Double)se.getMax((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((long)4L, (long)se.getCount());
            aa.get(2, sampleBinding, sample);
            Assert.assertEquals((double)1.2, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)1.4, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getValue((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)4.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)3.0, (double)((Double)se.getMin((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMax((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((long)3L, (long)se.getCount());
        }
        finally {
            aa.close();
        }
    }

    @Test
    public void testMedianAndInterval() throws Exception {
        Object sample;
        SamplingFormat format = this.allfields.clone();
        format.interval = 1.0;
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        Binding sampleBinding = Bindings.getBinding((Datatype)format.format);
        this.collector.addItem(hi);
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            Assert.assertEquals((long)2L, (long)aa.size());
            sample = aa.get(0, sampleBinding);
            ValueBand se = new ValueBand(sampleBinding, sample);
            Assert.assertEquals((double)0.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)0.9, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)6.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
            aa.get(1, sampleBinding, sample);
            Assert.assertEquals((double)1.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)1.4, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
        }
        finally {
            aa.close();
        }
        this.collector = new CollectorImpl(this.historian);
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)(i + data.length) * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        aa = this.historian.openStream(hi.id, "r");
        try {
            Assert.assertEquals((long)3L, (long)aa.size());
            sample = aa.get(0, sampleBinding);
            ValueBand se = new ValueBand(sampleBinding, sample);
            Assert.assertEquals((double)0.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)0.9, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)6.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
            aa.get(1, sampleBinding, sample);
            Assert.assertEquals((double)1.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)2.1, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
            aa.get(2, sampleBinding, sample);
            Assert.assertEquals((double)2.2, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)2.9, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)7.0, (double)((Double)se.getMedian((Binding)Bindings.DOUBLE)), (double)0.01);
        }
        finally {
            aa.close();
        }
        this.historian.delete(hi.id);
    }

    @Test
    public void testAccessor() throws Exception {
        SamplingFormat format = this.allfields.clone();
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
            aa.reset();
            Assert.assertEquals((long)10L, (long)aa.size());
            i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)(i + data.length) * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
            aa.reset();
            Assert.assertEquals((long)20L, (long)aa.size());
            Binding sampleBinding = Bindings.getBinding((Datatype)format.format);
            int i2 = 0;
            while (i2 < aa.size()) {
                System.out.println(String.valueOf(i2) + ": " + sampleBinding.toString(aa.get(i2, sampleBinding)));
                ++i2;
            }
        }
        finally {
            aa.close();
            this.collector.close();
        }
    }

    @Test
    public void testArrayData() throws Exception {
        SamplingFormat format = this.vector.clone();
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        ArrayType vectorType = (ArrayType)((RecordType)format.format).getComponent((String)"value").type;
        DoubleArrayBinding vectorBinding = DoubleArrayBinding.createFrom((ArrayType)vectorType);
        int count = 20;
        try {
            double[] vector = new double[]{1.0, 2.0, 3.0};
            int i = 0;
            while (i < count) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                vector[0] = i;
                vector[1] = (double)i * 1.5 + 1.0;
                vector[2] = (double)i * -2.4 + 5.0;
                this.collector.setValue("MyVariable", (Binding)vectorBinding, vector);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            Assert.assertEquals((long)count, (long)aa.size());
        }
        finally {
            aa.close();
        }
        this.historian.delete(hi.id);
    }

    @Test
    public void testStringData() throws Exception {
        SamplingFormat format = this.string.clone();
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        StringBinding lineBinding = Bindings.STRING;
        int count = 20;
        try {
            int i = 0;
            while (i < count) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)lineBinding, "Line: " + i);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi.id, "rw");
        try {
            String line;
            Bean bean;
            Binding beanBinding = Bindings.getBeanBinding((Datatype)hi.format);
            Assert.assertEquals((long)count, (long)aa.size());
            int i = 0;
            while (i < count) {
                bean = (Bean)aa.get(i, beanBinding);
                line = (String)bean.getField("value");
                Assert.assertEquals((Object)("Line: " + i), (Object)line);
                ++i;
            }
            aa.remove(10, 2);
            Assert.assertEquals((long)(count - 2), (long)aa.size());
            i = 0;
            while (i < 10) {
                bean = (Bean)aa.get(i, beanBinding);
                line = (String)bean.getField("value");
                Assert.assertEquals((Object)("Line: " + i), (Object)line);
                ++i;
            }
            i = 10;
            while (i < 18) {
                bean = (Bean)aa.get(i, beanBinding);
                line = (String)bean.getField("value");
                Assert.assertEquals((Object)("Line: " + (i + 2)), (Object)line);
                ++i;
            }
        }
        finally {
            aa.close();
        }
        this.historian.delete(hi.id);
    }

    @Test
    public void testMinMax() throws Exception {
        SamplingFormat format = this.minmax.clone();
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        try {
            double[] data = this.data1;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            Assert.assertEquals((long)1L, (long)aa.size());
            Binding sampleBinding = Bindings.getBinding((Datatype)format.format);
            Object sample = aa.get(0, sampleBinding);
            ValueBand se = new ValueBand(sampleBinding, sample);
            Assert.assertEquals((double)0.0, (double)((Double)se.getTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)1.4, (double)((Double)se.getEndTime((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)5.0, (double)((Double)se.getMin((Binding)Bindings.DOUBLE)), (double)0.01);
            Assert.assertEquals((double)10.0, (double)((Double)se.getMax((Binding)Bindings.DOUBLE)), (double)0.01);
        }
        finally {
            aa.close();
        }
    }

    @Test
    public void testStream() throws Exception {
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", SamplingFormat.allfields);
        this.historian.create(hi);
        this.collector.addItem(hi);
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
            aa.reset();
            Stream stream = new Stream((ArrayAccessor)aa);
            Object sample0 = aa.get(0, (Binding)stream.sampleBinding);
            Object sample1 = aa.get(1, (Binding)stream.sampleBinding);
            Object sample = stream.getLowerSample((Binding)Bindings.DOUBLE, 0.0);
            Assert.assertNull((Object)sample);
            sample = stream.getLowerSample((Binding)Bindings.DOUBLE, 0.05);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getFloorSample((Binding)Bindings.DOUBLE, 0.05);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getFloorSample((Binding)Bindings.DOUBLE, 0.0);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getSample((Binding)Bindings.DOUBLE, 0.05);
            Assert.assertNull((Object)sample);
            sample = stream.getSample((Binding)Bindings.DOUBLE, 0.0);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getCeilingSample((Binding)Bindings.DOUBLE, -0.1);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getCeilingSample((Binding)Bindings.DOUBLE, 0.0);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getCeilingSample((Binding)Bindings.DOUBLE, 0.05);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample1));
            sample = stream.getHigherSample((Binding)Bindings.DOUBLE, -0.05);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample0));
            sample = stream.getHigherSample((Binding)Bindings.DOUBLE, 0.0);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample1));
            sample = stream.getHigherSample((Binding)Bindings.DOUBLE, 0.05);
            Assert.assertTrue((boolean)stream.sampleBinding.equals(sample, sample1));
            sample = stream.getHigherSample((Binding)Bindings.DOUBLE, 1.45);
            Assert.assertNull((Object)sample);
        }
        finally {
            aa.close();
            this.collector.close();
        }
    }

    @Test
    public void testByteData() throws Exception {
        SamplingFormat format = this.byteformat.clone();
        format.formatId = "test";
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
            StreamAccessor aa = this.historian.openStream(hi.id, "r");
            try {
                Assert.assertEquals((long)this.data3.length, (long)aa.size());
                Binding sampleBinding = Bindings.getBinding((Datatype)format.format);
                Object sample = aa.get(0, sampleBinding);
                ValueBand se = new ValueBand(sampleBinding, sample);
                int i2 = 0;
                while (i2 < this.data3.length) {
                    aa.get(i2, sampleBinding, se.getSample());
                    Assert.assertEquals((Object)this.data3[i2], (Object)se.getValue((Binding)Bindings.BYTE));
                    ++i2;
                }
            }
            finally {
                aa.close();
            }
        }
        finally {
            this.collector.close();
        }
    }

    @Test
    public void testCSVData() throws Exception {
        SamplingFormat format = this.simple.clone();
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        try {
            double[] data = this.data1;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        CSVFormatter csv = new CSVFormatter();
        csv.addItem(this.historian, hi.id, "MyVariable", "MyVariable", "m");
        csv.setTimeRange(0.9, 1.5);
        csv.setTimeStep(0.1);
        StringBuilder sb = new StringBuilder();
        csv.formulate2(new ProgressMonitor.Stub(), sb);
        System.out.println(sb);
    }

    @Test
    public void testExport() throws Exception {
        SamplingFormat format = this.byteformat.clone();
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", this.byteformat);
        this.historian.create(hi);
        this.collector.addItem(hi);
        try {
            double[] data = this.data2;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        History.exportHistory(this.historian, (Binding)Bindings.DOUBLE, -1.7976931348623157E308, Double.MAX_VALUE, os);
        HistoryManager historian2 = History.createMemoryHistory();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        History.importHistory(historian2, is);
        StreamAccessor aa = historian2.openStream(hi.id, "r");
        try {
            Assert.assertEquals((long)this.data3.length, (long)aa.size());
            Binding sampleBinding = Bindings.getBinding((Datatype)format.format);
            Object sample = aa.get(0, sampleBinding);
            ValueBand se = new ValueBand(sampleBinding, sample);
            int i = 0;
            while (i < this.data3.length) {
                aa.get(i, sampleBinding, se.getSample());
                Assert.assertEquals((Object)this.data3[i], (Object)se.getValue((Binding)Bindings.BYTE));
                ++i;
            }
        }
        finally {
            aa.close();
        }
    }

    @Test
    public void testStreamIterator() throws Exception {
        SamplingFormat format = this.allfields.clone();
        format.deadband = 0.05;
        SubscriptionItem hi = SubscriptionItem.createItem("MyVariable", "MySubscription", format);
        this.historian.create(hi);
        this.collector.addItem(hi);
        try {
            double[] data = this.data1;
            int i = 0;
            while (i < data.length) {
                this.collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                this.collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, data[i]);
                this.collector.endStep();
                ++i;
            }
        }
        finally {
            this.collector.close();
        }
        StreamAccessor aa = this.historian.openStream(hi.id, "r");
        try {
            StreamIterator si = new StreamIterator((ArrayAccessor)aa);
            while (si.hasNext()) {
                si.next();
                System.out.println(si);
            }
            si.gotoTime(-1.0);
            System.out.println(si);
            si.gotoTime(0.55);
            System.out.println(si);
            si.proceedToTime(0.6);
            System.out.println(si);
            si.proceedToTime(1.11);
            System.out.println(si);
            si.gotoTime(1.4);
            System.out.println(si);
            si.gotoTime(1.5);
            System.out.println(si);
        }
        finally {
            aa.close();
        }
    }
}

