/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.test;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.history.util.ValueBand;

public class TestBindingPerformance {
    public static void test(Binding b) throws Exception {
        Object s = b.createDefault();
        ValueBand band = new ValueBand(b, s);
        int i = 0;
        while (i < 10000000) {
            double value = i;
            band.setTime((Binding)Bindings.DOUBLE, value);
            band.setEndTime((Binding)Bindings.DOUBLE, value);
            band.setValue((Binding)Bindings.DOUBLE, value);
            band.setLastValue((Binding)Bindings.DOUBLE, value);
            band.setMin((Binding)Bindings.DOUBLE, value);
            band.setMax((Binding)Bindings.DOUBLE, value);
            band.setAvg((Binding)Bindings.DOUBLE, value);
            band.setMedian((Binding)Bindings.DOUBLE, value);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        Binding b1 = Bindings.getBinding(Sample.class);
        Binding b2 = Bindings.getBinding((Datatype)b1.type());
        TestBindingPerformance.test(b1);
        TestBindingPerformance.test(b2);
        long ct = System.currentTimeMillis();
        TestBindingPerformance.test(b1);
        System.out.println(System.currentTimeMillis() - ct);
        ct = System.currentTimeMillis();
        TestBindingPerformance.test(b2);
        System.out.println(System.currentTimeMillis() - ct);
    }

    public static class Sample {
        public double time;
        public double endTime;
        public double value;
        public double lastValue;
        public double min;
        public double max;
        public double avg;
        public double median;
        public byte quality;
        public int count;
    }
}

