/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileArrayAccessor;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.databoard.util.URIUtil;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.ByteBufferWriteable;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.utils.FileUtils;

public class FileHistory
implements HistoryManager {
    private static final boolean PROFILE = false;
    private static final boolean DEBUG = false;
    static Logger logger = Logger.getLogger(FileHistory.class.getName());
    static FilenameFilter txtFilter;
    static ArrayType INDEX_TYPE;
    File workarea;
    public boolean asyncUsage = true;

    static {
        INDEX_TYPE = Bindings.LONG_ARRAY.type();
        txtFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".txt");
            }
        };
    }

    public FileHistory(File workarea) {
        this.workarea = workarea;
    }

    public File getWorkarea() {
        return this.workarea;
    }

    @Override
    public void create(Bean ... items) throws HistoryException {
        try {
            Bean[] beanArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Bean item = beanArray[n2];
                this.writeMetadata(item);
                String id = (String)item.getField("id");
                File dataFile = this.toDataFile(id);
                dataFile.createNewFile();
                Datatype type = (Datatype)item.getField("format");
                if (this.isVariableWidth(type)) {
                    File indexFile = this.toIndexFile(id);
                    indexFile.createNewFile();
                }
                ++n2;
            }
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public void delete(String ... itemIds) throws HistoryException {
        String[] stringArray = itemIds;
        int n = itemIds.length;
        int n2 = 0;
        while (n2 < n) {
            String itemId = stringArray[n2];
            File meta = this.toMetaFile(itemId);
            File data = this.toDataFile(itemId);
            File index = this.toIndexFile(itemId);
            if (meta.exists() && !meta.delete()) {
                throw new HistoryException("Failed to delete " + meta);
            }
            if (data.exists() && !data.delete()) {
                throw new HistoryException("Failed to delete " + data);
            }
            if (!index.exists() || !index.delete()) {
                // empty if block
            }
            ++n2;
        }
    }

    @Override
    public void modify(Bean ... items) throws HistoryException {
        try {
            Bean[] beanArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Bean item = beanArray[n2];
                String id = (String)item.getField("id");
                File metaFile = this.toMetaFile(id);
                if (!metaFile.exists()) {
                    this.create(item);
                } else {
                    Bean oldItem = this.getItem(id);
                    File dataFile = this.toDataFile(id);
                    if (dataFile.exists()) {
                        boolean enabled = item.hasField("enabled") ? (Boolean)item.getFieldUnchecked("enabled") : true;
                        Datatype oldFormat = (Datatype)oldItem.getField("format");
                        Datatype newFormat = (Datatype)item.getField("format");
                        if (enabled && !oldFormat.equals((Object)newFormat)) {
                            try {
                                Binding oldBinding = Bindings.getBeanBinding((Datatype)oldFormat);
                                Binding newBinding = Bindings.getBeanBinding((Datatype)newFormat);
                                Serializer oldS = Bindings.getSerializer((Binding)oldBinding);
                                Serializer newS = Bindings.getSerializer((Binding)newBinding);
                                if (oldS.getConstantSize() == null || newS.getConstantSize() == null || oldS.getConstantSize() != newS.getConstantSize()) {
                                    throw new HistoryException("Changing of file format is not supported to: " + dataFile);
                                }
                                Adapter adapter = Bindings.getAdapter((Binding)oldBinding, (Binding)newBinding);
                                Object oldSample = oldBinding.createDefault();
                                Object newSample = newBinding.createDefault();
                                StreamAccessor sa = this.openStream(id, "rw");
                                try {
                                    int c = sa.size();
                                    int i = 0;
                                    while (i < c) {
                                        sa.get(i, oldBinding, oldSample);
                                        newSample = adapter.adapt(oldSample);
                                        sa.set(i, newBinding, newSample);
                                        ++i;
                                    }
                                }
                                finally {
                                    sa.close();
                                }
                            }
                            catch (AdapterConstructionException e) {
                                throw new HistoryException("Changing of file format is not supported to: " + id);
                            }
                            catch (SerializerConstructionException e) {
                                throw new HistoryException("Changing of file format is not supported to: " + id);
                            }
                            catch (AccessorException e) {
                                throw new HistoryException("Changing of file format failed to: " + id);
                            }
                            catch (AdaptException e) {
                                throw new HistoryException("Changing of file format failed to: " + id);
                            }
                        }
                    } else {
                        dataFile.createNewFile();
                    }
                    if (!this.equalsWithoutState(item, oldItem)) {
                        this.writeMetadata(item);
                    }
                }
                ++n2;
            }
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public Bean getItem(String itemId) throws HistoryException {
        return this.getItem(this.toMetaFile(itemId));
    }

    void writeMetadata(Bean item) throws HistoryException {
        try {
            String id = (String)item.getField("id");
            String idEnc = URIUtil.encodeURI((String)id);
            File metaFile = new File(this.workarea, String.valueOf(idEnc) + ".txt");
            Serializer typeSerializer = Bindings.getSerializer((Binding)Bindings.getBindingUnchecked(Datatype.class));
            Serializer beanSerializer = Bindings.getSerializer((Binding)item.getBinding());
            int size = typeSerializer.getSize((Object)item.getBinding().type()) + beanSerializer.getSize((Object)item);
            byte[] data = new byte[size];
            ByteBufferWriteable out = new ByteBufferWriteable(ByteBuffer.wrap(data));
            if (metaFile.exists() && this.asyncUsage) {
                File tmpFile = new File(this.workarea, String.valueOf(idEnc) + ".tmp");
                File tmp2File = new File(this.workarea, String.valueOf(idEnc) + ".tmp2");
                tmpFile.delete();
                typeSerializer.serialize((DataOutput)out, (Object)item.getBinding().type());
                beanSerializer.serialize((DataOutput)out, (Object)item);
                FileUtils.writeFile((File)tmpFile, (byte[])data);
                metaFile.renameTo(tmp2File);
                tmpFile.renameTo(metaFile);
                tmp2File.delete();
            } else {
                typeSerializer.serialize((DataOutput)out, (Object)item.getBinding().type());
                beanSerializer.serialize((DataOutput)out, (Object)item);
                FileUtils.writeFile((File)metaFile, (byte[])data);
            }
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    Bean getItem(File file) throws HistoryException {
        try {
            byte[] data = FileUtils.readFile((File)file);
            BinaryMemory in = new BinaryMemory(data);
            Serializer typeSerializer = Bindings.getSerializer((Binding)Bindings.getBindingUnchecked(Datatype.class));
            Datatype type = (Datatype)typeSerializer.deserialize((DataInput)in);
            Binding beanBinding = Bindings.getBeanBinding((Datatype)type);
            Serializer s = Bindings.getSerializer((Binding)beanBinding);
            Bean bean = (Bean)s.deserialize((DataInput)in);
            return bean;
        }
        catch (BufferUnderflowException e) {
            throw new HistoryException(e);
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
        catch (RuntimeBindingConstructionException e) {
            throw new HistoryException(e);
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    File toMetaFile(String itemId) {
        String name = String.valueOf(URIUtil.encodeURI((String)itemId)) + ".txt";
        File f = new File(this.workarea, name);
        return f;
    }

    File toDataFile(String itemId) {
        String name = String.valueOf(URIUtil.encodeURI((String)itemId)) + ".data";
        File f = new File(this.workarea, name);
        return f;
    }

    File toIndexFile(String itemId) {
        String name = String.valueOf(URIUtil.encodeURI((String)itemId)) + ".index";
        File f = new File(this.workarea, name);
        return f;
    }

    boolean isVariableWidth(Datatype type) throws HistoryException {
        try {
            Binding beanBinding = Bindings.getBeanBinding((Datatype)type);
            Serializer s = Bindings.getSerializer((Binding)beanBinding);
            return s.getConstantSize() == null;
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public Bean[] getItems() throws HistoryException {
        ArrayList<Bean> result = new ArrayList<Bean>();
        File[] files = this.workarea.listFiles(txtFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                result.add(this.getItem(file));
                ++n2;
            }
        }
        return result.toArray(new Bean[result.size()]);
    }

    @Override
    public void close() {
    }

    @Override
    public StreamAccessor openStream(String itemId, String mode) throws HistoryException {
        try {
            Bean bean = this.getItem(itemId);
            Datatype format = (Datatype)bean.getField("format");
            ArrayType arrayType = new ArrayType(format);
            File dataFile = this.toDataFile(itemId);
            if (this.isVariableWidth(format)) {
                File indexFile = this.toIndexFile(itemId);
                FileArrayAccessor index = Accessors.openStream((File)indexFile, (ArrayType)INDEX_TYPE, (String)mode);
                return (StreamAccessor)Accessors.openStream((File)dataFile, (ArrayType)arrayType, (String)mode, (ArrayAccessor)index);
            }
            return (StreamAccessor)Accessors.openStream((File)dataFile, (ArrayType)arrayType, (String)mode);
        }
        catch (AccessorConstructionException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public boolean exists(String itemId) throws HistoryException {
        return this.toMetaFile(itemId).exists();
    }

    public int hashCode() {
        return this.workarea.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileHistory)) {
            return false;
        }
        FileHistory other = (FileHistory)obj;
        return other.workarea.equals(this.workarea);
    }

    public String toString() {
        return "FileHistory: " + this.workarea;
    }

    private boolean equalsWithoutState(Bean i1, Bean i2) {
        Component[] components1 = i1.getBinding().type().getComponents();
        Component[] components2 = i2.getBinding().type().getComponents();
        int components = Math.min(components1.length, components2.length);
        int c = 0;
        while (c < components) {
            Object o1 = i1.getFieldUnchecked(c);
            Object o2 = i2.getFieldUnchecked(c);
            if ((!"collectorState".equals(components1[c].name) || o1 != null && o2 != null) && !ObjectUtils.objectEquals((Object)o1, (Object)o2)) {
                return false;
            }
            ++c;
        }
        return true;
    }
}

