/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.examples;

import java.io.File;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.History;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.utils.FileUtils;

public class HistoryExample2 {
    public static void main(String[] args) throws Exception {
        SamplingFormat simpleFormat = new SamplingFormat();
        simpleFormat.format = new RecordType();
        RecordType format = simpleFormat.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        simpleFormat.interval = Double.NaN;
        simpleFormat.deadband = Double.NaN;
        simpleFormat.formatId = "Simple";
        SamplingFormat intervalFormat = new SamplingFormat();
        intervalFormat.format = new RecordType();
        format = intervalFormat.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("lastValue", (Datatype)Datatypes.DOUBLE);
        format.addComponent("min", (Datatype)Datatypes.DOUBLE);
        format.addComponent("max", (Datatype)Datatypes.DOUBLE);
        format.addComponent("avg", (Datatype)Datatypes.DOUBLE);
        format.addComponent("median", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        intervalFormat.interval = Double.NaN;
        intervalFormat.deadband = Double.NaN;
        intervalFormat.interval = 0.5;
        intervalFormat.formatId = "Interval";
        Bean[] items = SubscriptionItem.createItems("Variable", "MySubscription", simpleFormat, intervalFormat);
        ItemManager im = new ItemManager(items);
        im.search("groupId", "MySubscription");
        File workarea = FileUtils.createTmpDir();
        HistoryManager historian = History.openFileHistory(workarea);
        historian.create(items);
        CollectorImpl collector = new CollectorImpl(historian);
        collector.addItems(items);
        try {
            double NaN = Double.NaN;
            double[] data = new double[]{5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, NaN, 10.0, NaN, NaN, NaN};
            int i = 0;
            while (i < data.length) {
                collector.beginStep((NumberBinding)Bindings.DOUBLE, (double)i * 0.1);
                collector.setValue("Variable", (Binding)Bindings.DOUBLE, data[i]);
                collector.endStep();
                ++i;
            }
        }
        finally {
            collector.close();
        }
        System.out.println("IntervalFormat = " + intervalFormat.toString());
        StreamAccessor sa = historian.openStream(items[1].id, "r");
        try {
            sa.reset();
            Datatype sampleType = sa.type().componentType;
            Binding beanBinding = Bindings.getBeanBinding((Datatype)sampleType);
            Bean sample = (Bean)beanBinding.createDefault();
            int i = 0;
            while (i < sa.size()) {
                sa.get(i, beanBinding, (Object)sample);
                System.out.println(sample);
                ++i;
            }
        }
        finally {
            sa.close();
        }
        System.out.println("\nSimpleFormat = " + simpleFormat.toString());
        sa = historian.openStream(items[0].id, "r");
        try {
            sa.reset();
            Binding b = Bindings.getBinding((Datatype)simpleFormat.format);
            Object sample = b.createDefault();
            int i = 0;
            while (i < sa.size()) {
                sa.get(i, b, sample);
                System.out.println(b.toString(sample));
                ++i;
            }
        }
        finally {
            sa.close();
        }
    }
}

