/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.examples;

import java.util.List;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryItem;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;

public class HistoryExample1 {
    public static void main(String[] args) throws HistoryException, BindingException, AccessorException {
        HistoryManager history = History.createMemoryHistory();
        RecordType sampleFormat = new RecordType();
        sampleFormat.addComponent("time", (Datatype)Datatypes.DOUBLE);
        sampleFormat.addComponent("value", (Datatype)Datatypes.DOUBLE);
        sampleFormat.addComponent("quality", (Datatype)Datatypes.BYTE);
        String id = UUID.randomUUID().toString();
        HistoryItem hi = new HistoryItem(id, (Datatype)sampleFormat);
        history.create(new Bean[]{hi});
        StreamAccessor sa = history.openStream(id, "rw");
        RecordBinding sampleBinding = (RecordBinding)Bindings.getBeanBinding((Datatype)sampleFormat);
        Bean sample = (Bean)sampleBinding.createPartial();
        try {
            sample.setField(2, (Binding)Bindings.BYTE, (Object)0);
            int i = 0;
            while (i < 10) {
                sample.setField(0, (Binding)Bindings.DOUBLE, (Object)(1.0 * (double)i));
                sample.setField(1, (Binding)Bindings.DOUBLE, (Object)(100.0 * (double)i));
                sa.add((Binding)sampleBinding, (Object)sample);
                ++i;
            }
        }
        finally {
            sa.flush();
            sa.close();
        }
        StreamAccessor aa = history.openStream(id, "r");
        RecordType sampleType = (RecordType)aa.type().componentType;
        RecordBinding sampleBinding2 = (RecordBinding)Bindings.getBeanBinding((Datatype)sampleType);
        Bean sample2 = (Bean)sampleBinding2.createPartial();
        try {
            int i = 0;
            while (i < aa.size()) {
                aa.get(i, (Binding)sampleBinding2, (Object)sample2);
                System.out.println(String.valueOf(i) + ": " + sample2);
                ++i;
            }
        }
        finally {
            aa.close();
        }
        Bean[] items = history.getItems();
        ItemManager im = new ItemManager(items);
        System.out.println("Items Identifiers:");
        String[] stringArray = im.toIdArray();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String itemId = stringArray[n2];
            System.out.println(itemId);
            ++n2;
        }
        List<Bean> result = im.search("id", id);
        im.search("format", sampleFormat);
        im.search("interval", 0.1);
    }
}

