/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.examples;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryAndCollectorItem;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.FlushPolicy;

public class CollectorExample2 {
    public static void main(String[] args) throws HistoryException, BindingException, AccessorException {
        HistoryManager history = History.createMemoryHistory();
        RecordType sampleFormat = new RecordType();
        sampleFormat.addComponent("time", (Datatype)Datatypes.DOUBLE);
        sampleFormat.addComponent("value", (Datatype)Datatypes.DOUBLE);
        sampleFormat.addComponent("quality", (Datatype)Datatypes.BYTE);
        HistoryAndCollectorItem i1 = new HistoryAndCollectorItem();
        i1.id = "MyVariable-interval=0.5";
        i1.format = sampleFormat;
        i1.interval = 0.5;
        i1.variableId = "MyVariable";
        HistoryAndCollectorItem i2 = new HistoryAndCollectorItem();
        i2.id = "MyVariable-deadband=5";
        i2.format = sampleFormat;
        i2.deadband = 5.0;
        i2.variableId = "MyVariable";
        history.create(new Bean[]{i1, i2});
        Collector collector = History.createCollector(history, FlushPolicy.NoFlush);
        collector.addItem((Bean)i1);
        collector.addItem((Bean)i2);
        try {
            int i = 0;
            while (i < 100) {
                double time = (double)i * 0.1;
                double myItemValue = -20.0 + (double)i * 0.1;
                collector.beginStep((NumberBinding)Bindings.DOUBLE, time);
                collector.setValue("MyVariable", (Binding)Bindings.DOUBLE, myItemValue);
                collector.endStep();
                ++i;
            }
        }
        finally {
            collector.flush();
            collector.close();
        }
    }
}

