/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.examples;

import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryAndCollectorItem;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryItem;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.FlushPolicy;

public class CollectorExample1 {
    public static void main(String[] args) throws HistoryException, BindingException, AccessorException {
        HistoryManager history = History.createMemoryHistory();
        RecordType sampleFormat = new RecordType();
        sampleFormat.addComponent("time", (Datatype)Datatypes.DOUBLE);
        sampleFormat.addComponent("value", (Datatype)Datatypes.DOUBLE);
        sampleFormat.addComponent("quality", (Datatype)Datatypes.BYTE);
        String id = UUID.randomUUID().toString();
        HistoryItem historyItem = new HistoryItem(id, (Datatype)sampleFormat);
        history.create(new Bean[]{historyItem});
        Collector collector = History.createCollector(history, FlushPolicy.NoFlush);
        Bean hi = history.getItem(id);
        HistoryAndCollectorItem ci = new HistoryAndCollectorItem();
        ci.readAvailableFields(hi);
        ci.interval = 0.5;
        ci.enabled = true;
        ci.gain = 10.0;
        ci.variableId = "MyItem";
        collector.addItem((Bean)ci);
        try {
            int i = 0;
            while (i < 100) {
                double time = (double)i * 0.1;
                double myItemValue = -20.0 + (double)i * 0.1;
                collector.beginStep((NumberBinding)Bindings.DOUBLE, time);
                collector.setValue("MyItem", (Binding)Bindings.DOUBLE, myItemValue);
                collector.endStep();
                ++i;
            }
        }
        finally {
            collector.flush();
            collector.close();
        }
        StreamAccessor aa = history.openStream(id, "r");
        RecordType sampleType = (RecordType)aa.type().componentType;
        RecordBinding sampleBinding = (RecordBinding)Bindings.getBeanBinding((Datatype)sampleType);
        Bean sample = (Bean)sampleBinding.createPartial();
        try {
            int i = 0;
            while (i < aa.size()) {
                aa.get(i, (Binding)sampleBinding, (Object)sample);
                System.out.println(String.valueOf(i) + ": " + sample);
                ++i;
            }
        }
        finally {
            aa.close();
        }
    }
}

