/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.management.factory;

import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.SessionManagerSource;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.auth.UserAuthenticationAgents;
import org.simantics.db.common.auth.UserAuthenticators;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.services.GlobalServiceInitializer;
import org.simantics.layer0.Layer0;

public class SessionFactory {
    public String serverHost;
    public int serverPort;
    public UserAuthenticationAgent authenticator;

    public SessionFactory() {
        this.serverHost = "localhost";
        this.serverPort = 6668;
        this.authenticator = UserAuthenticationAgents.staticAgent((UserAuthenticator)UserAuthenticators.byNameAndPassword((String)"Default User", (String)""));
    }

    public SessionFactory(String host, int port) {
        this.serverHost = host;
        this.serverPort = port;
        this.authenticator = UserAuthenticationAgents.staticAgent((UserAuthenticator)UserAuthenticators.byNameAndPassword((String)"Default User", (String)""));
    }

    public Session create() throws DatabaseException, IOException {
        InetSocketAddress addr = InetSocketAddress.createUnresolved(this.serverHost, this.serverPort);
        ProCoreServerReference serverReference = new ProCoreServerReference(addr);
        ProCoreSessionReference sessionReference = new ProCoreSessionReference(serverReference, -1L);
        Session session = SessionManagerSource.getSessionManager().createSession((SessionReference)sessionReference, this.authenticator);
        ReadRequest req = new ReadRequest(){

            public void run(ReadGraph g) {
                Layer0.getInstance((ReadGraph)g);
            }
        };
        session.syncRequest((Read)req);
        new GlobalServiceInitializer().initialize(session);
        return session;
    }
}

