/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.management.discovery;

import org.eclipse.core.runtime.Assert;
import org.simantics.db.ServerAddress;
import org.simantics.db.service.ServerInformation;

public class ServerInfo {
    public static final ServerInfo[] NONE = new ServerInfo[0];
    private final String name;
    private final ServerAddress address;
    private final ServerInformation info;
    private final String aux_info;

    public ServerInfo(String name) {
        Assert.isNotNull((Object)name, (String)"Server name must be non-null");
        this.name = name;
        this.address = null;
        this.info = null;
        this.aux_info = null;
    }

    public ServerInfo(String name, String address) throws IllegalArgumentException {
        this(name, address, null, null);
    }

    public ServerInfo(String name, String address, String aux_info) throws IllegalArgumentException {
        this(name, address, null, aux_info);
    }

    public ServerInfo(String name, ServerAddress address) {
        this(name, address, null, null);
    }

    public ServerInfo(String name, ServerAddress address, String aux_info) {
        this(name, address, null, aux_info);
    }

    public ServerInfo(String name, String address, ServerInformation info) throws IllegalArgumentException {
        this(name, address, info, null);
    }

    public ServerInfo(String name, String address, ServerInformation info, String aux_info) throws IllegalArgumentException {
        this.name = name;
        this.address = address == null ? null : new ServerAddress(address);
        this.info = info;
        this.aux_info = aux_info;
    }

    public ServerInfo(String name, ServerAddress address, ServerInformation info) {
        this(name, address, info, null);
    }

    public ServerInfo(String name, ServerAddress address, ServerInformation info, String aux_info) {
        this.name = name;
        this.address = address;
        this.info = info;
        this.aux_info = aux_info;
    }

    public String getName() {
        return this.name;
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public ServerInformation getInfo() {
        return this.info;
    }

    public String getAuxInfo() {
        return this.aux_info;
    }

    public String toString() {
        String str = String.valueOf(this.name) + " " + this.address;
        if (this.aux_info != null) {
            str = String.valueOf(str) + " " + this.aux_info;
        }
        return str;
    }

    public int hashCode() {
        return this.address == null ? 0 : this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerInfo other = (ServerInfo)obj;
        if (this.address == null) {
            if (other.address != null) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
        } else if (!this.address.equals((Object)other.address)) {
            return false;
        }
        return true;
    }

    public ServerInfo withAddress(ServerAddress address) {
        return new ServerInfo(this.name, address);
    }
}

