/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.management;

import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.Disposable;
import org.simantics.db.ReadGraph;
import org.simantics.db.ServerAddress;
import org.simantics.db.Session;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.VirtualGraph;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.processor.MergingDelayedWriteProcessor;
import org.simantics.db.common.processor.MergingGraphRequestProcessor;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.internal.Activator;
import org.simantics.db.management.internal.SessionManagerProvider;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.services.GlobalServiceInitializer;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.disposable.IDisposeListener;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public class SessionContext
extends HintContext
implements ISessionContext,
Disposable {
    private static final boolean SESSION_DEBUG = false;
    private final ServerAddress address;
    private Session session;
    private UserAuthenticationAgent authenticator;
    private boolean servicesRegistered = false;
    private IStatus servicesRegisteredStatus = null;
    SyncListenerList<IDisposeListener> disposeListeners = null;
    private DisposeState disposeStatus = DisposeState.Alive;
    private static final Method onDisposed = SyncListenerList.getMethod(IDisposeListener.class, (String)"onDisposed");

    public static SessionContext create(Session session, boolean initialize) throws DatabaseException {
        return new SessionContext(session, initialize);
    }

    public static SessionContext openSession(ServerAddress info, UserAuthenticationAgent auth) throws IOException, DatabaseException {
        return new SessionContext(info, auth, false);
    }

    public static SessionContext openAndInitializeSession(ServerAddress info, UserAuthenticationAgent auth) throws IOException, DatabaseException {
        return new SessionContext(info, auth, true);
    }

    private static SessionReference createSessionReference(ServerAddress address, long sessionId) throws UnknownHostException {
        ProCoreServerReference server = new ProCoreServerReference(address.getAddress(), address.getDbid());
        ProCoreSessionReference ref = new ProCoreSessionReference(server, sessionId);
        return ref;
    }

    private SessionContext(ServerAddress addr, UserAuthenticationAgent auth, boolean initialize) throws IOException, DatabaseException {
        if (addr == null) {
            throw new IllegalArgumentException("null address");
        }
        this.address = addr;
        this.authenticator = auth;
        SessionManager sessionManager = SessionManagerProvider.getInstance().getSessionManager();
        if (initialize) {
            this.initializeSession(sessionManager);
        } else {
            SessionReference ref = SessionContext.createSessionReference(addr, -1L);
            this.session = sessionManager.createSession(ref, auth);
        }
    }

    private SessionContext(Session session, boolean initialize) throws DatabaseException {
        if (initialize) {
            this.initializeSession(session);
        }
        ProCoreServerReference ref = (ProCoreServerReference)((LifecycleSupport)session.getService(LifecycleSupport.class)).getSessionReference().getServerReference();
        this.address = new ServerAddress(ref.socketAddress, ref.dbid);
        this.session = session;
    }

    private void initializeSession(SessionManager sessionManager) throws DatabaseException, IOException {
        Session s = null;
        boolean success = false;
        try {
            SessionReference ref = SessionContext.createSessionReference(this.address, -1L);
            s = sessionManager.createSession(ref, this.authenticator);
            this.initializeSession(s);
            this.session = s;
            success = true;
        }
        finally {
            if (!success && s != null) {
                LifecycleSupport support = (LifecycleSupport)s.getService(LifecycleSupport.class);
                support.close();
            }
        }
    }

    private void initializeSession(Session s) throws DatabaseException {
        s.registerService(MergingGraphRequestProcessor.class, (Object)new MergingGraphRequestProcessor("SessionService", (AsyncRequestProcessor)s, 20L));
        s.registerService(MergingDelayedWriteProcessor.class, (Object)new MergingDelayedWriteProcessor((AsyncRequestProcessor)s, 20L));
        s.registerService(VirtualGraph.class, (Object)((VirtualGraphSupport)s.getService(VirtualGraphSupport.class)).getMemoryPersistent(UUID.randomUUID().toString()));
        s.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) {
                Layer0.getInstance((ReadGraph)g);
            }
        });
    }

    public void registerServices() {
        if (this.servicesRegistered) {
            return;
        }
        this.servicesRegisteredStatus = new GlobalServiceInitializer().initialize(this.session);
        if (!this.servicesRegisteredStatus.isOK()) {
            Activator.getDefault().getLog().log(this.servicesRegisteredStatus);
        }
        this.servicesRegistered = true;
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            throw new IllegalStateException("SessionContext is disposed");
        }
        return this.session;
    }

    @Override
    public Session peekSession() {
        return this.session;
    }

    protected void doDispose() {
        try {
            this.doClose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IllegalStateException, InterruptedException, TimeoutException {
        try {
            this.dispose();
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof TimeoutException) {
                throw (TimeoutException)t;
            }
            throw e;
        }
    }

    private void doClose() throws DatabaseException {
        for (IHintContext.Key k : this.getHints().keySet()) {
            Object o;
            if (k == null || !((o = this.removeHint(k)) instanceof IDisposable)) continue;
            ((IDisposable)o).safeDispose();
        }
        if (this.session != null) {
            LifecycleSupport support = (LifecycleSupport)this.session.getService(LifecycleSupport.class);
            support.close(0L, true);
            this.session = null;
        }
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SessionContext other = (SessionContext)obj;
        if (!this.address.equals((Object)other.address)) {
            return false;
        }
        return this.session.equals(other.session);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SessionContext [info=" + this.address + ", hints=");
        s.append(Arrays.toString(this.getHints().values().toArray()));
        s.append("]");
        return s.toString();
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new AssertionError((Object)(this + " is disposed."));
        }
    }

    public DisposeState getDisposeState() {
        return this.disposeStatus;
    }

    public boolean isDisposed() {
        return this.disposeStatus == DisposeState.Disposed;
    }

    public boolean isAlive() {
        return this.disposeStatus == DisposeState.Alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void dispose() {
        try {
            block19: {
                SessionContext sessionContext = this;
                // MONITORENTER : sessionContext
                if (this.disposeStatus != DisposeState.Disposing) break block19;
                // MONITOREXIT : sessionContext
                SessionContext sessionContext2 = this;
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : sessionContext
                        throw throwable;
                    }
                }
                // MONITORENTER : sessionContext2
                this.disposeStatus = DisposeState.Disposed;
                // MONITOREXIT : sessionContext2
                return;
            }
            this.assertNotDisposed();
            this.disposeStatus = DisposeState.Disposing;
            // MONITOREXIT : sessionContext
        }
        catch (Throwable throwable) {
            SessionContext sessionContext = this;
            // MONITORENTER : sessionContext
            this.disposeStatus = DisposeState.Disposed;
            // MONITOREXIT : sessionContext
            throw throwable;
        }
        {
            try {
                this.fireDisposed();
            }
            finally {
                this.doDispose();
            }
        }
        SessionContext sessionContext = this;
        // MONITORENTER : sessionContext
        this.disposeStatus = DisposeState.Disposed;
        // MONITOREXIT : sessionContext
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void safeDispose() {
        try {
            block19: {
                SessionContext sessionContext = this;
                // MONITORENTER : sessionContext
                if (this.disposeStatus == DisposeState.Alive) break block19;
                // MONITOREXIT : sessionContext
                SessionContext sessionContext2 = this;
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : sessionContext
                        throw throwable;
                    }
                }
                // MONITORENTER : sessionContext2
                this.disposeStatus = DisposeState.Disposed;
                // MONITOREXIT : sessionContext2
                return;
            }
            this.disposeStatus = DisposeState.Disposing;
            // MONITOREXIT : sessionContext
        }
        catch (Throwable throwable) {
            SessionContext sessionContext = this;
            // MONITORENTER : sessionContext
            this.disposeStatus = DisposeState.Disposed;
            // MONITOREXIT : sessionContext
            throw throwable;
        }
        {
            try {
                this.fireDisposed();
            }
            finally {
                this.doDispose();
            }
        }
        SessionContext sessionContext = this;
        // MONITORENTER : sessionContext
        this.disposeStatus = DisposeState.Disposed;
        // MONITOREXIT : sessionContext
        return;
    }

    protected boolean hasDisposeListeners() {
        return this.disposeListeners != null && !this.disposeListeners.isEmpty();
    }

    private void fireDisposed() {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.fireEventSync(onDisposed, new Object[]{this});
    }

    private void fireDisposedAsync() {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.fireEventAsync(onDisposed, new Object[]{this});
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.lazyGetListenerList().add((Object)listener);
    }

    public void addDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        this.lazyGetListenerList().add(thread, (Object)listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove((Object)listener);
    }

    public void removeDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove(thread, (Object)listener);
    }

    private synchronized SyncListenerList<IDisposeListener> lazyGetListenerList() {
        if (this.disposeListeners == null) {
            this.disposeListeners = new SyncListenerList(IDisposeListener.class);
        }
        return this.disposeListeners;
    }

    protected void finalize() throws Throwable {
        try {
            this.safeDispose();
        }
        finally {
            super.finalize();
        }
    }
}

