/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.layer0.request.PossibleActiveVariableFromVariable;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.request.PossibleVariableIndexRoot;
import org.simantics.db.layer0.request.PossibleVariableModel;
import org.simantics.db.layer0.request.ResourceURIToVariable;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableRepository;
import org.simantics.db.layer0.variable.VariablesImpl;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulator.variable.exceptions.NodeIsNotValidAnymoreException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public final class Variables {
    public static final Variant PENDING_NODE_VALUE = new Variant();
    public static final NodeStructure PENDING_NODE_STRUCTURE = new NodeStructure();
    @Deprecated
    public static final String PREDICATE = "PREDICATE";
    @Deprecated
    public static final String NAME = "HasName";
    public static final String CLASSIFICATIONS = "classifications";
    public static final String EXPRESSION = "HasExpression";
    public static final String INPUT_VALIDATOR = "HasInputValidator";
    public static final String INPUT_MODIFIER = "HasInputModifier";
    public static final String FORMATTER = "HasFormatter";
    public static final String STANDARD_RESOURCE = "hasStandardResource";
    @Deprecated
    public static final String REPRESENTS = "Represents";
    public static final String TYPE = "Type";
    public static final String URI = "URI";
    @Deprecated
    public static final String SERIALISED = "Serialised";
    @Deprecated
    public static final String PARENT = "Parent";
    public static final String ROLE = "Role";
    public static final String DATATYPE = "DATATYPE";
    public static final String UNIT = "UNIT";
    public static final String VALID = "valid";
    public static final String REQUIRED = "required";
    public static final String DEFAULT = "default";
    public static final String READONLY = "readOnly";
    public static final String VALIDATOR = "validator";
    @Deprecated
    public static final String PROPERTY_LABEL = "PROPERTY_LABEL";
    public static final String LABEL = "HasLabel";
    public static final String ENUMERATION_VALUES = "HasEnumerationValues";
    public static final String CUSTOM_MODIFIER = "HasCustomModifier";
    public static final String DISPLAY_COLUMN = "HasDisplayColumn";
    public static final String DISPLAY_PROPERTY = "HasDisplayProperty";
    public static final String DISPLAY_VALUE = "HasDisplayValue";
    public static final String DISPLAY_UNIT = "HasDisplayUnit";
    public static final String CONVERTED_VALUE = "convertedValue";
    public static final String ARRAY_SIZE = "ARRAY_SIZE";
    @Deprecated
    public static final String RESOURCE = "Resource";
    @Deprecated
    public static final String CONTAINER_RESOURCE = "ContainerResource";
    @Deprecated
    public static final String PROPERTY_RESOURCE = "PROPERTY_RESOURCE";
    @Deprecated
    public static final String[] builtins = new String[]{"Represents", "Type", "Resource", "URI", "Serialised", "Parent", "Role"};

    public static Variable getPossibleVariable(ReadGraph graph, Resource resource) throws DatabaseException {
        String uri = graph.getPossibleURI(resource);
        return uri != null ? Variables.getPossibleVariable(graph, uri) : null;
    }

    public static Variable getPossibleVariable(ReadGraph graph, String uri) throws DatabaseException {
        try {
            return Variables.getVariable(graph, uri);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public static Variable getVariable(ReadGraph graph, Resource resource) throws DatabaseException {
        return Variables.getVariable(graph, graph.getURI(resource));
    }

    public static Variable getVariable(ReadGraph graph, String uri) throws DatabaseException {
        try {
            return (Variable)graph.sync((ReadInterface)new ResourceURIToVariable(uri));
        }
        catch (MissingVariableException e) {
            return VariableRepository.get(graph, uri);
        }
    }

    private static int commonPrefixLength(String a, String b) {
        int maxC = Math.min(a.length(), b.length());
        int c = 0;
        while (c < maxC) {
            if (a.charAt(c) != b.charAt(c)) {
                return c;
            }
            ++c;
        }
        return maxC;
    }

    private static boolean isSplitPos(String str, int p) {
        if (p == str.length()) {
            return true;
        }
        char c = str.charAt(p);
        return c == '/' || c == '#';
    }

    private static int pathLength(String path) {
        int count = 0;
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '/' || c == '#') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static String prefixByParentPath(int parentPathLength, String suffix) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < parentPathLength) {
            b.append('.');
            ++i;
        }
        b.append(suffix);
        return b.toString();
    }

    public static String getRVI(ReadGraph graph, Variable base, Variable other) throws DatabaseException {
        String baseURI = (String)graph.syncRequest((Read)new VariableURI(base));
        String otherURI = (String)graph.syncRequest((Read)new VariableURI(other));
        return Variables.getRelativeRVI(baseURI, otherURI);
    }

    public static String getRelativeRVI(String baseURI, String otherURI) {
        int prefixLength = Variables.commonPrefixLength(baseURI, otherURI);
        if (!Variables.isSplitPos(baseURI, prefixLength) || !Variables.isSplitPos(otherURI, prefixLength)) {
            --prefixLength;
            while (prefixLength > 0 && !Variables.isSplitPos(baseURI, prefixLength)) {
                --prefixLength;
            }
        }
        if (prefixLength == baseURI.length()) {
            return otherURI.substring(prefixLength);
        }
        return Variables.prefixByParentPath(Variables.pathLength(baseURI.substring(prefixLength)), otherURI.substring(prefixLength));
    }

    public static String getRVI2(ReadGraph graph, Variable base, Variable other) throws DatabaseException {
        TObjectIntHashMap baseLength = new TObjectIntHashMap();
        int depth = 0;
        while (base != null) {
            baseLength.put((Object)base, depth);
            base = base.getParent(graph);
            ++depth;
        }
        Variable cur = other;
        while (!baseLength.containsKey((Object)cur)) {
            cur = cur.getParent(graph);
        }
        String curURI = cur.getURI(graph);
        String otherURI = other.getURI(graph);
        return Variables.prefixByParentPath(baseLength.get((Object)cur), otherURI.substring(curURI.length()));
    }

    public static String getProjectRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource project = Variables.getProject(graph, variable);
        String projectURI = graph.getURI(project);
        return variable.getURI(graph).substring(projectURI.length());
    }

    private static int getSegmentEnd(String suffix) {
        int pos = 1;
        while (pos < suffix.length()) {
            char c = suffix.charAt(pos);
            if (c == '/' || c == '#') break;
            ++pos;
        }
        return pos;
    }

    public static String getRVI(String rvi, String suffix) throws DatabaseException {
        if (suffix.isEmpty()) {
            return rvi;
        }
        switch (suffix.charAt(0)) {
            case '.': {
                return Variables.getRVI(URIStringUtils.getRVIParent((String)rvi), suffix.substring(1));
            }
            case '#': {
                int segmentEnd = Variables.getSegmentEnd(suffix);
                return Variables.getRVI(String.valueOf(rvi) + "#" + suffix.substring(1, segmentEnd), suffix.substring(segmentEnd));
            }
            case '/': {
                int segmentEnd = Variables.getSegmentEnd(suffix);
                return Variables.getRVI(String.valueOf(rvi) + "/" + suffix.substring(1, segmentEnd), suffix.substring(segmentEnd));
            }
        }
        return null;
    }

    public static Variable getRootVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.adapt(graph.getRootLibrary(), Variable.class);
    }

    public static Resource getPossibleIndexRoot(ReadGraph graph, Variable variable) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleVariableIndexRoot(variable));
    }

    public static Resource getModel(ReadGraph graph, Variable variable) throws DatabaseException {
        String URI2 = variable.getURI(graph);
        return VariablesImpl.getFirst(graph, SimulationResource.getInstance((ReadGraph)graph).Model, URI2, 8);
    }

    public static Resource getPossibleModel(ReadGraph graph, Variable variable) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleVariableModel(variable));
    }

    public static Resource getProject(ReadGraph graph, Variable variable) throws DatabaseException {
        String URI2 = variable.getURI(graph);
        return VariablesImpl.getFirst(graph, ProjectResource.getInstance((ReadGraph)graph).Project, URI2, 8);
    }

    public static Variable getConfigurationContext(ReadGraph graph, Resource resource) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(resource, SIMU.Model)) {
            resource = (Resource)graph.sync((ReadInterface)new Model(resource));
        }
        Resource configurationResource = graph.getSingleObject(resource, SIMU.HasConfiguration);
        return Variables.getVariable(graph, configurationResource);
    }

    public static Resource getConfigurationContextResource(ReadGraph graph, Resource resource) throws DatabaseException {
        Variable config = Variables.getConfigurationContext(graph, resource);
        return config.getRepresents(graph);
    }

    public static Variable getConfigurationContext(ReadGraph graph, Variable variable) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getModel(graph, variable);
        Resource configurationResource = graph.getSingleObject(model, SIMU.HasConfiguration);
        return Variables.getVariable(graph, configurationResource);
    }

    public static Resource getPossibleConfigurationContextResource(ReadGraph graph, Resource resource) throws DatabaseException {
        Variable config = Variables.getPossibleConfigurationContext(graph, resource);
        return config != null ? config.getPossibleRepresents(graph) : null;
    }

    public static Variable getPossibleConfigurationContext(ReadGraph graph, Resource resource) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(resource, SIMU.Model)) {
            resource = (Resource)graph.sync((ReadInterface)new PossibleModel(resource));
        }
        if (resource == null) {
            return null;
        }
        Resource configurationResource = graph.getPossibleObject(resource, SIMU.HasConfiguration);
        if (configurationResource == null) {
            return null;
        }
        return Variables.getPossibleVariable(graph, configurationResource);
    }

    public static Variable getPossibleConfigurationContext(ReadGraph graph, Variable variable) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getPossibleModel(graph, variable);
        if (model == null) {
            return null;
        }
        Resource configurationResource = graph.getPossibleObject(model, SIMU.HasConfiguration);
        if (configurationResource == null) {
            return null;
        }
        return Variables.getPossibleVariable(graph, configurationResource);
    }

    public static Variable getConfigurationVariable(ReadGraph graph, Resource resource, String RVI2) throws DatabaseException {
        Variable context = Variables.getConfigurationContext(graph, resource);
        return context.browse(graph, RVI2);
    }

    public static Variable getConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getConfigurationContext(graph, variable);
        RVI rvi = variable.getRVI(graph);
        return rvi.resolve(graph, context);
    }

    public static Variable getPossibleConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getPossibleConfigurationContext(graph, variable);
        if (context == null) {
            return null;
        }
        try {
            RVI rvi = variable.getRVI(graph);
            return rvi.resolvePossible(graph, context);
        }
        catch (MissingVariableException e) {
            return null;
        }
    }

    public static Datatype getDatatype(ReadGraph graph, Resource resource, RVI rvi) throws DatabaseException {
        Variable var = rvi.resolve(graph, Variables.getConfigurationContext(graph, resource));
        return var.getDatatype(graph);
    }

    @Deprecated
    public static Resource getRealization(ReadGraph graph, Variable variable) throws DatabaseException {
        String URI2 = variable.getURI(graph);
        return VariablesImpl.getFirst(graph, Layer0X.getInstance((ReadGraph)graph).Realization, URI2, 8);
    }

    public static boolean isContext(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource type = variable.getPossibleType(graph);
        return type != null && graph.isInheritedFrom(type, Layer0.getInstance((ReadGraph)graph).RVIContext);
    }

    public static Variable getPossibleContext(ReadGraph graph, Variable variable) throws DatabaseException {
        if (Variables.isContext(graph, variable)) {
            return variable;
        }
        Variable parent = variable.getParent(graph);
        if (parent == null) {
            return null;
        }
        return Variables.getPossibleContext(graph, parent);
    }

    public static Variable getContext(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getPossibleContext(graph, variable);
        if (context == null) {
            throw new DatabaseException("No context found for " + variable.getURI(graph));
        }
        return context;
    }

    public static RVI getRVI2(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getRVI(graph);
    }

    public static RVI getPossibleRVI2(ReadGraph graph, Variable variable) throws DatabaseException {
        try {
            return variable.getRVI(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public static String getRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource realizationResource = Variables.getRealization(graph, variable);
        if (realizationResource == null) {
            throw new DatabaseException("No realization found for " + variable.getURI(graph));
        }
        return variable.getURI(graph).substring(graph.getURI(realizationResource).length());
    }

    public static String getRVI(ReadGraph graph, Resource config) throws DatabaseException {
        Variable var = Variables.getVariable(graph, config);
        return Variables.getRVI(graph, var);
    }

    public static String getPossibleRVI(ReadGraph graph, Resource config) throws DatabaseException {
        Variable var = Variables.getPossibleVariable(graph, config);
        return var != null ? Variables.getPossibleRVI(graph, var) : null;
    }

    public static String getPossibleRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        try {
            return Variables.getRVI(graph, variable);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public static List<Variable> getPath(ReadGraph graph, Variable base, Variable var) throws DatabaseException {
        if (!Variables.isChild(graph, base, var)) {
            return null;
        }
        LinkedList<Variable> result = new LinkedList<Variable>();
        var = (Variable)var.getPropertyValue(graph, PARENT);
        while (!var.equals(base)) {
            result.addFirst(var);
            var = (Variable)var.getPropertyValue(graph, PARENT);
        }
        return result;
    }

    public static Variable getChild(ReadGraph graph, Variable base, Variable var) throws DatabaseException {
        List<Variable> path = Variables.getPath(graph, base, var);
        if (path == null || path.size() == 0) {
            return null;
        }
        return path.get(0);
    }

    public static boolean isChild(ReadGraph graph, Variable base, Variable var) throws DatabaseException {
        if (base.equals(var)) {
            return false;
        }
        return var.getURI(graph).startsWith(base.getURI(graph));
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Resource realization) throws DatabaseException {
        Resource current = Variables.getRealization(graph, variable);
        return Variables.switchRealization(graph, variable, current, realization);
    }

    public static Variable switchPossibleContext(ReadGraph graph, Variable variable, Resource realization) throws DatabaseException {
        Variable current = Variables.getPossibleContext(graph, variable);
        if (current == null) {
            return null;
        }
        Resource currentContext = current.getPossibleRepresents(graph);
        if (currentContext == null) {
            return null;
        }
        return Variables.switchPossibleRealization(graph, variable, currentContext, realization);
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Variable realization) throws DatabaseException {
        Resource current = Variables.getRealization(graph, variable);
        return Variables.switchRealization(graph, variable, current, realization);
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Resource currentRealization, Resource targetRealization) throws DatabaseException {
        String currentURI = graph.getURI(currentRealization);
        String targetURI = graph.getURI(targetRealization);
        String variableURI = variable.getURI(graph);
        String targetVariableURI = String.valueOf(targetURI) + variableURI.substring(currentURI.length());
        return Variables.getVariable(graph, targetVariableURI);
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Resource currentRealization, Variable targetRealization) throws DatabaseException {
        String currentURI = graph.getURI(currentRealization);
        String targetURI = targetRealization.getURI(graph);
        String variableURI = variable.getURI(graph);
        String targetVariableURI = String.valueOf(targetURI) + variableURI.substring(currentURI.length());
        return Variables.getVariable(graph, targetVariableURI);
    }

    public static Variable switchPossibleRealization(ReadGraph graph, Variable variable, Resource currentRealization, Resource targetRealization) throws DatabaseException {
        String currentURI = graph.getURI(currentRealization);
        String targetURI = graph.getURI(targetRealization);
        String variableURI = variable.getURI(graph);
        String targetVariableURI = String.valueOf(targetURI) + variableURI.substring(currentURI.length());
        return Variables.getPossibleVariable(graph, targetVariableURI);
    }

    public static Variable toConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable config = Variables.getConfigurationContext(graph, variable);
        return Variables.switchRealization(graph, variable, config);
    }

    public static String toRVI(ReadGraph graph, List<Resource> compositePath) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StringBuilder rvi = new StringBuilder();
        for (Resource composite : compositePath) {
            String name = (String)graph.getPossibleRelatedValue(composite, L0.HasName);
            if (name == null) {
                return null;
            }
            rvi.append('/');
            String escapedName = URIStringUtils.escape((String)name);
            rvi.append(escapedName);
        }
        return rvi.toString();
    }

    @Deprecated
    public static SerializedRVI getSerialisedRVI(ReadGraph graph, Variable container, Variable variable) throws DatabaseException {
        return SerializedRVI.create(graph, container, variable);
    }

    public static String appendRVI(ReadGraph graph, String modelURI, String rvi, Resource configuration) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String partName = (String)graph.getPossibleRelatedValue(configuration, L0.HasName);
        if (partName == null) {
            throw new MissingVariableException("Can not append a child corresponding to " + configuration + " to rvi '" + rvi + "' since there is no name.");
        }
        String escaped = URIStringUtils.escape((String)partName);
        return String.valueOf(rvi) + "/" + escaped;
    }

    public static boolean isValid(ReadGraph graph, Variable variable) {
        if (variable == null) {
            return false;
        }
        try {
            variable.getURI(graph);
        }
        catch (DatabaseException e) {
            return false;
        }
        return true;
    }

    public static Variable possibleChildWithType(ReadGraph graph, Variable variable, Resource targetType) throws DatabaseException {
        Variable found = null;
        for (Variable child : variable.browseChildren(graph)) {
            Resource type = (Resource)child.getPossiblePropertyValue(graph, TYPE);
            if (type == null || !graph.isInheritedFrom(type, targetType)) continue;
            if (found != null) {
                return null;
            }
            found = child;
        }
        return found;
    }

    public static Collection<Variable> childrenWithType(ReadGraph graph, Variable variable, Resource targetType) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable child : variable.browseChildren(graph)) {
            Resource type = (Resource)child.getPossiblePropertyValue(graph, TYPE);
            if (!graph.isInheritedFrom(type, targetType)) continue;
            result.add(child);
        }
        return result;
    }

    public static <T> T adapt(ReadGraph graph, Variable variable, String property, Class<T> clazz) throws DatabaseException {
        Resource resource = (Resource)variable.getPropertyValue(graph, property);
        return (T)graph.adapt(resource, clazz);
    }

    public static <T> T getPossiblePropertyValue(RequestProcessor processor, Variable variable, Resource property, Binding binding) {
        try {
            return (T)processor.sync((ReadInterface)new TernaryRead<Variable, Resource, Binding, T>(variable, property, binding){

                public T perform(ReadGraph graph) throws DatabaseException {
                    return ((Variable)this.parameter).getPossiblePropertyValue(graph, (Resource)this.parameter2, (Binding)this.parameter3);
                }
            });
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public static Variable possibleActiveVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable activeVariable = (Variable)graph.sync((ReadInterface)new PossibleActiveVariableFromVariable(variable));
        return activeVariable;
    }

    public static Variant requestNodeValue(ReadGraph graph, VariableNode node) throws DatabaseException {
        Variant value = (Variant)graph.syncRequest((ExternalRead)new NodeValueRequest(node));
        if (PENDING_NODE_VALUE == value && graph.getSynchronous()) {
            try {
                return node.manager.getValue(node.node);
            }
            catch (NodeManagerException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return value;
    }

    public static NodeStructure requestNodeStructure(ReadGraph graph, VariableNode node) throws DatabaseException {
        NodeStructure value = (NodeStructure)graph.syncRequest((ExternalRead)new NodeStructureRequest(node));
        if (PENDING_NODE_STRUCTURE == value && graph.getSynchronous()) {
            try {
                return NodeStructureRequest.get(node);
            }
            catch (NodeManagerException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return value;
    }

    public static class NodeStructure {
        public Map<String, Object> children = new HashMap<String, Object>();
        public Map<String, Object> properties = new HashMap<String, Object>();

        public int hashCode() {
            return 31 * this.children.hashCode() + 51 * this.properties.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof NodeStructure)) {
                return false;
            }
            NodeStructure r = (NodeStructure)object;
            return r.children.equals(this.children) && r.properties.equals(this.properties);
        }
    }

    static class NodeStructureRequest
    extends ParametrizedPrimitiveRead<VariableNode, NodeStructure>
    implements Runnable {
        private Listener<NodeStructure> listener = null;
        private NodeStructure value = PENDING_NODE_STRUCTURE;

        public NodeStructureRequest(VariableNode node) {
            super((Object)node);
        }

        public void register(ReadGraph graph, Listener<NodeStructure> procedure) {
            if (procedure.isDisposed()) {
                this.listener = procedure;
                if (graph.getSynchronous()) {
                    try {
                        ((VariableNode)this.parameter).manager.getRealm().syncExec((Runnable)this);
                    }
                    catch (InterruptedException e) {
                        procedure.exception((Throwable)e);
                    }
                } else {
                    ((VariableNode)this.parameter).manager.getRealm().asyncExec((Runnable)this);
                }
                if (this.value == PENDING_NODE_STRUCTURE) {
                    procedure.execute((Object)PENDING_NODE_STRUCTURE);
                }
                return;
            }
            if (this.listener != null) {
                throw new UnsupportedOperationException();
            }
            this.listener = procedure;
            if (graph.getSynchronous()) {
                try {
                    ((VariableNode)this.parameter).manager.getRealm().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ((VariableNode)((NodeStructureRequest)NodeStructureRequest.this).parameter).manager.addNodeListener(((VariableNode)((NodeStructureRequest)NodeStructureRequest.this).parameter).node, (Runnable)NodeStructureRequest.this);
                        }
                    });
                }
                catch (InterruptedException e) {
                    procedure.exception((Throwable)e);
                }
            } else {
                ((VariableNode)this.parameter).manager.addNodeListener(((VariableNode)this.parameter).node, (Runnable)this);
            }
            if (this.value == PENDING_NODE_STRUCTURE) {
                procedure.execute((Object)PENDING_NODE_STRUCTURE);
            }
        }

        public void unregistered() {
            ((VariableNode)this.parameter).manager.removeNodeListener(((VariableNode)this.parameter).node, (Runnable)this);
            this.listener = null;
        }

        public static NodeStructure get(VariableNode parameter) throws NodeManagerException {
            String name;
            NodeStructure value = new NodeStructure();
            for (Object o : parameter.manager.getChildren(parameter.node)) {
                name = parameter.manager.getName(o);
                value.children.put(name, o);
            }
            for (Object o : parameter.manager.getProperties(parameter.node)) {
                name = parameter.manager.getName(o);
                value.properties.put(name, o);
            }
            return value;
        }

        @Override
        public void run() {
            try {
                this.value = NodeStructureRequest.get((VariableNode)this.parameter);
            }
            catch (NodeManagerException e) {
                Logger.defaultLogError((Throwable)e);
            }
            catch (Throwable e) {
                Logger.defaultLogError((Throwable)e);
            }
            Listener<NodeStructure> listener = this.listener;
            if (listener != null) {
                listener.execute((Object)this.value);
            }
        }
    }

    static class NodeValueRequest
    extends ParametrizedPrimitiveRead<VariableNode, Variant>
    implements Runnable {
        private Listener<Variant> listener = null;
        private Variant value = PENDING_NODE_VALUE;

        public NodeValueRequest(VariableNode node) {
            super((Object)node);
        }

        public void register(ReadGraph graph, Listener<Variant> procedure) {
            if (procedure.isDisposed()) {
                this.listener = procedure;
                if (graph.getSynchronous()) {
                    try {
                        ((VariableNode)this.parameter).manager.getRealm().syncExec((Runnable)this);
                    }
                    catch (InterruptedException e) {
                        procedure.exception((Throwable)e);
                    }
                } else {
                    ((VariableNode)this.parameter).manager.getRealm().asyncExec((Runnable)this);
                }
                if (this.value == PENDING_NODE_VALUE) {
                    procedure.execute((Object)PENDING_NODE_VALUE);
                }
                return;
            }
            if (this.listener != null) {
                throw new UnsupportedOperationException();
            }
            this.listener = procedure;
            if (graph.getSynchronous()) {
                try {
                    ((VariableNode)this.parameter).manager.getRealm().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ((VariableNode)((NodeValueRequest)NodeValueRequest.this).parameter).manager.addNodeListener(((VariableNode)((NodeValueRequest)NodeValueRequest.this).parameter).node, (Runnable)NodeValueRequest.this);
                        }
                    });
                }
                catch (InterruptedException e) {
                    procedure.exception((Throwable)e);
                }
            } else {
                ((VariableNode)this.parameter).manager.addNodeListener(((VariableNode)this.parameter).node, (Runnable)this);
            }
            if (this.value == PENDING_NODE_VALUE) {
                procedure.execute((Object)PENDING_NODE_VALUE);
            }
        }

        public void unregistered() {
            ((VariableNode)this.parameter).manager.removeNodeListener(((VariableNode)this.parameter).node, (Runnable)this);
        }

        @Override
        public void run() {
            try {
                this.value = ((VariableNode)this.parameter).manager.getValue(((VariableNode)this.parameter).node);
            }
            catch (NodeManagerException e) {
                if (!(e instanceof NodeIsNotValidAnymoreException)) {
                    Logger.defaultLogError((Throwable)e);
                }
            }
            catch (Throwable e) {
                Logger.defaultLogError((Throwable)e);
            }
            Listener<Variant> listener = this.listener;
            if (listener != null) {
                listener.execute((Object)this.value);
            }
        }
    }

    public static enum Role {
        CHILD("/"),
        PROPERTY("#");

        final transient String identifier;

        private Role(String identifier) {
            this.identifier = identifier;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public static Role getRole(String identifier) {
            Role[] roleArray = Role.values();
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray[n2];
                if (role.identifier.equals(identifier)) {
                    return role;
                }
                ++n2;
            }
            return null;
        }
    }

    @Deprecated
    public static class SerializedRVI {
        Object[] path;

        private SerializedRVI(Collection<Object> path) {
            this.path = path.toArray();
        }

        static void create(ReadGraph graph, Variable container, Variable variable, ArrayList<Object> path) throws DatabaseException {
            if (container.equals(variable)) {
                return;
            }
            Object serialised = variable.getPropertyValue(graph, Variables.SERIALISED);
            Role role = (Role)((Object)variable.getPropertyValue(graph, Variables.ROLE));
            Variable parent = (Variable)variable.getPropertyValue(graph, Variables.PARENT);
            path.add(serialised);
            path.add((Object)role);
            SerializedRVI.create(graph, container, parent, path);
        }

        static SerializedRVI create(ReadGraph graph, Variable container, Variable variable) throws DatabaseException {
            ArrayList<Object> path = new ArrayList<Object>();
            SerializedRVI.create(graph, container, variable, path);
            Collections.reverse(path);
            return new SerializedRVI(path);
        }

        public Resource toResource(WriteGraph graph) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            Resource result = graph.newResource();
            StringBuilder b = new StringBuilder();
            ArrayList<Resource> rs = new ArrayList<Resource>();
            int i = 0;
            while (i < this.path.length) {
                Role role = (Role)((Object)this.path[i]);
                Resource resource = (Resource)this.path[i + 1];
                b.append(role.getIdentifier());
                rs.add(resource);
                i += 2;
            }
            graph.claimLiteral(result, L0X.HasExpression, (Object)b.toString(), (Binding)Bindings.STRING);
            graph.claim(result, l0.HasElement, ListUtils.create((WriteGraph)graph, (Resource)l0.List, rs));
            return result;
        }

        private static String popRole(String expression, ArrayList<Object> result) {
            if (expression.startsWith("/")) {
                result.add((Object)Role.CHILD);
                return expression.substring(1);
            }
            if (expression.startsWith("#")) {
                result.add((Object)Role.PROPERTY);
                return expression.substring(1);
            }
            throw new IllegalArgumentException("Unknown role '" + expression.charAt(0) + "'");
        }

        public static SerializedRVI fromResource(ReadGraph graph, Resource path) throws DatabaseException {
            ArrayList<Object> result = new ArrayList<Object>();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            String expression = (String)graph.getPossibleRelatedValue(path, L0X.HasExpression, (Binding)Bindings.STRING);
            Resource set = graph.getPossibleObject(path, L0.HasElement);
            for (Resource r : ListUtils.toList((ReadGraph)graph, (Resource)set)) {
                expression = SerializedRVI.popRole(expression, result);
                result.add(r);
            }
            return new SerializedRVI(result);
        }

        private static Variable extractDeserializedPart(ReadGraph graph, Variable container, Role role, Object serialized, StringBuilder b) throws DatabaseException {
            if (Role.PROPERTY.equals((Object)role)) {
                for (Variable property : container.browseProperties(graph)) {
                    Object ser = property.getPossiblePropertyValue(graph, Variables.SERIALISED);
                    if (!serialized.equals(ser)) continue;
                    b.append(property.getPropertyValue(graph, Variables.NAME));
                    return property;
                }
                throw new VariableException("No variable for serialised path " + serialized);
            }
            if (Role.CHILD.equals((Object)role)) {
                for (Variable child : container.browseChildren(graph)) {
                    Object ser = child.getPropertyValue(graph, Variables.SERIALISED);
                    if (!serialized.equals(ser)) continue;
                    b.append(child.getPropertyValue(graph, Variables.NAME));
                    return child;
                }
                throw new VariableException("No variable for serialised path " + serialized);
            }
            return null;
        }

        public String toRVI(ReadGraph graph, Variable container) throws DatabaseException {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < this.path.length) {
                Role role = (Role)((Object)this.path[i]);
                Resource resource = (Resource)this.path[i + 1];
                b.append(role.getIdentifier());
                container = SerializedRVI.extractDeserializedPart(graph, container, role, resource, b);
                i += 2;
            }
            return b.toString();
        }
    }
}

