/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Units;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.db.layer0.variable.Variable;

public class VariableWriteImplied
extends WriteRequest {
    private final Variable variable;
    private final String label;
    private final String targetUnit;

    public VariableWriteImplied(Variable variable, String label) {
        this(variable, label, null, null);
    }

    public VariableWriteImplied(Variable variable, String label, VirtualGraph provider, String targetUnit) {
        super(provider);
        this.variable = variable;
        this.label = label;
        this.targetUnit = targetUnit;
    }

    public static IUnitConverter converter(final String unit, final String targetUnit) {
        return new IUnitConverter(){

            public double convert(double value) {
                if (targetUnit == null) {
                    return value;
                }
                if ("K".equals(unit)) {
                    if ("C".equals(targetUnit)) {
                        value -= 273.15;
                    } else if ("F".equals(targetUnit)) {
                        value = (value - 273.15) * 9.0 / 5.0 + 32.0;
                    }
                } else if ("C".equals(unit)) {
                    if ("K".equals(targetUnit)) {
                        value += 273.15;
                    }
                } else if ("F".equals(unit)) {
                    if ("K".equals(targetUnit)) {
                        value = (value - 32.0) * 5.0 / 9.0 + 273.15;
                    }
                } else {
                    try {
                        value = Units.convert((double)value, (String)unit, (String)targetUnit);
                    }
                    catch (UnitParseException e) {
                        e.printStackTrace();
                    }
                }
                return value;
            }
        };
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        try {
            Datatype type = (Datatype)this.variable.getPossiblePropertyValue((ReadGraph)graph, "DATATYPE");
            if (type == null) {
                String uri = null;
                try {
                    uri = this.variable.getURI((ReadGraph)graph);
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
                throw new BindingException("no datatype for variable " + this.variable + " (URI=" + uri + ")", null);
            }
            Binding binding = Bindings.getBinding((Datatype)type);
            String parsedLabel = this.label;
            Object value = null;
            if (binding instanceof StringBinding) {
                value = binding instanceof MutableStringBinding ? new MutableString(this.label) : this.label;
            } else if (binding instanceof BooleanBinding) {
                try {
                    value = PrimitiveValueParser.parseBoolean(this.label);
                }
                catch (IllegalArgumentException e) {
                    throw new DatabaseException((Throwable)e);
                }
            } else {
                String unit;
                if (binding instanceof NumberBinding) {
                    parsedLabel = this.label.replace(",", ".");
                }
                value = binding.parseValue(parsedLabel, new DataValueRepository());
                if (this.targetUnit != null && type instanceof NumberType && (unit = (String)this.variable.getPossiblePropertyValue((ReadGraph)graph, "UNIT")) != null) {
                    IUnitConverter converter = VariableWriteImplied.converter(this.targetUnit, unit);
                    if (type instanceof FloatType) {
                        float converted = (float)converter.convert((double)((Number)value).floatValue());
                        value = binding.parseValue(Float.toString(converted), new DataValueRepository());
                    } else if (type instanceof DoubleType) {
                        double converted = converter.convert(((Number)value).doubleValue());
                        value = binding.parseValue(Double.toString(converted), new DataValueRepository());
                    } else if (type instanceof IntegerType) {
                        value = binding.parseValue(Integer.toString(((Number)value).intValue()), new DataValueRepository());
                    }
                }
            }
            this.variable.setValue(graph, value, binding);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)value)));
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (org.simantics.databoard.binding.error.BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

