/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;

public final class VariableRepository {
    private static final HashMap<String, Variable> repository = new HashMap();

    public static synchronized void register(String uri, Variable variable) {
        repository.put(uri, variable);
    }

    public static synchronized void unregister(String uri) {
        repository.remove(uri);
    }

    public static synchronized Variable get(ReadGraph graph, String uri) throws DatabaseException {
        for (Map.Entry<String, Variable> e : repository.entrySet()) {
            if (!uri.startsWith(e.getKey())) continue;
            return e.getValue().browse(graph, uri.substring(e.getKey().length()));
        }
        throw new MissingVariableException(uri);
    }
}

