/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantVariable;
import org.simantics.db.layer0.variable.PropertyVariable2;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;

public final class TagNameVariable2
extends PropertyVariable2 {
    protected final Resource container;
    protected final Resource tag;

    public TagNameVariable2(ReadGraph graph, Variable source, Resource container, Resource tag) throws DatabaseException {
        super(source);
        this.container = container;
        this.tag = tag;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Statement stm = graph.getSingleStatement(this.container, this.tag);
        return (T)graph.getPossibleRelatedValue(stm.getPredicate(), L0.HasName, (Binding)Bindings.STRING);
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        return this.getValue(graph);
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String tagName = (String)graph.getPossibleRelatedValue(this.tag, L0.HasName, (Binding)Bindings.STRING);
        return String.valueOf(this.source.getURI(graph)) + Variables.Role.PROPERTY.identifier + tagName;
    }

    @Override
    public Variable getProperty(ReadGraph graph, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String tagName = (String)graph.getPossibleRelatedValue(this.tag, L0.HasName, (Binding)Bindings.STRING);
        if ("HasName".equals(name)) {
            return new ConstantVariable<String>(String.valueOf(this.source.getURI(graph)) + Variables.Role.PROPERTY.identifier + URIStringUtils.escape((String)tagName));
        }
        return super.getProperty(graph, name);
    }
}

