/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

public class SubliteralPropertyVariableDeprecated
extends AbstractPropertyVariable {
    private final Variable parent;
    private final ChildReference reference;

    public SubliteralPropertyVariableDeprecated(Variable parent, ChildReference reference) {
        this.parent = parent;
        this.reference = reference;
    }

    @Override
    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        throw new RuntimeDatabaseException();
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        throw new RuntimeDatabaseException();
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        Datatype parentType = (Datatype)this.parent.getPropertyValue(graph, "DATATYPE");
        if (parentType instanceof ArrayType) {
            ArrayType at = (ArrayType)parentType;
            return at.getComponentType(0);
        }
        return null;
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return this.parent.getPredicate(graph);
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        Object parentValue = this.parent.getValue(graph);
        Datatype parentType = (Datatype)this.parent.getPropertyValue(graph, "DATATYPE");
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                return (T)ab.get(parentValue, ref.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        throw new RuntimeDatabaseException("parent variable data type " + parentType + " is not an ArrayType");
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        Object parentValue = this.parent.getValue(graph);
        Datatype parentType = (Datatype)this.parent.getPropertyValue(graph, "DATATYPE");
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                Object indexValue = ab.get(parentValue, ref.index);
                return (T)Bindings.adapt((Object)indexValue, (Binding)ab.getComponentBinding(), (Binding)binding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        throw new RuntimeDatabaseException("parent variable data type " + parentType + " is not an ArrayType");
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        Object parentValue = this.parent.getValue((ReadGraph)graph);
        Datatype parentType = (Datatype)this.parent.getPropertyValue((ReadGraph)graph, "DATATYPE");
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                Object indexValue = Bindings.adapt((Object)value, (Binding)binding, (Binding)ab.getComponentBinding());
                ab.set(parentValue, ref.index, indexValue);
                this.parent.setValue(graph, parentValue, parentBinding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.reference.toString(false);
    }

    @Override
    public Object getSerialized(ReadGraph graph) throws DatabaseException {
        return this.reference.toString(false);
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public Variables.Role getRole(ReadGraph graph) throws DatabaseException {
        return Variables.Role.CHILD;
    }

    @Override
    public RVI.RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
        return new RVI.StringRVIPart(Variables.Role.CHILD, this.reference.toString(false));
    }
}

