/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.EnumerationMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableModifier;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class StandardVariableModifier
implements VariableModifier {
    private static final Binding datatype_binging = Bindings.getBindingUnchecked(Datatype.class);
    public static final StandardVariableModifier INSTANCE = new StandardVariableModifier();

    @Override
    public String isValid(Object newValue) {
        return null;
    }

    @Override
    public String isValid(Object newValue, Binding binding) {
        return null;
    }

    @Override
    public void modify(WriteGraph graph, Variable variable, Object value) throws DatabaseException {
        this.modify(graph, variable, value, null);
    }

    boolean isEnumeration(ReadGraph graph, Resource literal) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(literal, L0.PartOf);
        if (parent == null) {
            return false;
        }
        return graph.hasStatement(parent, L0.Enumeration);
    }

    @Override
    public void modify(WriteGraph graph, Variable variable, Object value, Binding binding) throws DatabaseException {
        Variable parent = (Variable)variable.getPossiblePropertyValue((ReadGraph)graph, "Parent");
        Variable predicate = (Variable)variable.getPossiblePropertyValue((ReadGraph)graph, "PREDICATE");
        Resource container = (Resource)parent.getPossiblePropertyValue((ReadGraph)graph, "Represents");
        if (container == null) {
            return;
        }
        Resource property = (Resource)predicate.getPossiblePropertyValue((ReadGraph)graph, "Represents");
        if (property == null) {
            return;
        }
        Statement object = graph.getPossibleStatement(container, property);
        if (object == null) {
            return;
        }
        Resource objectResource = object.getObject();
        if (this.isEnumeration((ReadGraph)graph, objectResource)) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource type = graph.getSingleObject(objectResource, L0.PartOf);
            Map enumMap = (Map)graph.syncRequest((Read)new EnumerationMap(type));
            Resource newLiteral = (Resource)enumMap.get(value);
            graph.deny(container, property, objectResource);
            graph.claim(container, property, newLiteral);
            return;
        }
        if (object.isAsserted(container)) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource type = graph.getPossibleType(objectResource, L0.Literal);
            Statement dt = graph.getPossibleStatement(objectResource, L0.HasDataType);
            Datatype custom = dt.isAsserted(objectResource) ? null : (Datatype)graph.getValue(dt.getObject(), datatype_binging);
            objectResource = graph.newResource();
            graph.claim(objectResource, L0.InstanceOf, null, type);
            graph.claim(container, property, objectResource);
            if (custom != null) {
                graph.addLiteral(objectResource, L0.HasDataType, L0.HasDataType_Inverse, L0.DataType, (Object)custom, datatype_binging);
            }
        }
        graph.claimValue(objectResource, value, binding);
    }
}

