/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.VariableRVIRequest;
import org.simantics.db.layer0.variable.AbstractVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.RVIBuilder;
import org.simantics.db.layer0.variable.RVIResolver;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class StandardRVIResolver
implements RVIResolver {
    public static final StandardRVIResolver INSTANCE = new StandardRVIResolver();

    protected RVI.RVIPart getRVIPart(ReadGraph graph, Variable variable) throws DatabaseException {
        if (variable instanceof AbstractVariable) {
            AbstractVariable abst = (AbstractVariable)variable;
            return abst.getRVIPart(graph);
        }
        Variables.Role role = (Variables.Role)((Object)variable.getPropertyValue(graph, "Role"));
        return new RVI.StringRVIPart(role, variable.getName(graph));
    }

    @Override
    public RVI getRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        Databoard databoard = (Databoard)graph.getService(Databoard.class);
        Binding rviBinding = databoard.getBindingUnchecked(RVI.class);
        if (Variables.isContext(graph, variable)) {
            return RVI.empty(rviBinding);
        }
        Variable parent = variable.getParent(graph);
        if (parent == null) {
            throw new MissingVariableException("no parent for variable " + variable + " (URI=" + variable.getURI(graph) + ")");
        }
        RVI base = (RVI)((Object)graph.syncRequest((Read)new VariableRVIRequest(parent)));
        RVI.RVIPart part = this.getRVIPart(graph, variable);
        return new RVIBuilder(base).append(part).toRVI();
    }

    protected Variable resolveChild(ReadGraph graph, Variable variable, Resource resource) throws DatabaseException {
        String rName = (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        return variable.getChild(graph, rName);
    }

    protected Variable resolveProperty(ReadGraph graph, Variable variable, Resource resource) throws DatabaseException {
        String rName = (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        return variable.getProperty(graph, rName);
    }

    @Override
    public Variable getVariable(ReadGraph graph, Variable context, RVI.RVIPart part) throws DatabaseException {
        if (part instanceof RVI.StringRVIPart) {
            RVI.StringRVIPart srp = (RVI.StringRVIPart)part;
            if (Variables.Role.CHILD.equals((Object)srp.getRole())) {
                return context.getChild(graph, srp.string);
            }
            if (Variables.Role.PROPERTY.equals((Object)srp.getRole())) {
                return context.getProperty(graph, srp.string);
            }
        } else if (part instanceof RVI.ResourceRVIPart) {
            RVI.ResourceRVIPart rrp = (RVI.ResourceRVIPart)part;
            if (Variables.Role.CHILD.equals((Object)rrp.getRole())) {
                return this.resolveChild(graph, context, rrp.resource);
            }
            if (Variables.Role.PROPERTY.equals((Object)rrp.getRole())) {
                return this.resolveProperty(graph, context, rrp.resource);
            }
        }
        throw new DatabaseException("Unrecognized RVIPart: " + part);
    }
}

