/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PropertyDataType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.variable.EquationExpression;
import org.simantics.db.layer0.variable.StandardRealizationVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableImpl2;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

@Deprecated
public class StandardPropertyVariable
extends VariableImpl2 {
    protected final Variable source;
    private final Resource container;
    protected final Resource property;

    public StandardPropertyVariable(Variable source, Resource container, Resource property) {
        assert (source != null);
        assert (container != null);
        assert (property != null);
        this.source = source;
        this.container = container;
        this.property = property;
    }

    public Resource getContainer(ReadGraph graph) {
        return this.container;
    }

    public Resource getProperty(ReadGraph graph) {
        return this.property;
    }

    @Override
    public <T> T getInterface(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (Datatype.class.equals(clazz)) {
            return (T)graph.syncRequest((Read)new PropertyDataType(this.container, this.property));
        }
        if (Resource.class.equals(clazz)) {
            return (T)this.getProperty(graph);
        }
        return super.getInterface(graph, clazz);
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (Resource.class == clazz) {
            return (T)this.property;
        }
        return (T)graph.adapt(this.property, clazz);
    }

    @Override
    public Variable getProperty(ReadGraph graph, String name) throws DatabaseException {
        Resource object = graph.getPossibleObject(this.getContainer(graph), this.getProperty(graph));
        if (object == null) {
            throw new VariableException("Failed to get modelled property because query returned no objects for container " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.container, (boolean)true) + " and property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.property, (boolean)true));
        }
        Variable modelled = this.tryGetModelledProperty(graph, object, name);
        if (modelled != null) {
            return modelled;
        }
        return this.getProperty(graph, this.getProperty(graph), name);
    }

    @Override
    public Collection<Variable> browseProperties(ReadGraph graph) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Resource object = graph.getPossibleObject(this.getContainer(graph), this.getProperty(graph));
        if (object == null) {
            throw new VariableException("Failed to get modelled property because query returned no objects");
        }
        this.browseProperties(graph, object, result);
        this.browseProperties(graph, this.getProperty(graph), result);
        return result;
    }

    private boolean isEnumeration(ReadGraph graph, Resource value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource type : graph.getTypes(value)) {
            if (!graph.hasStatement(type, L0.Enumeration)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource object = graph.getPossibleObject(this.getContainer(graph), this.getProperty(graph));
        if (object == null) {
            return null;
        }
        if (graph.hasStatement(object, L0.PartOf) && this.isEnumeration(graph, object)) {
            return (T)graph.getRelatedValue(object, L0.HasName, (Binding)Bindings.STRING);
        }
        return (T)graph.getValue(object, binding);
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource object = graph.getPossibleObject(this.getContainer(graph), this.getProperty(graph));
        if (object == null) {
            return null;
        }
        if (graph.isInstanceOf(object, L0.Literal)) {
            if (graph.hasStatement(object, L0.PartOf) && this.isEnumeration(graph, object)) {
                return (T)graph.getRelatedValue(object, L0.HasName);
            }
            return (T)graph.getValue(object);
        }
        return (T)object;
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        EquationExpression expression;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Statement object = graph.getPossibleStatement(this.getWriteResource((ReadGraph)graph), this.getProperty((ReadGraph)graph));
        if (object == null) {
            return;
        }
        Resource expressionResource = graph.getPossibleObject(object.getObject(), L0X.HasExpression);
        if (expressionResource != null && (expression = (EquationExpression)graph.adapt(expressionResource, EquationExpression.class)).isInvertible((ReadGraph)graph, this)) {
            expression.invert(graph, this, value, binding);
            return;
        }
        Resource subject = this.getWriteResource((ReadGraph)graph);
        Resource objectResource = object.getObject();
        if (object.isAsserted(this.getWriteResource((ReadGraph)graph))) {
            Resource type = graph.getPossibleType(objectResource, l0.Literal);
            Resource oldObject = objectResource;
            objectResource = graph.newResource();
            graph.claim(objectResource, l0.InstanceOf, null, type);
            graph.claim(subject, this.property, objectResource);
        }
        graph.claimValue(objectResource, value, binding);
    }

    public Resource getWriteResource(ReadGraph graph) throws DatabaseException {
        if (this.source instanceof StandardRealizationVariable) {
            return ((StandardRealizationVariable)this.source).getPropertyWriteResource(graph);
        }
        if (this.source instanceof StandardPropertyVariable) {
            return ((StandardPropertyVariable)this.source).getWriteResource(graph);
        }
        throw new Error("Invalid subject " + this.source);
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(this.property, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            System.err.println("err: property " + this.property + " container " + this.container + " source " + this.source.getURI(graph));
            return null;
        }
        String base = this.source.getURI(graph);
        return String.valueOf(base) + Variables.Role.PROPERTY.getIdentifier() + URIStringUtils.escape((String)name);
    }

    public int hashCode() {
        return this.source.hashCode() + 31 * this.property.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StandardPropertyVariable r = (StandardPropertyVariable)object;
        return this.source.equals(r.source) && this.property.equals(r.property);
    }
}

