/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;

public class StandardGraphResourcePropertyVariable
extends StandardGraphPropertyVariable {
    public StandardGraphResourcePropertyVariable(ReadGraph graph, Variable parent, Resource parentResource, Resource property) throws DatabaseException {
        super(parent, parentResource, property);
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        if (this.parentResource == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + this.getPossibleURI(graph) + ").");
        }
        try {
            return (T)graph.getSingleObject(this.parentResource, this.property);
        }
        catch (NoSingleResultException e) {
            System.err.println("No object for " + this.parentResource + " " + this.property);
            throw new MissingVariableValueException(this.getPossibleURI(graph));
        }
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        if (this.parentResource == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + this.getPossibleURI(graph) + ").");
        }
        try {
            return (T)graph.getSingleObject(this.parentResource, this.property);
        }
        catch (NoSingleResultException e) {
            System.err.println("No object for " + this.parentResource + " " + this.property);
            throw new MissingVariableValueException(this.getPossibleURI(graph));
        }
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return null;
    }
}

