/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.PropertyValueAccessorRequest;
import org.simantics.db.layer0.variable.PropertyVariableMapRequest;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class StandardGraphPropertyVariable
extends AbstractPropertyVariable {
    public final Variable parent;
    public final Resource parentResource;
    public final Resource property;
    private transient int hash = 0;

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, VariableNode node, Resource property) throws DatabaseException {
        this(parent, node, parent.getRepresents(graph), property);
    }

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, Resource property) throws DatabaseException {
        this(parent, null, parent.getRepresents(graph), property);
    }

    public StandardGraphPropertyVariable(Variable parent, Resource parentResource, Resource property) throws DatabaseException {
        this(parent, null, parentResource, property);
    }

    public StandardGraphPropertyVariable(Variable parent, VariableNode node, Resource parentResource, Resource property) throws DatabaseException {
        super(node);
        assert (parent != null);
        this.parent = parent;
        this.property = property;
        this.parentResource = parentResource;
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        if (this.node != null) {
            return this.node.manager.getName(this.node.node);
        }
        return (String)graph.getRelatedValue(this.property, ((Layer0)graph.getService(Layer0.class)).HasName, (Binding)Bindings.STRING);
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        return (String)graph.getRelatedValue2(this.property, ((Layer0)graph.getService(Layer0.class)).HasLabel, (Object)this.parent, (Binding)Bindings.STRING);
    }

    @Override
    public Object getSerialized(ReadGraph graph) throws DatabaseException {
        return this.property;
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        return (T)this.getValueAccessor(graph).getValue(graph, this);
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        try {
            return (T)this.getValueAccessor(graph).getValue(graph, this, binding);
        }
        catch (Throwable t) {
            throw new MissingVariableValueException(t);
        }
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        if (this.parentResource == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + this.getPossibleURI(graph) + ").");
        }
        return graph.getSingleObject(this.parentResource, this.property);
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        if (this.parentResource == null) {
            return null;
        }
        return graph.getPossibleObject(this.parentResource, this.property);
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.getValueAccessor((ReadGraph)graph).setValue(graph, this, value, binding);
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.getValueAccessor((ReadGraph)graph).setValue(graph, this, value);
    }

    @Override
    public Binding getDefaultBinding(ReadGraph graph) throws DatabaseException {
        try {
            return Layer0Utils.getDefaultBinding(graph, this);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        if (this.node != null) {
            try {
                return this.node.manager.getDatatype(this.node.node);
            }
            catch (NodeManagerException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return Layer0Utils.getDatatype(graph, this);
    }

    @Override
    public String getUnit(ReadGraph graph) throws DatabaseException {
        try {
            return Layer0Utils.getUnit(graph, this);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Resource getPropertyResource(ReadGraph graph) {
        return this.property;
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return this.parentResource;
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map != null) {
            map.getVariables(graph, this, result);
        }
        return result.values();
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map == null) {
            return null;
        }
        try {
            return map.getVariable(graph, this, name);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return null;
        }
        try {
            return valueMap.getVariable(graph, this, name);
        }
        catch (DatabaseException e) {
            return null;
        }
        catch (Throwable t) {
            System.err.println("err: " + this.getURI(graph) + "  # " + name);
            return null;
        }
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return properties;
        }
        return valueMap.getVariables(graph, this, properties);
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return Variables.getVariable(graph, graph.getURI(this.property));
    }

    @Override
    public Resource getPredicateResource(ReadGraph graph) throws DatabaseException {
        return this.property;
    }

    @Override
    public Resource getPossiblePredicateResource(ReadGraph graph) throws DatabaseException {
        return this.property;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
            result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
            this.hash = result = 31 * result + (this.parentResource != null ? this.parentResource.hashCode() : 0);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardGraphPropertyVariable other = (StandardGraphPropertyVariable)obj;
        if (this.node != null ? !this.node.equals(other.node) : other.node != null) {
            return false;
        }
        if (this.property != null ? !this.property.equals(other.property) : other.property != null) {
            return false;
        }
        if (this.parentResource != null ? !this.parentResource.equals(other.parentResource) : other.parentResource != null) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(other.parent) : other.parent != null);
    }

    @Override
    protected Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    protected ValueAccessor getValueAccessor(ReadGraph graph) throws DatabaseException {
        if (this.parentResource == null) {
            return All.standardValueAccessor;
        }
        ValueAccessor accessor = (ValueAccessor)graph.syncRequest((Read)new PropertyValueAccessorRequest(this.property), (AsyncProcedure)TransientCacheAsyncListener.instance());
        if (accessor != null) {
            return accessor;
        }
        System.err.println("No value accessor for " + this.getURI(graph));
        return All.standardValueAccessor;
    }

    protected VariableMap getPossibleChildVariableMap(ReadGraph graph) throws DatabaseException {
        if (this.parentResource == null) {
            return All.standardPropertyDomainChildren;
        }
        Resource value = graph.getPossibleObject(this.parentResource, this.property);
        if (value == null) {
            return null;
        }
        return (VariableMap)graph.getPossibleRelatedValue2(value, Layer0.getInstance((ReadGraph)graph).domainChildren, (Object)this);
    }

    protected VariableMap getPossiblePropertyVariableMap(ReadGraph graph) throws DatabaseException {
        if (this.property == null) {
            return All.standardPropertyDomainProperties;
        }
        return (VariableMap)graph.syncRequest((Read)new PropertyVariableMapRequest(this.property), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(this.property), (Listener)TransientCacheListener.instance());
        if (info == null) {
            return Collections.emptySet();
        }
        return info.classifications;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, String classification, Map<String, Variable> properties) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return properties;
        }
        return valueMap.getVariables(graph, this, classification, properties);
    }
}

