/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.request.ClassificationsRequest;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.RVIResolver;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.StandardRVIResolver;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class StandardGraphChildVariable
extends AbstractChildVariable {
    protected final Variable parent;
    public final Resource resource;
    private transient int hash;

    public Variable getPossibleSpecialChild(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    public Map<String, Variable> collectSpecialChildren(ReadGraph graph, Map<String, Variable> children) throws DatabaseException {
        return children;
    }

    public StandardGraphChildVariable(Variable parent, VariableNode node, Resource resource) {
        super(node);
        this.parent = parent;
        this.resource = resource;
    }

    @Override
    public void validate(ReadGraph graph) throws DatabaseException {
        if (!graph.hasStatement(this.resource)) {
            throw new InvalidVariableException("The resource has been removed: " + this.resource);
        }
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        VariableMap map = this.getPossiblePropertyVariableMap(graph);
        if (map == null) {
            return null;
        }
        try {
            return map.getVariable(graph, this, name);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map == null) {
            return this.getPossibleSpecialChild(graph, name);
        }
        try {
            Variable result = map.getVariable(graph, this, name);
            if (result != null) {
                return result;
            }
            return this.getPossibleSpecialChild(graph, name);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        VariableMap map = this.getPossiblePropertyVariableMap(graph);
        if (map == null) {
            return properties;
        }
        return map.getVariables(graph, this, properties);
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        Map<String, Variable> result = null;
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map != null) {
            result = map.getVariables(graph, this, result);
        }
        if ((result = this.collectSpecialChildren(graph, result)) == null) {
            return Collections.emptyList();
        }
        return result.values();
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        if (this.node != null) {
            return this.node.manager.getName(this.node.node);
        }
        String unescapedName = (String)graph.getPossibleRelatedValue(this.resource, ((Layer0)graph.getService(Layer0.class)).HasName, (Binding)Bindings.STRING);
        if (unescapedName == null) {
            return "r" + this.resource.getResourceId();
        }
        return unescapedName;
    }

    @Override
    public Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        Resource resource = this.getPossibleRepresents(graph);
        if (resource != null) {
            return new StandardGraphPropertyVariable(this, resource, Layer0.getInstance((ReadGraph)graph).HasName);
        }
        return super.getNameVariable(graph);
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        if (this.resource == null) {
            return this.getName(graph);
        }
        try {
            return (String)graph.getRelatedValue2(this.resource, ((Layer0)graph.getService(Layer0.class)).HasLabel);
        }
        catch (DatabaseException e) {
            return this.getName(graph);
        }
    }

    @Override
    protected final Variable getLabelVariable(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (this.resource == null) {
            return null;
        }
        return new StandardGraphPropertyVariable(graph, this, L0.HasLabel);
    }

    @Override
    public final Object getSerialized(ReadGraph graph) throws DatabaseException {
        Resource represents = this.getRepresents(graph);
        if (represents != null) {
            return represents;
        }
        return this.getName(graph);
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public final Resource getRepresents(ReadGraph graph) throws DatabaseException {
        if (this.resource == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + this.getPossibleURI(graph) + ").");
        }
        return this.resource;
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        return this.resource;
    }

    @Override
    public final String getURI(ReadGraph graph) throws DatabaseException {
        block3: {
            try {
                if (this.parent != null) break block3;
                return "http:/";
            }
            catch (AssumptionException e) {
                throw new InvalidVariableException(e);
            }
        }
        return String.valueOf((String)graph.sync((ReadInterface)new VariableURI(this.parent))) + Variables.Role.CHILD.getIdentifier() + StandardGraphChildVariable.encodeString(this.getName(graph));
    }

    @Override
    public String getPossibleURI(ReadGraph graph) throws DatabaseException {
        try {
            return this.getURI(graph);
        }
        catch (DatabaseException e) {
            return "<no uri>";
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
            this.hash = result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardGraphChildVariable other = (StandardGraphChildVariable)obj;
        if (this.node != null ? !this.node.equals(other.node) : other.node != null) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(other.resource) : other.resource != null) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(other.parent) : other.parent != null);
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return (T)graph.adapt(this.resource, clazz);
    }

    @Override
    public RVI.RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
        if (this.resource == null) {
            return new RVI.StringRVIPart(Variables.Role.CHILD, this.getName(graph));
        }
        return new RVI.ResourceRVIPart(Variables.Role.CHILD, this.resource);
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.resource + "]";
    }

    protected VariableMap getPossiblePropertyVariableMap(ReadGraph graph) throws DatabaseException {
        if (this.resource == null) {
            return All.standardChildDomainProperties;
        }
        return (VariableMap)graph.getPossibleRelatedValue2(this.resource, Layer0.getInstance((ReadGraph)graph).domainProperties, (Object)this);
    }

    protected VariableMap getPossibleChildVariableMap(ReadGraph graph) throws DatabaseException {
        if (this.resource == null) {
            return All.standardChildDomainChildren;
        }
        return (VariableMap)graph.getPossibleRelatedValue2(this.resource, Layer0.getInstance((ReadGraph)graph).domainChildren, (Object)this);
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, String classification, Map<String, Variable> properties) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return properties;
        }
        return valueMap.getVariables(graph, this, classification, properties);
    }

    @Override
    public Variable resolve(ReadGraph graph, RVI.RVIPart part) throws DatabaseException {
        Resource represents = this.getPossibleRepresents(graph);
        if (represents == null) {
            return StandardRVIResolver.INSTANCE.getVariable(graph, this, part);
        }
        RVIResolver resolver = (RVIResolver)graph.adapt(represents, RVIResolver.class);
        return resolver.getVariable(graph, this, part);
    }

    @Override
    public Variable resolvePossible(ReadGraph graph, RVI.RVIPart part) throws DatabaseException {
        try {
            return this.resolve(graph, part);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        Resource type;
        Set result;
        Resource represents = this.getPossibleRepresents(graph);
        Set set = result = represents != null ? (Set)graph.syncRequest((Read)new ClassificationsRequest(graph.getPrincipalTypes(represents))) : Collections.emptySet();
        if (result.isEmpty() && (type = this.getPossibleType(graph)) != null) {
            result = (Set)graph.syncRequest((Read)new ClassificationsRequest(Collections.singleton(type)));
        }
        if (result.isEmpty() && this.node != null) {
            try {
                result = this.node.manager.getClassifications(this.node.node);
            }
            catch (NodeManagerException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public RVI getRVI(ReadGraph graph) throws DatabaseException {
        Resource represents = this.getPossibleRepresents(graph);
        if (represents == null) {
            return StandardRVIResolver.INSTANCE.getRVI(graph, this);
        }
        RVIResolver resolver = (RVIResolver)graph.adapt(represents, RVIResolver.class);
        return resolver.getRVI(graph, this);
    }
}

