/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PropertyMapOfResource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.ParentPropertyVariable;
import org.simantics.db.layer0.variable.PropertyVariable;
import org.simantics.db.layer0.variable.PropertyVariableFactory;
import org.simantics.db.layer0.variable.RepresentsProperty;
import org.simantics.db.layer0.variable.ResourcePropertyVariable;
import org.simantics.db.layer0.variable.RoleProperty;
import org.simantics.db.layer0.variable.SerialisedProperty;
import org.simantics.db.layer0.variable.StandardResourceVariableSpaceManipulator;
import org.simantics.db.layer0.variable.TypePropertyVariable;
import org.simantics.db.layer0.variable.URIPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableDebugPolicy;
import org.simantics.db.layer0.variable.VariableImpl;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

@Deprecated
public class ResourceVariable
extends VariableImpl {
    protected final Resource resource;

    public ResourceVariable(Resource resource) {
        this.resource = resource;
    }

    @Override
    public <T> T getInterface(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (Resource.class == clazz) {
            return (T)this.resource;
        }
        if (VariableSpaceManipulator.class == clazz) {
            return (T)new StandardResourceVariableSpaceManipulator(this);
        }
        return null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getPropertyWriteResource(ReadGraph graph) throws DatabaseException {
        return this.resource;
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        return graph.getURI(this.resource);
    }

    @Override
    public Variable getChild(ReadGraph graph, String name) throws DatabaseException {
        if (VariableDebugPolicy.TRACE_GET_CHILD) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".getChild(" + name + ")");
        }
        if (name == null) {
            throw new MissingVariableException("Illegal argument null");
        }
        Map map = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(this.resource));
        Resource child = (Resource)map.get(name);
        if (child == null) {
            throw new MissingVariableException("Invalid child name " + name);
        }
        return (Variable)graph.adapt(child, Variable.class);
    }

    @Override
    public Variable getProperty(ReadGraph graph, String name) throws DatabaseException {
        if (name == null) {
            throw new MissingVariableException("Illegal argument null");
        }
        Map map = (Map)graph.syncRequest((Read)new PropertyMapOfResource(this.resource));
        Resource property = (Resource)map.get(name);
        if (property == null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if ("URI".equals(name)) {
                return new URIPropertyVariable(this);
            }
            if ("Resource".equals(name)) {
                return new ResourcePropertyVariable(this);
            }
            if ("Type".equals(name)) {
                return new TypePropertyVariable(this);
            }
            if ("Represents".equals(name)) {
                return new RepresentsProperty(this, this.resource);
            }
            if ("HasName".equals(name)) {
                return new PropertyVariable(this, L0.HasName);
            }
            if ("Parent".equals(name)) {
                return new ParentPropertyVariable(graph, this);
            }
            if ("Serialised".equals(name)) {
                return new SerialisedProperty(this, this.resource);
            }
            if ("Role".equals(name)) {
                return new RoleProperty(this, Variables.Role.CHILD);
            }
            throw new MissingVariableException("Unknown property " + name + " in " + this.getURI(graph));
        }
        PropertyVariableFactory factory = (PropertyVariableFactory)graph.adapt(property, PropertyVariableFactory.class);
        return factory.create(graph, this, property);
    }

    @Override
    public Collection<Variable> browseProperties(ReadGraph graph) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Map children = (Map)graph.syncRequest((Read)new PropertyMapOfResource(this.resource));
        for (Map.Entry property : children.entrySet()) {
            PropertyVariableFactory factory = (PropertyVariableFactory)graph.adapt((Resource)property.getValue(), PropertyVariableFactory.class);
            result.add(factory.create(graph, this, (Resource)property.getValue()));
        }
        result.add(new URIPropertyVariable(this));
        result.add(new TypePropertyVariable(this));
        return result;
    }

    @Override
    public Collection<Variable> browseChildren(ReadGraph graph) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Resource child : graph.getObjects(this.resource, Layer0.getInstance((ReadGraph)graph).ConsistsOf)) {
            result.add((Variable)graph.adapt(child, Variable.class));
        }
        return result;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceVariable r = (ResourceVariable)object;
        return this.resource.equals(r.resource);
    }
}

