/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.Variable;

public class ProxyChildVariable
extends AbstractChildVariable {
    protected final Variable base;
    protected final Variable parent;
    protected final Variable other;
    protected final String name;

    public ProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
        assert (base != null);
        assert (parent != null);
        assert (other != null);
        assert (name != null);
        this.base = base;
        this.parent = parent;
        this.other = other;
        this.name = name;
    }

    public Variable other() {
        return this.other;
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.name;
    }

    @Override
    public Object getSerialized(ReadGraph graph) throws DatabaseException {
        return this.name;
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        Variable otherChild = this.other.getPossibleChild(graph, name);
        if (otherChild == null) {
            return null;
        }
        return this.create(this.base, this, otherChild, name);
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Collection<Variable> otherChildren = this.other.browseChildren(graph);
        for (Variable o : otherChildren) {
            result.add(this.create(this.base, this, o, o.getName(graph)));
        }
        return result;
    }

    public Variable create(Variable base, Variable parent, Variable other, String name) {
        return new ProxyChildVariable(base, parent, other, name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.other != null ? this.other.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyChildVariable proxy = (ProxyChildVariable)obj;
        if (this.base != null ? !this.base.equals(proxy.base) : proxy.base != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(proxy.parent) : proxy.parent != null) {
            return false;
        }
        if (this.other != null ? !this.other.equals(proxy.other) : proxy.other != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(proxy.name) : proxy.name != null);
    }
}

