/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PropertyDataType;
import org.simantics.db.common.request.PropertyMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.EquationExpression;
import org.simantics.db.layer0.variable.Expression;
import org.simantics.db.layer0.variable.ParentPropertyVariable;
import org.simantics.db.layer0.variable.PropertyVariableFactory;
import org.simantics.db.layer0.variable.ResourceVariable;
import org.simantics.db.layer0.variable.RoleProperty;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

@Deprecated
public class PropertyVariable
extends ResourceVariable {
    protected final Variable subject;

    public PropertyVariable(Variable subject, Resource property) {
        super(property);
        this.subject = subject;
    }

    public <T extends Variable> T getSubject() {
        return (T)this.subject;
    }

    public Resource getSubjectResource(ReadGraph graph) throws DatabaseException {
        return this.subject.getInterface(graph, Resource.class);
    }

    @Override
    public <T> T getInterface(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (Datatype.class.equals(clazz)) {
            return (T)graph.syncRequest((Read)new PropertyDataType(this.getContainerResource(graph), this.resource));
        }
        return super.getInterface(graph, clazz);
    }

    @Override
    public Variable getProperty(ReadGraph graph, String name) throws DatabaseException {
        Map map;
        Resource propertyResource;
        if (name == null) {
            throw new MissingVariableException("Illegal argument null");
        }
        if ("Parent".equals(name)) {
            return new ParentPropertyVariable(this, this.subject);
        }
        if ("Role".equals(name)) {
            return new RoleProperty(this, Variables.Role.PROPERTY);
        }
        Resource object = graph.getPossibleObject(this.getContainerResource(graph), this.resource);
        if (object != null && (propertyResource = (Resource)(map = (Map)graph.syncRequest((Read)new PropertyMapOfResource(object))).get(name)) != null) {
            PropertyVariableFactory factory = (PropertyVariableFactory)graph.adapt(propertyResource, PropertyVariableFactory.class);
            return factory.create(graph, this, propertyResource);
        }
        return super.getProperty(graph, name);
    }

    @Override
    public Collection<Variable> browseProperties(ReadGraph graph) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Resource object = graph.getPossibleObject(this.getContainerResource(graph), this.resource);
        if (object != null) {
            Map map = (Map)graph.syncRequest((Read)new PropertyMapOfResource(object));
            for (Resource propertyResource : map.values()) {
                PropertyVariableFactory factory = (PropertyVariableFactory)graph.adapt(propertyResource, PropertyVariableFactory.class);
                result.add(factory.create(graph, this, propertyResource));
            }
        }
        result.addAll(super.browseProperties(graph));
        return result;
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource object = graph.getPossibleObject(this.getContainerResource(graph), this.resource);
        if (object == null) {
            return null;
        }
        Resource expressionResource = graph.getPossibleObject(object, L0X.HasExpression);
        if (expressionResource != null) {
            Expression expression = (Expression)graph.adapt(expressionResource, Expression.class);
            return expression.evaluate(graph, this, binding);
        }
        return (T)graph.getValue(object, binding);
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource object = graph.getPossibleObject(this.getContainerResource(graph), this.resource);
        if (object == null) {
            return null;
        }
        Resource expressionResource = graph.getPossibleObject(object, L0X.HasExpression);
        if (expressionResource != null) {
            Expression expression = (Expression)graph.adapt(expressionResource, Expression.class);
            return expression.evaluate(graph, this);
        }
        return (T)graph.getValue(object);
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        EquationExpression expression;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Statement object = graph.getPossibleStatement(this.getWriteResource((ReadGraph)graph), this.resource);
        if (object == null) {
            return;
        }
        Resource expressionResource = graph.getPossibleObject(object.getObject(), L0X.HasExpression);
        if (expressionResource != null && (expression = (EquationExpression)graph.adapt(expressionResource, EquationExpression.class)).isInvertible((ReadGraph)graph, this)) {
            expression.invert(graph, this, value, binding);
            return;
        }
        Resource subject = this.getWriteResource((ReadGraph)graph);
        Resource objectResource = object.getObject();
        if (object.isAsserted(this.getWriteResource((ReadGraph)graph))) {
            Resource type = graph.getPossibleType(objectResource, l0.Literal);
            objectResource = graph.newResource();
            graph.claim(objectResource, l0.InstanceOf, null, type);
            graph.claim(subject, this.resource, objectResource);
        }
        graph.claimValue(objectResource, value, binding);
    }

    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        if (this.subject instanceof ResourceVariable) {
            return ((ResourceVariable)this.subject).getResource();
        }
        if (this.subject instanceof PropertyVariable) {
            return ((PropertyVariable)this.subject).getContainerResource(graph);
        }
        throw new Error("Invalid subject " + this.subject);
    }

    public Resource getWriteResource(ReadGraph graph) throws DatabaseException {
        if (this.subject instanceof ResourceVariable) {
            return ((ResourceVariable)this.subject).getPropertyWriteResource(graph);
        }
        if (this.subject instanceof PropertyVariable) {
            return ((PropertyVariable)this.subject).getWriteResource(graph);
        }
        throw new Error("Invalid subject " + this.subject);
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        String property = (String)graph.getPossibleRelatedValue(this.resource, l0.HasName, (Binding)Bindings.STRING);
        String base = this.subject.getURI(graph);
        return String.valueOf(base) + "#" + property;
    }

    @Override
    public int hashCode() {
        return this.subject.hashCode() + 31 * this.resource.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyVariable r = (PropertyVariable)object;
        return this.subject.equals(r.subject) && this.resource.equals(r.resource);
    }
}

