/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PropertyMapOfResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.request.VariableRVIRequest;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ModelledVariablePropertyDescriptor;
import org.simantics.db.layer0.variable.ModelledVariablePropertyDescriptorImpl;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.RVIBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public abstract class AbstractVariable
implements Variable {
    protected abstract Variable getPossibleDomainProperty(ReadGraph var1, String var2) throws DatabaseException;

    public abstract Variable getPossibleExtraProperty(ReadGraph var1, String var2) throws DatabaseException;

    @Override
    public abstract Variable getPossibleChild(ReadGraph var1, String var2) throws DatabaseException;

    public abstract void collectExtraProperties(ReadGraph var1, Map<String, Variable> var2) throws DatabaseException;

    public abstract Map<String, Variable> collectDomainProperties(ReadGraph var1, Map<String, Variable> var2) throws DatabaseException;

    @Override
    public abstract Collection<Variable> getChildren(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract <T> T getValue(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract <T> T getValue(ReadGraph var1, Binding var2) throws DatabaseException;

    @Override
    public abstract void setValue(WriteGraph var1, Object var2, Binding var3) throws DatabaseException;

    @Override
    public abstract String getName(ReadGraph var1) throws DatabaseException;

    public abstract Object getSerialized(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract Variable getParent(ReadGraph var1) throws DatabaseException;

    public abstract Variables.Role getRole(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract Resource getRepresents(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract Set<String> getClassifications(ReadGraph var1) throws DatabaseException;

    public void validate(ReadGraph graph) throws DatabaseException {
    }

    public String getIdentifier() {
        return this.getClass().getSimpleName();
    }

    protected Variable resolveChild(ReadGraph graph, Resource resource) throws DatabaseException {
        String rName = (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        for (Variable child : this.browseChildren(graph)) {
            String name = (String)child.getPossiblePropertyValue(graph, "HasName", (Binding)Bindings.STRING);
            if (!rName.equals(name)) continue;
            return child;
        }
        throw new DatabaseException("Could not resolve child " + resource);
    }

    protected Variable resolveProperty(ReadGraph graph, Resource resource) throws DatabaseException {
        String rName = (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        for (Variable child : this.browseProperties(graph)) {
            String name = (String)child.getPossiblePropertyValue(graph, "HasName", (Binding)Bindings.STRING);
            if (!rName.equals(name)) continue;
            return child;
        }
        throw new DatabaseException("Could not resolve child " + resource);
    }

    protected Variable resolvePossibleChild(ReadGraph graph, Resource resource) throws DatabaseException {
        String rName = (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        for (Variable child : this.browseChildren(graph)) {
            String name = (String)child.getPossiblePropertyValue(graph, "HasName", (Binding)Bindings.STRING);
            if (!rName.equals(name)) continue;
            return child;
        }
        return null;
    }

    protected Variable resolvePossibleProperty(ReadGraph graph, Resource resource) throws DatabaseException {
        String rName = (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        for (Variable child : this.browseProperties(graph)) {
            String name = (String)child.getPossiblePropertyValue(graph, "HasName", (Binding)Bindings.STRING);
            if (!rName.equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        return this.getName(graph);
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        Resource resource = this.getRepresents(graph);
        if (resource == null) {
            return null;
        }
        return graph.getSingleObject(resource, Layer0.getInstance((ReadGraph)graph).InstanceOf);
    }

    public RVI.RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RVI getRVI(ReadGraph graph) throws DatabaseException {
        Databoard databoard = (Databoard)graph.getService(Databoard.class);
        Binding rviBinding = databoard.getBindingUnchecked(RVI.class);
        if (Variables.isContext(graph, this)) {
            return RVI.empty(rviBinding);
        }
        Variable parent = this.getParent(graph);
        if (parent == null) {
            throw new MissingVariableException("no parent for variable " + this + " (URI=" + this.getPossibleURI(graph) + ")");
        }
        RVI base = (RVI)((Object)graph.syncRequest((Read)new VariableRVIRequest(parent)));
        RVI.RVIPart part = this.getRVIPart(graph);
        return new RVIBuilder(base).append(part).toRVI();
    }

    protected Variable getDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        Variable property = this.getPossibleDomainProperty(graph, name);
        if (property == null) {
            throw new MissingVariableException(String.valueOf(this.getIdentifier()) + ": Didn't find property " + name + ".");
        }
        return property;
    }

    protected void addProperty(Map<String, Variable> properties, String name, Object value, Binding binding) {
        if (value != null) {
            properties.put(name, new ConstantPropertyVariable(this, name, value, binding));
        }
    }

    protected Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        return new ConstantPropertyVariable(this, "HasName", this.getName(graph), (Binding)Bindings.STRING);
    }

    protected Variable getLabelVariable(ReadGraph graph) throws DatabaseException {
        return new ConstantPropertyVariable(this, "HasLabel", this.getLabel(graph), (Binding)Bindings.STRING);
    }

    @Override
    public final Collection<Variable> browseProperties(ReadGraph graph) throws DatabaseException {
        return this.getProperties(graph);
    }

    private Map<String, Variable> getPropertyMap(ReadGraph graph, String classification) throws DatabaseException {
        return this.collectDomainProperties(graph, classification, null);
    }

    private Map<String, Variable> getPropertyMap(ReadGraph graph) throws DatabaseException {
        HashMap<String, Variable> properties = new HashMap<String, Variable>();
        this.addProperty(properties, "Type", this.getPossibleType(graph), null);
        this.addProperty(properties, "URI", this.getPossibleURI(graph), (Binding)Bindings.STRING);
        this.addProperty(properties, "Parent", this.getParent(graph), null);
        this.addProperty(properties, "Role", (Object)this.getRole(graph), (Binding)Bindings.STRING);
        this.addProperty(properties, "Represents", this.getPossibleRepresents(graph), null);
        this.collectExtraProperties(graph, properties);
        this.collectDomainProperties(graph, properties);
        return properties;
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph) throws DatabaseException {
        return this.getPropertyMap(graph).values();
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph, String classification) throws DatabaseException {
        Map<String, Variable> propertyMap = this.getPropertyMap(graph, classification);
        if (propertyMap == null) {
            return Collections.emptyList();
        }
        return propertyMap.values();
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph, Resource property) throws DatabaseException {
        return this.getProperties(graph, this.uri(graph, property));
    }

    @Override
    public final Collection<Variable> browseChildren(ReadGraph graph) throws DatabaseException {
        return this.getChildren(graph);
    }

    @Override
    public Variable getPossibleProperty(ReadGraph graph, String name) throws DatabaseException {
        Object value;
        if ("HasName".equals(name)) {
            return this.getNameVariable(graph);
        }
        if ("HasLabel".equals(name)) {
            return this.getLabelVariable(graph);
        }
        if ("Type".equals(name) && (value = this.getPossibleType(graph)) != null) {
            return new ConstantPropertyVariable(this, name, value, null);
        }
        if ("URI".equals(name) && (value = this.getURI(graph)) != null) {
            return new ConstantPropertyVariable(this, name, value, (Binding)Bindings.STRING);
        }
        if ("Serialised".equals(name) && (value = this.getSerialized(graph)) != null) {
            return new ConstantPropertyVariable(this, name, value, (Binding)Bindings.STRING);
        }
        if ("Parent".equals(name) && (value = this.getParent(graph)) != null) {
            return new ConstantPropertyVariable(this, name, value, null);
        }
        if ("Role".equals(name) && (value = this.getRole(graph)) != null) {
            return new ConstantPropertyVariable(this, name, value, null);
        }
        if ("Represents".equals(name) && (value = this.getRepresents(graph)) != null) {
            return new ConstantPropertyVariable(this, name, value, null);
        }
        Variable extra = this.getPossibleExtraProperty(graph, name);
        if (extra != null) {
            return extra;
        }
        return this.getPossibleDomainProperty(graph, name);
    }

    @Override
    public Variable getPossibleProperty(ReadGraph graph, Resource property) throws DatabaseException {
        return this.getPossibleProperty(graph, this.name(graph, property));
    }

    protected <T> T checkNull(ReadGraph graph, Object value) throws DatabaseException {
        if (value == null) {
            throw new MissingVariableValueException(String.valueOf(this.getClass().getSimpleName()) + ": Didn't find value for " + this.getPossibleURI(graph));
        }
        return (T)value;
    }

    private String name(ReadGraph graph, Resource property) throws DatabaseException {
        return (String)graph.getRelatedValue(property, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
    }

    private String uri(ReadGraph graph, Resource property) throws DatabaseException {
        return graph.getURI(property);
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, String name) throws DatabaseException {
        if ("HasName".equals(name)) {
            return this.checkNull(graph, this.getName(graph));
        }
        if ("HasLabel".equals(name)) {
            return this.checkNull(graph, this.getLabel(graph));
        }
        if ("Type".equals(name)) {
            return this.checkNull(graph, this.getPossibleType(graph));
        }
        if ("URI".equals(name)) {
            return this.checkNull(graph, this.getURI(graph));
        }
        if ("Serialised".equals(name)) {
            return this.checkNull(graph, this.getSerialized(graph));
        }
        if ("Parent".equals(name)) {
            return this.checkNull(graph, this.getParent(graph));
        }
        if ("Role".equals(name)) {
            return this.checkNull(graph, (Object)this.getRole(graph));
        }
        if ("Represents".equals(name)) {
            return this.checkNull(graph, this.getRepresents(graph));
        }
        Variable extra = this.getPossibleExtraProperty(graph, name);
        if (extra != null) {
            return extra.getValue(graph);
        }
        return this.getDomainProperty(graph, name).getValue(graph);
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, Resource property) throws DatabaseException {
        return this.getPropertyValue(graph, this.name(graph, property));
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, String name) throws DatabaseException {
        if ("HasName".equals(name)) {
            return (T)this.getName(graph);
        }
        if ("HasLabel".equals(name)) {
            return (T)this.getLabel(graph);
        }
        if ("Type".equals(name)) {
            return (T)this.getPossibleType(graph);
        }
        if ("URI".equals(name)) {
            return (T)this.getURI(graph);
        }
        if ("Serialised".equals(name)) {
            return (T)this.getSerialized(graph);
        }
        if ("Parent".equals(name)) {
            return (T)this.getParent(graph);
        }
        if ("Role".equals(name)) {
            return (T)((Object)this.getRole(graph));
        }
        if ("Represents".equals(name)) {
            return (T)this.getRepresents(graph);
        }
        Variable extra = this.getPossibleExtraProperty(graph, name);
        if (extra != null) {
            return extra.getValue(graph);
        }
        Variable property = this.getPossibleDomainProperty(graph, name);
        if (property == null) {
            return null;
        }
        return property.getPossibleValue(graph);
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, Resource property) throws DatabaseException {
        return this.getPossiblePropertyValue(graph, this.name(graph, property));
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, String name, Binding binding) throws DatabaseException {
        Variable property;
        if (binding instanceof StringBinding) {
            StringBinding sb = (StringBinding)binding;
            try {
                if ("HasName".equals(name)) {
                    return (T)sb.create((String)this.checkNull(graph, this.getName(graph)));
                }
                if ("HasLabel".equals(name)) {
                    return (T)sb.create((String)this.checkNull(graph, this.getLabel(graph)));
                }
                if ("URI".equals(name)) {
                    return (T)sb.create((String)this.checkNull(graph, this.getURI(graph)));
                }
                if ("Serialised".equals(name)) {
                    return (T)sb.create((String)this.checkNull(graph, this.getSerialized(graph)));
                }
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        if ((property = this.getPossibleExtraProperty(graph, name)) != null) {
            return property.getValue(graph, binding);
        }
        property = this.getPossibleDomainProperty(graph, name);
        if (property == null) {
            throw new MissingVariableException("Didn't find property " + name + " for " + this + ".");
        }
        return property.getValue(graph, binding);
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, Resource property, Binding binding) throws DatabaseException {
        return this.getPropertyValue(graph, this.name(graph, property), binding);
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, String name, Binding binding) throws DatabaseException {
        Variable property;
        if (binding instanceof StringBinding) {
            StringBinding sb = (StringBinding)binding;
            try {
                if ("HasName".equals(name)) {
                    return (T)sb.create(this.getName(graph));
                }
                if ("HasLabel".equals(name)) {
                    return (T)sb.create(this.getLabel(graph));
                }
                if ("URI".equals(name)) {
                    return (T)sb.create(this.getURI(graph));
                }
                if ("Serialised".equals(name)) {
                    return (T)sb.create((String)this.getSerialized(graph));
                }
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        if ((property = this.getPossibleExtraProperty(graph, name)) != null) {
            return property.getPossibleValue(graph, binding);
        }
        property = this.getPossibleDomainProperty(graph, name);
        if (property == null) {
            return null;
        }
        return property.getPossibleValue(graph, binding);
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, Resource property, Binding binding) throws DatabaseException {
        return this.getPossiblePropertyValue(graph, this.name(graph, property), binding);
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        try {
            this.setValue(graph, value, Bindings.getBinding(value.getClass()));
        }
        catch (BindingConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void setPropertyValue(WriteGraph graph, String name, Object value) throws DatabaseException {
        this.getProperty((ReadGraph)graph, name).setValue(graph, value);
    }

    @Override
    public void setPropertyValue(WriteGraph graph, Resource property, Object value) throws DatabaseException {
        this.setPropertyValue(graph, this.name((ReadGraph)graph, property), value);
    }

    @Override
    public void setPropertyValue(WriteGraph graph, String name, Object value, Binding binding) throws DatabaseException {
        this.getProperty((ReadGraph)graph, name).setValue(graph, value, binding);
    }

    @Override
    public void setPropertyValue(WriteGraph graph, Resource property, Object value, Binding binding) throws DatabaseException {
        this.setPropertyValue(graph, this.name((ReadGraph)graph, property), value, binding);
    }

    @Override
    public Variable getChild(ReadGraph graph, String name) throws DatabaseException {
        Variable child = this.getPossibleChild(graph, name);
        if (child == null) {
            throw new MissingVariableException("Didn't find child " + name + " for " + this.getIdentifier() + ".");
        }
        return child;
    }

    @Override
    public Variable getProperty(ReadGraph graph, String name) throws DatabaseException {
        Variable result = this.getPossibleProperty(graph, name);
        if (result == null) {
            throw new MissingVariableException(String.valueOf(this.getClass().getSimpleName()) + ": Didn't find property " + name + " for " + this.getPossibleURI(graph) + ".");
        }
        return result;
    }

    @Override
    public Variable getProperty(ReadGraph graph, Resource property) throws DatabaseException {
        return this.getProperty(graph, this.name(graph, property));
    }

    @Override
    public Variable browse(ReadGraph graph, String suffix) throws DatabaseException {
        Variable result = this.browsePossible(graph, suffix);
        if (result == null) {
            throw new MissingVariableException("Didn't find " + suffix + " for " + this + " (" + this.getPossibleURI(graph) + ").");
        }
        return result;
    }

    private static int getSegmentEnd(String suffix) {
        int pos = 1;
        while (pos < suffix.length()) {
            char c = suffix.charAt(pos);
            if (c == '/' || c == '#') break;
            ++pos;
        }
        return pos;
    }

    @Override
    public Variable browsePossible(ReadGraph graph, String suffix) throws DatabaseException {
        if (suffix.isEmpty()) {
            return this;
        }
        switch (suffix.charAt(0)) {
            case '.': {
                Variable parent = this.getParent(graph);
                if (parent == null) {
                    return null;
                }
                return parent.browsePossible(graph, suffix.substring(1));
            }
            case '#': {
                int segmentEnd = AbstractVariable.getSegmentEnd(suffix);
                Variable property = this.getPossibleProperty(graph, AbstractVariable.decodeString(suffix.substring(1, segmentEnd)));
                if (property == null) {
                    return null;
                }
                return property.browsePossible(graph, suffix.substring(segmentEnd));
            }
            case '/': {
                int segmentEnd = AbstractVariable.getSegmentEnd(suffix);
                Variable child = this.getPossibleChild(graph, AbstractVariable.decodeString(suffix.substring(1, segmentEnd)));
                if (child == null) {
                    return null;
                }
                return child.browsePossible(graph, suffix.substring(segmentEnd));
            }
        }
        return null;
    }

    @Override
    public Variable browse(ReadGraph graph, Resource config) throws DatabaseException {
        Variable variable = this.browsePossible(graph, config);
        if (variable == null) {
            throw new MissingVariableException("Didn't find a variable related to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)config) + ".");
        }
        return variable;
    }

    @Override
    public Variable browsePossible(ReadGraph graph, Resource config) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(config, l0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            return null;
        }
        return this.getPossibleChild(graph, name);
    }

    @Override
    public <T> T getInterface(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return null;
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        this.validate(graph);
        Variable parent = this.getParent(graph);
        if (parent == null) {
            throw new InvalidVariableException(this + " has no URI");
        }
        return String.valueOf(parent.getURI(graph)) + this.getRole(graph).getIdentifier() + AbstractVariable.encodeString(this.getName(graph));
    }

    public String getPossibleURI(ReadGraph graph) throws DatabaseException {
        Variable parent = this.getParent(graph);
        if (parent == null) {
            return null;
        }
        if (parent instanceof AbstractVariable) {
            String parentUri = ((AbstractVariable)parent).getPossibleURI(graph);
            if (parentUri == null) {
                return null;
            }
            return String.valueOf(parentUri) + this.getRole(graph).getIdentifier() + AbstractVariable.encodeString(this.getName(graph));
        }
        return null;
    }

    @Override
    public <T> T getPossibleValue(ReadGraph graph) throws DatabaseException {
        try {
            return this.getValue(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Variant getVariantValue(ReadGraph graph) throws DatabaseException {
        Binding binding = this.getPossibleDefaultBinding(graph);
        if (binding != null) {
            Object value = this.getValue(graph, binding);
            return new Variant(binding, value);
        }
        Object value = this.getValue(graph);
        try {
            binding = value != null ? Bindings.getBinding(value.getClass()) : null;
            return new Variant(binding, value);
        }
        catch (BindingConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public <T> T getPossibleValue(ReadGraph graph, Binding binding) throws DatabaseException {
        try {
            return this.getValue(graph, binding);
        }
        catch (MissingVariableValueException e) {
            return null;
        }
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        throw new AdaptionException(this + " does not support adaption to " + clazz);
    }

    @Override
    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        try {
            return this.adapt(graph, clazz);
        }
        catch (AdaptionException e) {
            return null;
        }
    }

    public static String encodeString(String string) throws DatabaseException {
        return URIStringUtils.escape((String)string);
    }

    public static String decodeString(String string) throws DatabaseException {
        return URIStringUtils.unescape((String)string);
    }

    protected Variable getPossiblePropertyFromContext(ReadGraph graph, Resource context, String name) throws DatabaseException {
        Map predicates = (Map)graph.syncRequest((Read)new PropertyMapOfResource(context));
        Resource property = (Resource)predicates.get(name);
        if (property == null) {
            return null;
        }
        Resource object = graph.getSingleObject(context, property);
        Variable objectAdapter = (Variable)graph.getPossibleContextualAdapter(object, (Object)new ModelledVariablePropertyDescriptorImpl(this, context, property), ModelledVariablePropertyDescriptor.class, Variable.class);
        if (objectAdapter != null) {
            return objectAdapter;
        }
        return (Variable)graph.getPossibleContextualAdapter(property, (Object)new ModelledVariablePropertyDescriptorImpl(this, context, property), ModelledVariablePropertyDescriptor.class, Variable.class);
    }

    protected Map<String, Variable> collectPropertiesFromContext(ReadGraph graph, Resource context, Map<String, Variable> properties) throws DatabaseException {
        for (Map.Entry entry : ((Map)graph.syncRequest((Read)new PropertyMapOfResource(context))).entrySet()) {
            String name = (String)entry.getKey();
            Resource property = (Resource)entry.getValue();
            Resource object = graph.getSingleObject(context, property);
            Variable objectAdapter = (Variable)graph.getPossibleContextualAdapter(object, (Object)new ModelledVariablePropertyDescriptorImpl(this, context, property), ModelledVariablePropertyDescriptor.class, Variable.class);
            if (objectAdapter != null) {
                if (objectAdapter == null) continue;
                if (properties == null) {
                    properties = new HashMap<String, Variable>();
                }
                properties.put(name, objectAdapter);
                continue;
            }
            Variable predicateAdapter = (Variable)graph.getPossibleContextualAdapter(property, (Object)new ModelledVariablePropertyDescriptorImpl(this, context, property), ModelledVariablePropertyDescriptor.class, Variable.class);
            if (predicateAdapter == null) continue;
            if (properties == null) {
                properties = new HashMap<String, Variable>();
            }
            properties.put(name, predicateAdapter);
        }
        return properties;
    }

    @Override
    public Variable resolve(ReadGraph graph, RVI.RVIPart part) throws DatabaseException {
        if (part instanceof RVI.StringRVIPart) {
            RVI.StringRVIPart srp = (RVI.StringRVIPart)part;
            if (Variables.Role.CHILD.equals((Object)srp.getRole())) {
                return this.getChild(graph, srp.string);
            }
            if (Variables.Role.PROPERTY.equals((Object)srp.getRole())) {
                return this.getProperty(graph, srp.string);
            }
        } else if (part instanceof RVI.ResourceRVIPart) {
            RVI.ResourceRVIPart rrp = (RVI.ResourceRVIPart)part;
            if (Variables.Role.CHILD.equals((Object)rrp.getRole())) {
                return this.resolveChild(graph, rrp.resource);
            }
            if (Variables.Role.PROPERTY.equals((Object)rrp.getRole())) {
                return this.resolveProperty(graph, rrp.resource);
            }
        }
        throw new DatabaseException("Unrecognized RVIPart: " + part);
    }

    @Override
    public Variable resolvePossible(ReadGraph graph, RVI.RVIPart part) throws DatabaseException {
        if (part instanceof RVI.StringRVIPart) {
            RVI.StringRVIPart srp = (RVI.StringRVIPart)part;
            if (Variables.Role.CHILD.equals((Object)srp.getRole())) {
                return this.getPossibleChild(graph, srp.string);
            }
            if (Variables.Role.PROPERTY.equals((Object)srp.getRole())) {
                return this.getPossibleProperty(graph, srp.string);
            }
        } else if (part instanceof RVI.ResourceRVIPart) {
            RVI.ResourceRVIPart rrp = (RVI.ResourceRVIPart)part;
            if (Variables.Role.CHILD.equals((Object)rrp.getRole())) {
                return this.resolvePossibleChild(graph, rrp.resource);
            }
            if (Variables.Role.PROPERTY.equals((Object)rrp.getRole())) {
                return this.resolvePossibleProperty(graph, rrp.resource);
            }
        }
        throw new DatabaseException("Unrecognized RVIPart: " + part);
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("No data type.");
    }

    public Binding getDefaultBinding(ReadGraph graph) throws DatabaseException {
        Datatype type = this.getDatatype(graph);
        return Bindings.getBinding((Datatype)type);
    }

    public Binding getPossibleDefaultBinding(ReadGraph graph) throws DatabaseException {
        try {
            return this.getDefaultBinding(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Datatype getPossibleDatatype(ReadGraph graph) throws DatabaseException {
        try {
            return this.getDatatype(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException(String.valueOf(this.getClass().getSimpleName()) + ": No predicate property for " + this.getPossibleURI(graph));
    }

    @Override
    public Variable getPossiblePredicate(ReadGraph graph) throws DatabaseException {
        try {
            return this.getPredicate(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Resource getPredicateResource(ReadGraph graph) throws DatabaseException {
        return this.getPredicate(graph).getRepresents(graph);
    }

    @Override
    public Resource getPossiblePredicateResource(ReadGraph graph) throws DatabaseException {
        Variable predicate = this.getPossiblePredicate(graph);
        if (predicate == null) {
            return null;
        }
        return predicate.getPossibleRepresents(graph);
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        try {
            return this.getRepresents(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        try {
            return this.getType(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    @Override
    public Resource getType(ReadGraph graph, Resource baseType) throws DatabaseException {
        Resource resource = this.getRepresents(graph);
        if (resource == null) {
            return null;
        }
        return graph.getSingleType(resource, baseType);
    }

    @Override
    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
        Resource resource = this.getPossibleRepresents(graph);
        if (resource == null) {
            return null;
        }
        return graph.getPossibleType(resource, baseType);
    }

    public Map<String, Variable> collectDomainProperties(ReadGraph graph, String classification, Map<String, Variable> map) throws DatabaseException {
        Map<String, Variable> all = this.collectDomainProperties(graph, null);
        for (Map.Entry<String, Variable> entry : all.entrySet()) {
            Set<String> classifications = entry.getValue().getClassifications(graph);
            if (!classifications.contains(classification)) continue;
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public RVI getPossibleRVI(ReadGraph graph) throws DatabaseException {
        try {
            return this.getRVI(graph);
        }
        catch (DatabaseException e) {
            return null;
        }
    }
}

