/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PropertyMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;

public abstract class AbstractPropertyVariable
extends AbstractVariable {
    public final VariableNode node;
    private static final Binding datatype_binding = Bindings.getBindingUnchecked(Datatype.class);

    public abstract Resource getPropertyResource(ReadGraph var1) throws DatabaseException;

    public abstract Resource getContainerResource(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract Datatype getDatatype(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract Variable getPredicate(ReadGraph var1) throws DatabaseException;

    public AbstractPropertyVariable() {
        this.node = null;
    }

    public AbstractPropertyVariable(VariableNode node) {
        this.node = node;
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        Object value = this.getPossibleValue(graph);
        return value == null ? "<no value>" : value.toString();
    }

    public String getUnit(ReadGraph graph) throws DatabaseException {
        ArrayType at;
        Datatype cdt;
        Datatype dt = this.getPossibleDatatype(graph);
        if (dt == null) {
            return "";
        }
        if (dt instanceof NumberType) {
            String result = ((NumberType)dt).getUnit();
            return result != null ? result : "";
        }
        if (dt instanceof ArrayType && (cdt = (at = (ArrayType)dt).componentType()) instanceof NumberType) {
            String result = ((NumberType)cdt).getUnit();
            return result != null ? result : "";
        }
        return null;
    }

    @Override
    public Variables.Role getRole(ReadGraph graph) throws DatabaseException {
        return Variables.Role.PROPERTY;
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        return properties;
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        Variable parent = this.getParent(graph);
        if (parent == null) {
            return null;
        }
        Resource parentRepresents = parent.getPossibleRepresents(graph);
        if (parentRepresents == null) {
            return null;
        }
        Resource predicate = (Resource)((Map)graph.syncRequest((Read)new PropertyMapOfResource(parentRepresents))).get(this.getName(graph));
        if (predicate == null) {
            return null;
        }
        return graph.getPossibleObject(parentRepresents, predicate);
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        Variable parent = this.getParent(graph);
        if (parent == null) {
            return null;
        }
        Resource parentRepresents = parent.getPossibleRepresents(graph);
        if (parentRepresents == null) {
            return null;
        }
        Resource predicate = (Resource)((Map)graph.syncRequest((Read)new PropertyMapOfResource(parentRepresents))).get(this.getName(graph));
        if (predicate == null) {
            return null;
        }
        return graph.getPossibleObject(parentRepresents, predicate);
    }

    @Override
    public Variable getPossibleExtraProperty(ReadGraph graph, String name) throws DatabaseException {
        if ("DATATYPE".equals(name)) {
            Datatype value = this.getPossibleDatatype(graph);
            if (value != null) {
                return new ConstantPropertyVariable(this, name, value, datatype_binding);
            }
        } else {
            Variable value;
            if ("UNIT".equals(name)) {
                String value2 = this.getUnit(graph);
                return new ConstantPropertyVariable(this, name, value2, (Binding)Bindings.STRING);
            }
            if ("PREDICATE".equals(name) && (value = this.getPossiblePredicate(graph)) != null) {
                return new ConstantPropertyVariable(this, name, value, null);
            }
        }
        return null;
    }

    @Override
    public void collectExtraProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        this.addProperty(properties, "PREDICATE", this.getPossiblePredicate(graph), null);
        Datatype dt = this.getPossibleDatatype(graph);
        if (dt != null) {
            this.addProperty(properties, "DATATYPE", dt, datatype_binding);
        }
        this.addProperty(properties, "UNIT", this.getUnit(graph), (Binding)Bindings.STRING);
    }

    @Override
    public RVI.RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
        return new RVI.StringRVIPart(Variables.Role.PROPERTY, this.getName(graph));
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        return Collections.emptySet();
    }
}

