/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class WriteUtils {
    public static <T> void ensureValue(WriteGraph graph, Resource resource, Resource relation, Binding binding, T value) throws DatabaseException {
        Object existing = graph.getPossibleRelatedValue(resource, relation, binding);
        if (!value.equals(existing)) {
            graph.claimLiteral(resource, relation, value, binding);
        }
    }

    public static <T> void ensureValue(WriteGraph graph, Resource resource, Resource relation, T value) throws DatabaseException {
        Object existing = graph.getPossibleRelatedValue(resource, relation);
        if (!value.equals(existing)) {
            graph.claimLiteral(resource, relation, value);
        }
    }

    public static void assertion(WriteGraph graph, Resource type, Resource predicate, Resource object) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        WriteUtils.createInstance(graph, l0.Assertion, l0.HasPredicate, predicate, l0.HasObject, object, l0.Asserts_Inverse, type);
    }

    public static Resource createScalarString(WriteGraph graph, String string) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createScalarString(graph, string, l0.String);
    }

    public static Resource createScalarString(WriteGraph graph, String string, Resource type) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, l0.InstanceOf, null, type);
        graph.claimValue(ret, (Object)string);
        return ret;
    }

    public static Resource createScalarInteger(WriteGraph graph, int value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, l0.InstanceOf, null, l0.Integer);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createScalarLong(WriteGraph graph, long value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, l0.InstanceOf, null, l0.Long);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createScalarFloat(WriteGraph graph, float value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, l0.InstanceOf, null, l0.Float);
        graph.claimValue(ret, (Object)Float.valueOf(value));
        return ret;
    }

    public static Resource createScalarBoolean(WriteGraph graph, boolean value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, l0.InstanceOf, null, l0.Boolean);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createScalarDouble(WriteGraph graph, double value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, l0.InstanceOf, null, l0.Double);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createDoubleArray(WriteGraph graph, double[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, l0.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createDoubleArray(WriteGraph graph, double[] array) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createDoubleArray(graph, array, l0.DoubleArray);
    }

    public static Resource createIntegerArray(WriteGraph graph, int[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createIntegerArray(WriteGraph graph, int[] array) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createIntegerArray(graph, array, l0.IntegerArray);
    }

    public static Resource createLongArray(WriteGraph graph, long[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, l0.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createLongArray(WriteGraph graph, long[] array) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createLongArray(graph, array, l0.LongArray);
    }

    public static Resource createFloatArray(WriteGraph graph, float[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, l0.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createFloatArray(WriteGraph graph, float[] array) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createFloatArray(graph, array, l0.FloatArray);
    }

    public static Resource createBooleanArray(WriteGraph graph, boolean[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createBooleanArray(WriteGraph graph, boolean[] array) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createBooleanArray(graph, array, l0.BooleanArray);
    }

    public static Resource createStringArray(WriteGraph graph, String[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, l0.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createStringArray(WriteGraph graph, String[] array) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return WriteUtils.createStringArray(graph, array, l0.StringArray);
    }

    private static Resource getObjectOrCreatePrimitiveValue(WriteGraph g, Object object) throws DatabaseException {
        if (object == null) {
            throw new NullPointerException("null object");
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Resource) {
            return (Resource)object;
        }
        if (String.class.equals(clazz)) {
            return WriteUtils.createScalarString(g, (String)object);
        }
        if (String[].class.equals(clazz)) {
            return WriteUtils.createStringArray(g, (String[])object);
        }
        if (Integer.class.equals(clazz)) {
            return WriteUtils.createScalarInteger(g, (Integer)object);
        }
        if (int[].class.equals(clazz)) {
            return WriteUtils.createIntegerArray(g, (int[])object);
        }
        if (Long.class.equals(clazz)) {
            return WriteUtils.createScalarLong(g, (Long)object);
        }
        if (long[].class.equals(clazz)) {
            return WriteUtils.createLongArray(g, (long[])object);
        }
        if (Float.class.equals(clazz)) {
            return WriteUtils.createScalarFloat(g, ((Float)object).floatValue());
        }
        if (float[].class.equals(clazz)) {
            return WriteUtils.createFloatArray(g, (float[])object);
        }
        if (Double.class.equals(clazz)) {
            return WriteUtils.createScalarDouble(g, (Double)object);
        }
        if (double[].class.equals(clazz)) {
            return WriteUtils.createDoubleArray(g, (double[])object);
        }
        if (Boolean.class.equals(clazz)) {
            return WriteUtils.createScalarBoolean(g, (Boolean)object);
        }
        if (boolean[].class.equals(clazz)) {
            return WriteUtils.createBooleanArray(g, (boolean[])object);
        }
        throw new UnsupportedOperationException("unsupported object type: " + object);
    }

    public static Resource create(WriteGraph graph, Object ... predicateObjectPairs) throws DatabaseException {
        assert (predicateObjectPairs.length % 2 == 0);
        Resource resource = graph.newResource();
        int i = 0;
        while (i < predicateObjectPairs.length) {
            Resource predicate = (Resource)predicateObjectPairs[i];
            Object _object = predicateObjectPairs[i + 1];
            Resource object = WriteUtils.getObjectOrCreatePrimitiveValue(graph, _object);
            graph.claim(resource, predicate, object);
            i += 2;
        }
        return resource;
    }

    public static Resource createInstance(WriteGraph graph, Resource type, Object ... predicateObjectPairs) throws DatabaseException {
        assert (predicateObjectPairs.length % 2 == 0);
        Resource resource = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(resource, b.InstanceOf, null, type);
        int i = 0;
        while (i < predicateObjectPairs.length) {
            Resource predicate = (Resource)predicateObjectPairs[i];
            Object _object = predicateObjectPairs[i + 1];
            Resource object = WriteUtils.getObjectOrCreatePrimitiveValue(graph, _object);
            graph.claim(resource, predicate, object);
            i += 2;
        }
        return resource;
    }
}

