/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.Subgraphs;
import org.simantics.db.layer0.util.TransferableGraphConfiguration;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class TransferableGraphRequest2
implements Read<TransferableGraph1> {
    public static String LOG_FILE = "transferableGraph.log";
    private static final boolean LOG = false;
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    private TransferableGraphConfiguration configuration;
    static DataOutput log;
    Layer0 L0;
    TIntArrayList inverses = new TIntArrayList();
    int[] statements;
    int statementIndex = 0;
    TIntIntHashMap ids;
    TIntObjectMap<Variant> values;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    int id = 0;
    int internalCount;
    int indent = 0;
    private SerialisationSupport support;

    private static void log(String line) {
    }

    public TransferableGraphRequest2(Collection<Pair<Resource, String>> roots, Resource model) {
        this.configuration = new TransferableGraphConfiguration();
        this.configuration.roots = roots;
        this.configuration.model = model;
    }

    public TransferableGraphRequest2(Collection<Pair<Resource, String>> roots) {
        this(roots, null);
    }

    public TransferableGraphRequest2(TransferableGraphConfiguration conf) {
        this.configuration = conf;
    }

    private boolean validateExternal(Resource r) {
        if (this.configuration.disallowedExternals != null) {
            System.err.println("validateExternal agains " + this.configuration.disallowedExternals);
            return !this.configuration.disallowedExternals.contains(r);
        }
        return true;
    }

    private Resource getResource(int r) throws DatabaseException {
        return this.support.getResource(r);
    }

    public int getInternalId(int r) {
        return this.ids.get(r);
    }

    public int getId(ReadGraph graph, int r, int predicate) throws DatabaseException {
        if (this.ids.containsKey(r)) {
            int ret = this.ids.get(r);
            if (ret == -1) {
                int i = 0;
                while (i <= this.indent) {
                    System.out.print("  ");
                    ++i;
                }
                System.out.println("Cycle!!!");
            }
            return ret;
        }
        Collection parents = graph.getObjects(this.getResource(r), this.L0.PartOf);
        if (parents.size() != 1) {
            throw new ValidationException("Reference to external resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(r), (boolean)true) + " without unique uri (" + parents.size() + " parents).");
        }
        for (Resource p : parents) {
            ++this.indent;
            if (!this.validateExternal(p)) {
                throw new ValidationException("References to '" + graph.getURI(p) + "' are not allowed.");
            }
            this.externalParents.add(this.getId(graph, this.support.getTransientId(p), 0));
            --this.indent;
        }
        this.externalNames.add((String)graph.getRelatedValue(this.getResource(r), this.L0.HasName));
        this.ids.put(r, this.id);
        return this.id++;
    }

    public void addId(ReadGraph graph, int r, int predicate) throws DatabaseException {
        this.statements[this.statementIndex++] = this.getId(graph, r, predicate);
    }

    public void setExternals(Collection<Resource> rs) {
        this.configuration.externals = rs;
    }

    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
        this.support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        long total = System.nanoTime();
        long startupTime = System.nanoTime();
        ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
        this.ids = new TIntIntHashMap();
        this.values = new TIntObjectHashMap();
        ArrayList<Resource> rootResources = new ArrayList<Resource>();
        for (Pair<Resource, String> p : this.configuration.roots) {
            rootResources.add((Resource)p.first);
        }
        HashMap<Resource, SubgraphExtent.ExtentStatus> preStatus = new HashMap<Resource, SubgraphExtent.ExtentStatus>();
        for (Resource root : rootResources) {
            Resource name = graph.getPossibleObject(root, this.L0.HasName);
            if (name == null) continue;
            preStatus.put(name, SubgraphExtent.ExtentStatus.EXCLUDED);
        }
        for (Resource r : this.configuration.externals) {
            preStatus.put(r, SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        long startupTimeEnd = System.nanoTime();
        long domainTime = System.nanoTime();
        String otherStatements = "other" + UUID.randomUUID().toString();
        String valueFileName = "value" + UUID.randomUUID().toString();
        File otherStatementsFile = new File(otherStatements);
        File valueFile = new File(valueFileName);
        try {
            DeferredFileOutputStream otherStatementsStream = new DeferredFileOutputStream(0x100000, otherStatementsFile);
            DeferredFileOutputStream valueStream = new DeferredFileOutputStream(0x100000, valueFile);
            ObjectOutputStream otherStatementsOutput = new ObjectOutputStream((OutputStream)otherStatementsStream);
            ObjectOutputStream valueOutput = new ObjectOutputStream((OutputStream)valueStream);
            ClusterControl.ClusterState clusterState = cc.getClusterState();
            TIntHashSet excludedShared = new TIntHashSet();
            TreeMap<String, Variant> extensions = new TreeMap<String, Variant>();
            Subgraphs.getDomain2(graph, this.ids, rootResources, preStatus, this.configuration.specials, otherStatementsOutput, valueOutput, extensions, excludedShared);
            this.id = this.ids.size();
            cc.restoreClusterState(clusterState);
            otherStatementsOutput.flush();
            valueOutput.flush();
            otherStatementsStream.close();
            valueStream.close();
            long domainDuration = System.nanoTime() - domainTime;
            System.err.println("Analysed graph in " + 1.0E-9 * (double)domainDuration + "s.");
            this.internalCount = this.id;
            this.ids.put(this.support.getTransientId(graph.getResource("http:/")), this.id++);
            this.externalNames.add("http:/");
            this.externalParents.add(-1);
            InputStream otherStatementsInputStream = null;
            InputStream valueInputStream = null;
            otherStatementsInputStream = otherStatementsStream.isInMemory() ? new ByteArrayInputStream(otherStatementsStream.getData()) : new FileInputStream(otherStatementsFile);
            valueInputStream = valueStream.isInMemory() ? new ByteArrayInputStream(valueStream.getData()) : new FileInputStream(valueFile);
            otherStatementsStream = null;
            valueStream = null;
            ObjectInputStream otherStatementsInput = new ObjectInputStream(otherStatementsInputStream);
            ObjectInputStream valueInput = new ObjectInputStream(valueInputStream);
            long statementTime = System.nanoTime();
            TIntArrayList statementSet = new TIntArrayList();
            while (otherStatementsInput.available() > 0) {
                int s = otherStatementsInput.readInt();
                boolean exclude = !this.ids.contains(s);
                int size = otherStatementsInput.readInt();
                int i = 0;
                while (i < size) {
                    int p = otherStatementsInput.readInt();
                    int o = otherStatementsInput.readInt();
                    if (!exclude && !excludedShared.contains(o)) {
                        statementSet.add(s);
                        statementSet.add(p);
                        statementSet.add(o);
                    }
                    ++i;
                }
            }
            TIntIntHashMap inverses = new TIntIntHashMap();
            TIntHashSet predicateSet = new TIntHashSet();
            int i = 0;
            while (i < statementSet.size()) {
                Resource inverse;
                int p = statementSet.getQuick(i + 1);
                if (predicateSet.add(p) && (inverse = graph.getPossibleInverse(this.getResource(p))) != null) {
                    inverses.put(p, this.support.getTransientId(inverse));
                }
                i += 3;
            }
            predicateSet = null;
            TIntArrayList tgStatements = new TIntArrayList();
            int trim = Math.max(65536, statementSet.size() / 12);
            int i2 = statementSet.size();
            while (i2 > 0) {
                int objectId;
                if (trim-- == 0) {
                    statementSet.remove(i2, statementSet.size() - i2);
                    statementSet.trimToSize();
                    trim = Math.max(65536, statementSet.size() / 12);
                }
                int s = statementSet.getQuick(i2 - 3);
                int p = statementSet.getQuick(i2 - 2);
                int o = statementSet.getQuick(i2 - 1);
                int subjectId = this.ids.get(s);
                if (subjectId >= this.internalCount) {
                    System.err.println("Statement for external: " + s + " " + p + " " + o);
                }
                if ((objectId = this.getId(graph, o, p)) != -2) {
                    tgStatements.add(subjectId);
                    tgStatements.add(this.getId(graph, p, 0));
                    int inverse = inverses.get(p);
                    if (inverse != 0) {
                        tgStatements.add(this.getId(graph, inverse, 0));
                    } else {
                        tgStatements.add(-1);
                    }
                    tgStatements.add(objectId);
                } else {
                    System.out.println("denied");
                }
                i2 -= 3;
            }
            this.statements = tgStatements.toArray();
            long statementDuration = System.nanoTime() - statementTime;
            System.err.println("Built transferable statements in " + 1.0E-9 * (double)statementDuration + "s.");
            inverses = null;
            while (valueInput.available() > 0) {
                int s = valueInput.readInt();
                int valueSize = valueInput.readInt();
                byte[] value = new byte[valueSize];
                valueInput.readFully(value);
                Variant variant = (Variant)Bindings.VARIANT.serializer().deserialize(value);
                this.values.put(s, (Object)variant);
            }
            int resourceCount = this.ids.size();
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (Pair<Resource, String> r : this.configuration.roots) {
                Resource type = graph.getPossibleType((Resource)r.first, this.L0.Entity);
                if (type == null) {
                    type = this.L0.Entity;
                }
                identities.add(new Identity(this.ids.get(this.support.getTransientId((Resource)r.first)), (IdentityDefinition)new Root((String)r.second, graph.getURI(type))));
            }
            int internalsPlusExternals = this.ids.size();
            int i3 = this.internalCount;
            while (i3 < internalsPlusExternals) {
                int parent = this.externalParents.get(i3 - this.internalCount);
                String name = this.externalNames.get(i3 - this.internalCount);
                identities.add(new Identity(i3, (IdentityDefinition)new External(parent, name)));
                ++i3;
            }
            Identity[] identityArray = identities.toArray(new Identity[identities.size()]);
            final Value[] valueArray = new Value[this.values.size()];
            this.values.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Variant>(){
                int index = 0;

                public boolean execute(int subject, Variant bytes) {
                    int r = TransferableGraphRequest2.this.getInternalId(subject);
                    if (r == -1) {
                        System.err.println("No id for value resource " + subject);
                    } else {
                        valueArray[this.index++] = new Value(r, bytes);
                    }
                    return true;
                }
            });
            this.ids = null;
            this.values = null;
            TransferableGraph1 result = new TransferableGraph1(resourceCount, identityArray, this.statements, valueArray, extensions);
            long totalEnd = System.nanoTime();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
            TransferableGraphRequest2.dumpHeap("crash.hprof");
        }
        return null;
    }

    private static void dumpHeap(String path) {
        try {
            Object bean = TransferableGraphRequest2.getBean();
            if (bean == null) {
                return;
            }
            Method m = bean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(bean, path, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object getBean() {
        Class<?> beanClass = TransferableGraphRequest2.getBeanClass();
        if (beanClass == null) {
            return null;
        }
        try {
            Object bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClass);
            return bean;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Class<?> getBeanClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

