/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.TGConfigurer;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.request.ReadInterface;

public class TransferableGraphConfiguration2 {
    public final TreeMap<String, Variant> baseExtensions = new TreeMap();
    public final Resource indexRoot;
    public final Collection<RootSpec> roots;
    public final Map<Resource, SubgraphExtent.ExtentStatus> preStatus;
    public final boolean ignoreVirtualResources;
    public final boolean validate;
    public Collection<TGValueModifier> valueModifiers;

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources, boolean validate) {
        this.indexRoot = indexRoot;
        this.roots = roots;
        this.preStatus = preStatus;
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.validate = validate;
        this.valueModifiers = null;
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources) {
        this(indexRoot, roots, preStatus, ignoreVirtualResources, true);
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus) {
        this(indexRoot, roots, preStatus, true);
    }

    public TransferableGraphConfiguration2(TransferableGraphConfiguration2 conf) throws DatabaseException {
        this(conf.indexRoot, conf.roots, conf.preStatus, conf.ignoreVirtualResources, conf.validate);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(Collections.singletonList(model)).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<Resource> roots, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(roots).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources) throws DatabaseException {
        this(graph, model, ignoreVirtualResources, true);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model) throws DatabaseException {
        this(graph, model, true);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<RootSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions) throws DatabaseException {
        this(new TGConfigurer(graph, true).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<RootSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions, boolean ignoreVirtualResource, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResource, validate).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
    }

    public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, final Collection<NamedResource> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, TransferableGraphConfiguration2.translate(roots), Collections.<Resource>emptyList(), exclusions, ignoreVirtualResource, validate);
            }
        });
    }

    public static TransferableGraphConfiguration2 createWithNames2(RequestProcessor processor, final Collection<RootSpec> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, roots, Collections.<Resource>emptyList(), exclusions, ignoreVirtualResource, validate);
            }
        });
    }

    public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, Collection<NamedResource> roots, Collection<Resource> exclusions) throws DatabaseException {
        return TransferableGraphConfiguration2.createWithNames(processor, roots, exclusions, true, true);
    }

    public static TransferableGraphConfiguration2 createWithResources(RequestProcessor processor, final Collection<Resource> roots, final Collection<Resource> exclusions) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, Collections.<RootSpec>emptyList(), roots, exclusions);
            }
        });
    }

    public static TransferableGraphConfiguration2 createForModel(RequestProcessor processor, Resource model) throws DatabaseException {
        return TransferableGraphConfiguration2.createWithResources(processor, Collections.singletonList(model), Collections.<Resource>emptyList());
    }

    private static Collection<RootSpec> translate(Collection<NamedResource> roots) {
        ArrayList<RootSpec> result = new ArrayList<RootSpec>();
        for (NamedResource nr : roots) {
            result.add(new RootSpec(nr.getResource(), nr.getName(), true));
        }
        return result;
    }

    public static class RootSpec {
        public Resource resource;
        public String name;
        public boolean internal;

        public RootSpec(Resource resource, String name, boolean internal) {
            this.resource = resource;
            this.name = name;
            this.internal = internal;
        }
    }
}

