/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TGTransferableGraphSource
implements TransferableGraphSource {
    private final TransferableGraph1 tg;

    public TGTransferableGraphSource(TransferableGraph1 tg) {
        this.tg = tg;
    }

    public DataContainer getHeader() throws Exception {
        return null;
    }

    public int getResourceCount() {
        return this.tg.resourceCount;
    }

    public int getIdentityCount() {
        return this.tg.identities.length;
    }

    public int getStatementCount() {
        return this.tg.statements.length;
    }

    public int getValueCount() {
        return this.tg.values.length;
    }

    public void forStatements(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
        int[] value = new int[4];
        int i = 0;
        while (i < this.tg.statements.length) {
            value[0] = this.tg.statements[i];
            value[1] = this.tg.statements[i + 1];
            value[2] = this.tg.statements[i + 2];
            value[3] = this.tg.statements[i + 3];
            procedure.execute((Object)value);
            i += 4;
        }
    }

    public void forIdentities(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Identity> procedure) throws Exception {
        int i = 0;
        while (i < this.tg.identities.length) {
            procedure.execute((Object)this.tg.identities[i]);
            ++i;
        }
    }

    public void forValues(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Value> procedure) throws Exception {
        int i = 0;
        while (i < this.tg.values.length) {
            procedure.execute((Object)this.tg.values[i]);
            ++i;
        }
    }

    public void forValues2(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceValueProcedure procedure) throws Exception {
        int i = 0;
        while (i < this.tg.values.length) {
            Value value = this.tg.values[i];
            Binding binding = value.value.getBinding();
            Datatype dt = binding.type();
            Serializer s = Bindings.getSerializer((Binding)binding);
            procedure.execute(value.resource, dt, (InputStream)new ByteArrayInputStream(s.serialize(value.value.getValue(binding))));
            ++i;
        }
    }

    public TreeMap<String, Variant> getExtensions() {
        return this.tg.extensions;
    }

    public void reset() throws Exception {
    }
}

