/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TGRepresentation
implements SimanticsClipboard.Representation {
    private TransferableGraph1 value = null;
    private Resource[] resources;
    private TransferableGraphConfiguration2 configuration;
    private boolean ignoreVirtualResources = false;

    public TGRepresentation(Resource ... resources) {
        this.resources = resources;
    }

    public TGRepresentation(boolean ignoreVirtualResources, Resource ... resources) {
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.resources = resources;
    }

    public TGRepresentation(TransferableGraphConfiguration2 configuration) {
        this.configuration = configuration;
    }

    public TGRepresentation(TransferableGraph1 value) {
        this.value = value;
    }

    @Override
    public IHintContext.Key getKey() {
        return SimanticsKeys.KEY_TRANSFERABLE_GRAPH;
    }

    public TransferableGraph1 compute(ReadGraph graph) throws DatabaseException {
        if (this.configuration == null) {
            ArrayList<Resource> rs = new ArrayList<Resource>();
            Resource[] resourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r = resourceArray[n2];
                rs.add(r);
                ++n2;
            }
            this.configuration = new TransferableGraphConfiguration2(graph, rs, this.ignoreVirtualResources, false);
        }
        ModelTransferableGraphSource source = (ModelTransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(this.configuration));
        return TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)source);
    }

    @Override
    public <T> T getValue(RequestProcessor processor) {
        if (this.value == null) {
            try {
                this.value = (TransferableGraph1)processor.syncRequest((Read)new Read<TransferableGraph1>(){

                    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
                        return TGRepresentation.this.compute(graph);
                    }
                });
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
        return (T)this.value;
    }
}

