/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.QueryControl;
import org.simantics.utils.datastructures.Callback;

public class SessionGarbageCollection {
    private static int DEFAULT_ALLOWED_TIME = 200;
    private static int DEFAULT_CLUSTER_TARGET = -1;

    public static int getDefaultQueryTarget() {
        return DEFAULT_ALLOWED_TIME;
    }

    public static void setDefaultAllowedTime(int a) {
        DEFAULT_ALLOWED_TIME = a;
    }

    public static int getDefaultClusterTarget() {
        return DEFAULT_CLUSTER_TARGET;
    }

    public static void setDefaultClusterTarget(int a) {
        DEFAULT_CLUSTER_TARGET = a;
    }

    public static void gc(IProgressMonitor monitor, Session session, boolean sync, Callback<DatabaseException> errorCallback) {
        SessionGarbageCollection.gc(monitor, session, sync, errorCallback, DEFAULT_ALLOWED_TIME, DEFAULT_CLUSTER_TARGET);
    }

    public static void gc(ReadGraph graph, int allowedTimeInMs, int clusterTarget) throws DatabaseException {
        SessionGarbageCollection.doIt(null, graph, allowedTimeInMs, clusterTarget);
    }

    private static void doIt(IProgressMonitor _monitor, ReadGraph graph, int allowedTimeInMs, int clusterTarget) {
        if (_monitor == null) {
            _monitor = new NullProgressMonitor();
        }
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
        _monitor.beginTask("Collect clusters", -1);
        cc.gc(graph, clusterTarget);
        _monitor.beginTask("Collect queries", -1);
        qc.gc(graph, allowedTimeInMs);
    }

    public static void gc(IProgressMonitor monitor, Session session, boolean sync, final Callback<DatabaseException> errorCallback, final int allowedTimeInMs, final int clusterTarget) {
        block7: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            final IProgressMonitor _monitor = monitor;
            if (session == null) {
                throw new NullPointerException("null session");
            }
            WriteRequest request = new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SessionGarbageCollection.doIt(_monitor, (ReadGraph)graph, allowedTimeInMs, clusterTarget);
                }
            };
            if (sync) {
                try {
                    session.syncRequest((Write)request);
                }
                catch (DatabaseException e) {
                    if (errorCallback != null) {
                        errorCallback.run((Object)e);
                        break block7;
                    }
                    Logger.defaultLogError((Throwable)e);
                }
            } else {
                session.asyncRequest((Write)request, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException e) {
                        if (e != null) {
                            if (errorCallback != null) {
                                errorCallback.run((Object)e);
                            } else {
                                Logger.defaultLogError((Throwable)e);
                            }
                        }
                    }
                });
            }
        }
    }
}

