/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.EString;

public final class RemoverUtil {
    public static void remove(WriteGraph graph, Resource resource) throws DatabaseException {
        if (!RemoverUtil.tryRemover(graph, resource)) {
            EntityRemover.remove(graph, resource, true);
        }
    }

    public static boolean tryRemover(WriteGraph graph, Resource resource) throws DatabaseException {
        Remover remover = RemoverUtil.getPossibleRemover((ReadGraph)graph, resource);
        if (remover != null) {
            remover.remove(graph);
            return true;
        }
        return false;
    }

    public static Remover getPossibleRemover(ReadGraph graph, Resource resource) throws DatabaseException {
        return (Remover)graph.getPossibleAdapter(resource, Remover.class);
    }

    public static String testRemoval(final Collection<Resource> rs) throws DatabaseException {
        return (String)Simantics.getSession().syncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                return RemoverUtil.testRemoval(graph, rs, null);
            }
        });
    }

    public static String testRemoval(ReadGraph graph, Collection<Resource> rs, List<Remover> removers) throws DatabaseException {
        if (removers == null) {
            removers = new ArrayList<Remover>(rs.size());
        }
        for (Resource r : rs) {
            Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
            if (remover == null) continue;
            removers.add(remover);
        }
        HashMap<Object, Object> aux = new HashMap<Object, Object>();
        ArrayList<String> errors = new ArrayList<String>(2);
        for (Remover remover : removers) {
            String error = remover.canRemove(graph, aux);
            if (error == null) continue;
            errors.add(error);
        }
        if (!errors.isEmpty()) {
            return EString.implode(errors);
        }
        return null;
    }

    public static String testRemoval(ReadGraph graph, Collection<Resource> rs) throws DatabaseException {
        return RemoverUtil.testRemoval(graph, rs, null);
    }

    public static String checkedRemoval(final Collection<Resource> rs) throws DatabaseException {
        String problems = RemoverUtil.testRemoval(rs);
        if (problems != null) {
            return problems;
        }
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                for (Resource r : rs) {
                    graph.addMetadata((Metadata)cm.add("Removing " + r + "."));
                }
                ArrayList<Remover> removers = new ArrayList<Remover>(rs.size());
                String error = RemoverUtil.testRemoval((ReadGraph)graph, rs, removers);
                if (error != null) {
                    throw new CannotRemoveException(error);
                }
                for (Remover remover : removers) {
                    remover.remove(graph);
                }
            }
        });
        return null;
    }

    public static boolean tryCollectionRemover(final Collection<Resource> rs) throws DatabaseException {
        return (Boolean)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Boolean>(){

            public Boolean perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Collection principalTypes = null;
                for (Resource r : rs) {
                    Collection pts = graph.getPrincipalTypes(r);
                    if (principalTypes == null) {
                        principalTypes = pts;
                        continue;
                    }
                    if (principalTypes.equals(pts)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Removing resources of different types at the same time is currently not supported.\n\nThe selection contained resources of the following types:\n");
                    HashSet differentTypes = new HashSet();
                    TreeSet<String> typeNames = new TreeSet<String>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
                    for (Resource t : rs) {
                        differentTypes.addAll(graph.getPrincipalTypes(t));
                    }
                    for (Resource t : differentTypes) {
                        typeNames.add(NameUtils.getSafeName((ReadGraph)graph, (Resource)t));
                    }
                    for (String typeName : typeNames) {
                        sb.append("\t").append(typeName).append("\n");
                    }
                    throw new CannotRemoveException(sb.toString());
                }
                ArrayList<Remover> removers = new ArrayList<Remover>();
                HashMap<Remover, String> removedResources = new HashMap<Remover, String>();
                for (Resource r : rs) {
                    Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
                    if (remover == null) continue;
                    removers.add(remover);
                    removedResources.put(remover, NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true));
                }
                HashMap<Object, Object> aux = new HashMap<Object, Object>();
                ArrayList<String> errors = new ArrayList<String>(removers.size());
                for (Remover remover : removers) {
                    String error = remover.canRemove((ReadGraph)graph, aux);
                    if (error == null) continue;
                    errors.add(error);
                }
                if (!errors.isEmpty()) {
                    throw new CannotRemoveException(EString.implode(errors));
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                for (Remover remover : removers) {
                    remover.remove(graph);
                    graph.addMetadata((Metadata)cm.add("Removed " + (String)removedResources.get(remover) + "."));
                }
                return true;
            }
        });
    }
}

