/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.DomainProcessor3;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.DomainStatementProcedure3;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.NullOutputStream;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ModelTransferableGraphSourceRequest
extends UniqueRead<ModelTransferableGraphSource> {
    public static String LOG_FILE = "transferableGraph.log";
    static final boolean LOG = false;
    private static final boolean DEBUG = false;
    static final boolean PROFILE = false;
    private TransferableGraphConfiguration2 configuration;
    static DataOutput log;
    Layer0 L0;
    int[] statements;
    int statementIndex = 0;
    TIntIntHashMap ids;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    int id = 0;
    int indent = 0;
    private SerialisationSupport support;

    static void log(String line) {
    }

    public ModelTransferableGraphSourceRequest(TransferableGraphConfiguration2 conf) {
        this.configuration = conf;
    }

    private Resource getResource(int r) throws DatabaseException {
        return this.support.getResource(r);
    }

    public int getInternalId(int r) {
        return this.ids.get(r);
    }

    public boolean validateExternal(Resource ext) {
        SubgraphExtent.ExtentStatus status = this.configuration.preStatus.get(ext);
        if (status != null) {
            if (SubgraphExtent.ExtentStatus.INTERNAL.equals((Object)status)) {
                return false;
            }
            if (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)status)) {
                return false;
            }
        }
        return true;
    }

    public int getId(ReadGraph graph, int r) throws DatabaseException {
        if (this.ids.containsKey(r)) {
            int ret = this.ids.get(r);
            if (ret == -1) {
                int i = 0;
                while (i <= this.indent) {
                    System.out.print("  ");
                    ++i;
                }
                System.out.println("Cycle!!!");
            }
            return ret;
        }
        if (!this.validateExternal(this.getResource(r))) {
            return -2;
        }
        Collection parents = graph.getObjects(this.getResource(r), this.L0.PartOf);
        if (parents.size() != 1) {
            throw new ValidationException("Reference to external resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(r), (boolean)true) + " without unique uri (" + parents.size() + " parents).");
        }
        for (Resource p : parents) {
            ++this.indent;
            int pid = this.getId(graph, this.support.getTransientId(p));
            if (pid == -2) {
                return -2;
            }
            this.externalParents.add(pid);
            --this.indent;
        }
        this.externalNames.add((String)graph.getRelatedValue(this.getResource(r), this.L0.HasName));
        this.ids.put(r, this.id);
        return this.id++;
    }

    public ModelTransferableGraphSource perform(ReadGraph graph) throws DatabaseException {
        this.support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        long total = System.nanoTime();
        long startupTime = System.nanoTime();
        long startupTimeEnd = System.nanoTime();
        long domainTime = System.nanoTime();
        String otherStatements = "other" + UUID.randomUUID().toString();
        String valueFileName = "value" + UUID.randomUUID().toString();
        File base_ = Simantics.getTemporaryDirectory();
        File base = new File(base_, "exports");
        base.mkdirs();
        File otherStatementsFile = new File(base, otherStatements);
        File valueFile = new File(base, valueFileName);
        try {
            DeferredFileOutputStream otherStatementsStream = new DeferredFileOutputStream(0x100000, otherStatementsFile);
            DeferredFileOutputStream valueStream = new DeferredFileOutputStream(0x100000, valueFile);
            ObjectOutputStream otherStatementsOutput = new ObjectOutputStream((OutputStream)otherStatementsStream);
            ObjectOutputStream valueOutput = new ObjectOutputStream((OutputStream)valueStream);
            ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
            ClusterControl.ClusterState clusterState = cc.getClusterState();
            TIntHashSet excludedShared = new TIntHashSet();
            this.ids = new TIntIntHashMap(1000, 0.75f);
            DomainProcessorState state = new DomainProcessorState();
            state.extensions.putAll(this.configuration.baseExtensions);
            state.ids = this.ids;
            state.statementsOutput = otherStatementsOutput;
            state.valueOutput = valueOutput;
            state.valueCount = 0;
            state.excludedShared = excludedShared;
            ModelTransferableGraphSourceRequest.getDomain2(graph, this.configuration, state, this.configuration.ignoreVirtualResources);
            this.id = this.ids.size();
            cc.restoreClusterState(clusterState);
            otherStatementsOutput.flush();
            valueOutput.flush();
            otherStatementsStream.close();
            valueStream.close();
            long domainDuration = System.nanoTime() - domainTime;
            state.id = this.id;
            InputStream otherStatementsInputStream = null;
            InputStream valueInputStream = null;
            otherStatementsInputStream = otherStatementsStream.isInMemory() ? new ByteArrayInputStream(otherStatementsStream.getData()) : new FileInputStream(otherStatementsFile);
            valueInputStream = valueStream.isInMemory() ? new ByteArrayInputStream(valueStream.getData()) : new FileInputStream(valueFile);
            otherStatementsStream = null;
            valueStream = null;
            state.otherStatementsInput = new ObjectInputStream(otherStatementsInputStream);
            state.valueInput = new ObjectInputStream(valueInputStream);
            long statementTime = System.nanoTime();
            long statementDuration = System.nanoTime() - statementTime;
            long totalEnd = System.nanoTime();
            return new ModelTransferableGraphSource(graph, this.configuration, state, otherStatementsFile, valueFile);
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DatabaseException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            ModelTransferableGraphSourceRequest.dumpHeap("crash.hprof");
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    public static DomainProcessor3 getDomain(ReadGraph graph, Resource resource) throws DatabaseException {
        return ModelTransferableGraphSourceRequest.getDomain(graph, TransferableGraphConfiguration2.createForModel((RequestProcessor)graph, resource));
    }

    public static DomainProcessor3 getDomain(ReadGraph graph, TransferableGraphConfiguration2 conf) throws DatabaseException {
        try {
            DomainProcessorState state = new DomainProcessorState();
            state.extensions.putAll(conf.baseExtensions);
            state.ids = new TIntIntHashMap(1000, 0.75f);
            state.statementsOutput = new ObjectOutputStream(new NullOutputStream());
            state.valueOutput = new ObjectOutputStream(new NullOutputStream());
            state.valueCount = 0;
            state.excludedShared = new TIntHashSet();
            return ModelTransferableGraphSourceRequest.getDomain2(graph, conf, state, conf.ignoreVirtualResources);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static DomainProcessor3 getDomain2(final ReadGraph graph, final TransferableGraphConfiguration2 conf, DomainProcessorState state, boolean ignoreVirtual) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin("getDomain2");
        final DomainProcessor3 processor = new DomainProcessor3(graph, conf, state, ignoreVirtual);
        processor.process(graph, state);
        final SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        final ClusteringSupport cls = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        TLongObjectHashMap clusterMap = new TLongObjectHashMap();
        for (Resource r : processor.status.keySet()) {
            SubgraphExtent.ExtentStatus status = processor.status.get(r);
            int transientId = support.getTransientId(r);
            if (SubgraphExtent.ExtentStatus.INTERNAL == status) {
                long cluster = cls.getCluster(r);
                TIntArrayList list = (TIntArrayList)clusterMap.get(cluster);
                if (list == null) {
                    list = new TIntArrayList();
                    clusterMap.put(cluster, (Object)list);
                }
                list.add(transientId);
                continue;
            }
            if (SubgraphExtent.ExtentStatus.EXTERNAL == status) {
                state.externals.add(transientId);
                continue;
            }
            if (SubgraphExtent.ExtentStatus.PENDING != status) continue;
            String uri = graph.getPossibleURI(r);
            if (uri != null) {
                state.externals.add(transientId);
                continue;
            }
            System.err.println("Pending status in export: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)r) + " (" + graph.getPossibleURI(r) + ")");
        }
        final TIntArrayList clustering = new TIntArrayList();
        clusterMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TIntArrayList>(){

            public boolean execute(long cluster, TIntArrayList b) {
                clustering.add(b.size());
                b.forEach(new TIntProcedure(){

                    public boolean execute(int rId) {
                        processor.ids.put(rId, processor.id++);
                        return true;
                    }
                });
                return true;
            }
        });
        final TIntArrayList clusterSets = new TIntArrayList();
        clusterMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TIntArrayList>(){

            public boolean execute(long cluster, TIntArrayList b) {
                block5: {
                    Resource clusterSet;
                    block7: {
                        block6: {
                            clusterSet = cls.getClusterSetOfCluster(cluster);
                            if (clusterSet == null) break block5;
                            int transientId = support.getTransientId(clusterSet);
                            if (!processor.ids.containsKey(transientId)) break block6;
                            clusterSets.add(processor.ids.get(transientId));
                            return true;
                        }
                        if (!graph.getRootLibrary().equals(clusterSet)) break block7;
                        clusterSets.add(-1);
                        return true;
                    }
                    try {
                        if (clusterSet.equals(conf.indexRoot)) {
                            clusterSets.add(-2);
                            return true;
                        }
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                }
                System.err.println("cluster " + cluster + " set is NO_CLUSTER_SET");
                clusterSets.add(-1);
                return true;
            }
        });
        state.extensions.put("clustering", new Variant((Binding)Bindings.INT_ARRAY, (Object)clustering.toArray()));
        state.extensions.put("clusterSets", new Variant((Binding)Bindings.INT_ARRAY, (Object)clusterSets.toArray()));
        long total = processor.startupTime + processor.expandTime + processor.classifyPredicateTime + processor.processFringeTime + processor.extentSeedTime + processor.fullResolveTime + processor.fastResolveTime + processor.parentResolveTime + processor.otherStatementTime;
        task.finish();
        return processor;
    }

    private static void dumpHeap(String path) {
        try {
            Object bean = ModelTransferableGraphSourceRequest.getBean();
            if (bean == null) {
                return;
            }
            Method m = bean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(bean, path, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object getBean() {
        Class<?> beanClass = ModelTransferableGraphSourceRequest.getBeanClass();
        if (beanClass == null) {
            return null;
        }
        try {
            Object bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClass);
            return bean;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Class<?> getBeanClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            Datatype dt = Datatypes.translate((String)"{ parts : ( | ResourceRVIPart { role : |CHILD|PROPERTY, resource : Long(unit=\"resource\") } | StringRVIPart { role : |CHILD|PROPERTY, string : String } ) [] }");
            Binding b = Bindings.getBinding((Datatype)dt);
            Object value = b.createDefault();
            Variant variant = new Variant(b, value);
            TGResourceUtil util = new TGResourceUtil();
            TGResourceUtil.LongAdapter la = new TGResourceUtil.LongAdapter(){

                public long adapt(long in) {
                    return in;
                }
            };
            util.adaptValue(variant.getBinding(), variant.getValue(), la);
        }
        catch (DataTypeSyntaxError e) {
            e.printStackTrace();
        }
        catch (BindingException e) {
            e.printStackTrace();
        }
        catch (RuntimeSerializerConstructionException e) {
            e.printStackTrace();
        }
        catch (AccessorException e) {
            e.printStackTrace();
        }
    }

    static class Expansion3
    extends UniqueRead<Collection<DirectStatements>> {
        private final Collection<Resource> roots;
        final boolean ignoreVirtual;

        public Expansion3(Collection<Resource> roots, boolean ignoreVirtual) {
            this.roots = roots;
            this.ignoreVirtual = ignoreVirtual;
        }

        public Collection<DirectStatements> perform(ReadGraph graph) {
            ArrayList<DirectStatements> result = new ArrayList<DirectStatements>();
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            DomainStatementProcedure3 proc = new DomainStatementProcedure3(result);
            if (this.ignoreVirtual) {
                for (Resource r : this.roots) {
                    dqs.forEachDirectPersistentStatement((AsyncReadGraph)graph, r, (AsyncProcedure)proc);
                }
            } else {
                for (Resource r : this.roots) {
                    dqs.forEachDirectStatement((AsyncReadGraph)graph, r, (AsyncProcedure)proc);
                }
            }
            return result;
        }
    }
}

