/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntIntProcedure;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ComposedTGValueModifier;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.ResourceTGValueModifier;
import org.simantics.db.layer0.util.RevisionTGValueModifier;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;

public class ModelTransferableGraphSource
implements TransferableGraphSource {
    private final TransferableGraphConfiguration2 configuration;
    private final DomainProcessorState state;
    private final int externalBase;
    private final int resourceCount;
    private final File[] files;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    final TGValueModifier valueModifier;
    int indent = 0;

    public ModelTransferableGraphSource(final ReadGraph graph, TransferableGraphConfiguration2 configuration, DomainProcessorState state, File ... fs) throws DatabaseException {
        this.configuration = configuration;
        this.state = state;
        this.files = fs;
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        ArrayList<TGValueModifier> valueModifiers = configuration.valueModifiers == null ? new ArrayList<TGValueModifier>(2) : new ArrayList<TGValueModifier>(configuration.valueModifiers);
        valueModifiers.add(new ResourceTGValueModifier(ss));
        valueModifiers.add(RevisionTGValueModifier.INSTANCE);
        this.valueModifier = new ComposedTGValueModifier(valueModifiers.toArray(new TGValueModifier[valueModifiers.size()]));
        state.ids.put(ss.getTransientId(graph.getRootLibrary()), state.id++);
        for (TransferableGraphConfiguration2.RootSpec rs : configuration.roots) {
            if (rs.internal) continue;
            int resourceId = ss.getTransientId(rs.resource);
            state.ids.put(resourceId, state.id++);
            state.externals.remove(resourceId);
        }
        this.externalBase = state.id;
        final HashSet<String> errors = new HashSet<String>();
        int[] externals = state.externals.toArray();
        int i = 0;
        while (i < externals.length) {
            this.getId(graph, externals[i], errors);
            ++i;
        }
        state.inverses.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int predicate, int inverse) {
                try {
                    ModelTransferableGraphSource.this.getId(graph, predicate, errors);
                    if (inverse != 0) {
                        ModelTransferableGraphSource.this.getId(graph, inverse, errors);
                    }
                }
                catch (DatabaseException e) {
                    throw new RuntimeDatabaseException((Throwable)e);
                }
                return true;
            }
        });
        if (!errors.isEmpty()) {
            ArrayList<String> sorted = new ArrayList<String>(errors);
            Collections.sort(sorted);
            StringBuilder message = new StringBuilder();
            message.append("Errors in exported model:\n");
            for (String error : sorted) {
                message.append(error);
                message.append("\n");
            }
            throw new DatabaseException(message.toString());
        }
        this.resourceCount = state.id;
    }

    public boolean validateExternal(Resource ext) {
        SubgraphExtent.ExtentStatus status;
        if (this.configuration.validate && (status = this.configuration.preStatus.get(ext)) != null) {
            if (SubgraphExtent.ExtentStatus.INTERNAL.equals((Object)status)) {
                return false;
            }
            if (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)status)) {
                return false;
            }
        }
        return true;
    }

    private Resource getResource(ReadGraph graph, int r) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(r);
    }

    public final int getExistingId(ReadGraph graph, int r) throws DatabaseException {
        int ret = this.state.ids.get(r);
        if (ret != -1) {
            return ret;
        }
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        throw new DatabaseException("Id has not been created for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)ss.getResource(r)));
    }

    public int getId(ReadGraph graph, int r, Collection<String> errors) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (this.state.ids.containsKey(r)) {
            int ret = this.state.ids.get(r);
            if (ret == -1) {
                int i = 0;
                while (i <= this.indent) {
                    System.out.print("  ");
                    ++i;
                }
                System.out.println("Cycle!!!");
            }
            return ret;
        }
        Resource res = this.getResource(graph, r);
        if (!this.validateExternal(res)) {
            errors.add("Illegal reference to " + graph.getPossibleURI(this.getResource(graph, r)));
            return -2;
        }
        Collection parents = graph.getObjects(res, L0.PartOf);
        if (parents.size() != 1) {
            throw new ValidationException("Reference to external resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, r), (boolean)true) + " without unique uri (" + parents.size() + " parents).");
        }
        int pid = 0;
        for (Resource p : parents) {
            ++this.indent;
            pid = this.getId(graph, ss.getTransientId(p), errors);
            if (pid != -2) continue;
            errors.add("Illegal reference to " + graph.getPossibleURI(this.getResource(graph, r)));
            return -2;
        }
        --this.indent;
        String name = (String)graph.getRelatedValue(res, L0.HasName);
        this.externalParents.add(pid);
        this.externalNames.add(name);
        this.state.ids.put(r, this.state.id);
        this.state.externals.add(r);
        return this.state.id++;
    }

    public DataContainer getHeader() throws Exception {
        return null;
    }

    public int getResourceCount() {
        return this.resourceCount;
    }

    public int getIdentityCount() {
        return this.configuration.roots.size() + this.state.externals.size() + 1;
    }

    public int getStatementCount() {
        return this.state.statementCount;
    }

    public int getValueCount() {
        return this.state.valueCount;
    }

    public void forStatements(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
        int[] value = new int[4];
        while (this.state.otherStatementsInput.available() > 0) {
            int s = this.state.otherStatementsInput.readInt();
            int subjectId = this.state.ids.get(s);
            boolean exclude = subjectId == -1;
            int size = this.state.otherStatementsInput.readInt();
            int i = 0;
            while (i < size) {
                int p = this.state.otherStatementsInput.readInt();
                int o = this.state.otherStatementsInput.readInt();
                if (!exclude) {
                    if (this.state.excludedShared.contains(o)) {
                        System.err.println("excluding shared " + s + " " + p + " " + o);
                    } else {
                        int objectId = this.getExistingId(graph, o);
                        if (objectId != -2) {
                            value[0] = subjectId;
                            value[1] = this.getExistingId(graph, p);
                            int inverse = this.state.inverses.get(p);
                            value[2] = inverse != 0 ? this.getExistingId(graph, inverse) : -1;
                            value[3] = objectId;
                            procedure.execute((Object)value);
                        } else {
                            System.err.println("Denied (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, s)) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, p)) + "," + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, o)) + ")");
                        }
                    }
                } else {
                    System.err.println("excluding shared " + s);
                }
                ++i;
            }
        }
    }

    public void forValues(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Value> procedure) throws Exception {
        Serializer variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
        while (this.state.valueInput.available() > 0) {
            int s = this.state.valueInput.readInt();
            Variant variant = (Variant)variantSerializer.deserialize((DataInput)this.state.valueInput);
            if (this.valueModifier.mayNeedModification(variant.type())) {
                Object currentObject = variant.getValue();
                Object newObject = this.valueModifier.modify(this.state, variant.getBinding(), currentObject);
                if (newObject != currentObject) {
                    variant = new Variant(variant.getBinding(), newObject);
                }
            }
            procedure.execute((Object)new Value(this.state.ids.get(s), variant));
        }
    }

    public void forValues2(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceValueProcedure procedure) throws Exception {
        Serializer datatypeSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked(Bindings.getBindingUnchecked(Datatype.class));
        ArrayList idContext = new ArrayList();
        while (this.state.valueInput.available() > 0) {
            int s = this.state.valueInput.readInt();
            idContext.clear();
            Datatype type = (Datatype)datatypeSerializer.deserialize((DataInput)this.state.valueInput, idContext);
            if (this.valueModifier.mayNeedModification(type)) {
                Binding binding = Bindings.getBinding((Datatype)type);
                Serializer serializer = Bindings.getSerializerUnchecked((Binding)binding);
                Object value = serializer.deserialize((DataInput)this.state.valueInput);
                value = this.valueModifier.modify(this.state, binding, value);
                byte[] bytes = serializer.serialize(value);
                procedure.execute(this.state.ids.get(s), type, (InputStream)new ByteArrayInputStream(bytes));
                continue;
            }
            procedure.execute(this.state.ids.get(s), type, (InputStream)this.state.valueInput);
        }
    }

    public void forIdentities(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Identity> procedure) throws Exception {
        SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        procedure.execute((Object)new Identity(this.state.ids.get(support.getTransientId(graph.getRootLibrary())), (IdentityDefinition)new External(-1, "")));
        for (TransferableGraphConfiguration2.RootSpec r : this.configuration.roots) {
            Resource type = graph.getPossibleType(r.resource, L0.Entity);
            if (type == null) {
                type = L0.Entity;
            }
            procedure.execute((Object)new Identity(this.state.ids.get(support.getTransientId(r.resource)), (IdentityDefinition)new Root(r.name, graph.getURI(type))));
        }
        int i = 0;
        while (i < this.state.externals.size()) {
            int parent = this.externalParents.get(i);
            String name = this.externalNames.get(i);
            procedure.execute((Object)new Identity(this.externalBase + i, (IdentityDefinition)new External(parent, name)));
            ++i;
        }
    }

    public TreeMap<String, Variant> getExtensions() {
        return this.state.extensions;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void closeStreams() throws IOException {
        this.state.valueInput.close();
        this.state.statementsOutput.close();
    }

    public void reset() throws Exception {
        throw new UnsupportedOperationException();
    }
}

