/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ConsistsOfProcess;
import org.simantics.db.layer0.util.Subgraphs;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ModelTransferableGraphRequest
extends UniqueRead<TransferableGraph1> {
    public static String LOG_FILE = "transferableGraph.log";
    private static final boolean LOG = false;
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    private TransferableGraphConfiguration2 configuration;
    static DataOutput log;
    Layer0 L0;
    TIntArrayList inverses = new TIntArrayList();
    int[] statements;
    int statementIndex = 0;
    TIntIntHashMap ids;
    TIntObjectMap<Variant> values;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    int id = 0;
    int internalCount;
    int indent = 0;
    private SerialisationSupport support;

    private static void log(String line) {
    }

    public ModelTransferableGraphRequest(TransferableGraphConfiguration2 conf) {
        this.configuration = conf;
    }

    private Resource getResource(int r) throws DatabaseException {
        return this.support.getResource(r);
    }

    public int getInternalId(int r) {
        return this.ids.get(r);
    }

    public boolean validateExternal(Resource ext) {
        SubgraphExtent.ExtentStatus status;
        if (this.configuration.validate && (status = this.configuration.preStatus.get(ext)) != null) {
            if (SubgraphExtent.ExtentStatus.INTERNAL.equals((Object)status)) {
                return false;
            }
            if (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)status)) {
                return false;
            }
        }
        return true;
    }

    public int getId(ReadGraph graph, int r, int predicate) throws DatabaseException {
        if (this.ids.containsKey(r)) {
            int ret = this.ids.get(r);
            if (ret == -1) {
                int i = 0;
                while (i <= this.indent) {
                    System.out.print("  ");
                    ++i;
                }
                System.out.println("Cycle!!!");
            }
            return ret;
        }
        if (!this.validateExternal(this.getResource(r))) {
            return -2;
        }
        Collection parents = graph.getObjects(this.getResource(r), this.L0.PartOf);
        if (parents.size() != 1) {
            throw new ValidationException("Reference to external resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(r), (boolean)true) + " without unique uri (" + parents.size() + " parents).");
        }
        for (Resource p : parents) {
            ++this.indent;
            int pid = this.getId(graph, this.support.getTransientId(p), 0);
            if (pid == -2) {
                return -2;
            }
            this.externalParents.add(pid);
            --this.indent;
        }
        this.externalNames.add((String)graph.getRelatedValue(this.getResource(r), this.L0.HasName));
        this.ids.put(r, this.id);
        return this.id++;
    }

    public void addId(ReadGraph graph, int r, int predicate) throws DatabaseException {
        this.statements[this.statementIndex++] = this.getId(graph, r, predicate);
    }

    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
        this.support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Serializer variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        long total = System.nanoTime();
        long startupTime = System.nanoTime();
        ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
        this.ids = new TIntIntHashMap();
        this.values = new TIntObjectHashMap();
        ArrayList<Resource> rootResources = new ArrayList<Resource>();
        for (TransferableGraphConfiguration2.RootSpec p : this.configuration.roots) {
            rootResources.add(p.resource);
        }
        long startupTimeEnd = System.nanoTime();
        long domainTime = System.nanoTime();
        String otherStatements = "other" + UUID.randomUUID().toString();
        String valueFileName = "value" + UUID.randomUUID().toString();
        File base = new File("temp");
        base.mkdirs();
        File otherStatementsFile = new File(base, otherStatements);
        File valueFile = new File(base, valueFileName);
        try {
            DeferredFileOutputStream otherStatementsStream = new DeferredFileOutputStream(0x100000, otherStatementsFile);
            DeferredFileOutputStream valueStream = new DeferredFileOutputStream(0x100000, valueFile);
            ObjectOutputStream otherStatementsOutput = new ObjectOutputStream((OutputStream)otherStatementsStream);
            ObjectOutputStream valueOutput = new ObjectOutputStream((OutputStream)valueStream);
            ClusterControl.ClusterState clusterState = cc.getClusterState();
            TIntHashSet excludedShared = new TIntHashSet();
            TreeMap<String, Variant> extensions = new TreeMap<String, Variant>();
            ModelTransferableGraphRequest.getDomain2(graph, this.ids, rootResources, this.configuration.preStatus, otherStatementsOutput, valueOutput, extensions, excludedShared, this.configuration.ignoreVirtualResources);
            this.id = this.ids.size();
            cc.restoreClusterState(clusterState);
            otherStatementsOutput.flush();
            valueOutput.flush();
            otherStatementsStream.close();
            valueStream.close();
            long domainDuration = System.nanoTime() - domainTime;
            this.internalCount = this.id;
            this.ids.put(this.support.getTransientId(graph.getResource("http:/")), this.id++);
            this.externalNames.add("http:/");
            this.externalParents.add(-1);
            InputStream otherStatementsInputStream = null;
            InputStream valueInputStream = null;
            otherStatementsInputStream = otherStatementsStream.isInMemory() ? new ByteArrayInputStream(otherStatementsStream.getData()) : new FileInputStream(otherStatementsFile);
            valueInputStream = valueStream.isInMemory() ? new ByteArrayInputStream(valueStream.getData()) : new FileInputStream(valueFile);
            otherStatementsStream = null;
            valueStream = null;
            ObjectInputStream otherStatementsInput = new ObjectInputStream(otherStatementsInputStream);
            ObjectInputStream valueInput = new ObjectInputStream(valueInputStream);
            long statementTime = System.nanoTime();
            TIntArrayList statementSet = new TIntArrayList();
            while (otherStatementsInput.available() > 0) {
                int s = otherStatementsInput.readInt();
                boolean exclude = !this.ids.contains(s);
                int size = otherStatementsInput.readInt();
                int i = 0;
                while (i < size) {
                    int p = otherStatementsInput.readInt();
                    int o = otherStatementsInput.readInt();
                    if (!exclude && !excludedShared.contains(o)) {
                        statementSet.add(s);
                        statementSet.add(p);
                        statementSet.add(o);
                    }
                    ++i;
                }
            }
            TIntIntHashMap inverses = new TIntIntHashMap();
            TIntHashSet predicateSet = new TIntHashSet();
            int i = 0;
            while (i < statementSet.size()) {
                Resource inverse;
                int p = statementSet.getQuick(i + 1);
                if (predicateSet.add(p) && (inverse = graph.getPossibleInverse(this.getResource(p))) != null) {
                    inverses.put(p, this.support.getTransientId(inverse));
                }
                i += 3;
            }
            predicateSet = null;
            TIntArrayList tgStatements = new TIntArrayList();
            int trim = Math.max(65536, statementSet.size() / 12);
            int i2 = statementSet.size();
            while (i2 > 0) {
                int objectId;
                if (trim-- == 0) {
                    statementSet.remove(i2, statementSet.size() - i2);
                    statementSet.trimToSize();
                    trim = Math.max(65536, statementSet.size() / 12);
                }
                int s = statementSet.getQuick(i2 - 3);
                int p = statementSet.getQuick(i2 - 2);
                int o = statementSet.getQuick(i2 - 1);
                int subjectId = this.ids.get(s);
                if (subjectId >= this.internalCount) {
                    System.err.println("Statement for external: " + s + " " + p + " " + o);
                }
                if ((objectId = this.getId(graph, o, p)) != -2) {
                    tgStatements.add(subjectId);
                    tgStatements.add(this.getId(graph, p, 0));
                    int inverse = inverses.get(p);
                    if (inverse != 0) {
                        tgStatements.add(this.getId(graph, inverse, 0));
                    } else {
                        tgStatements.add(-1);
                    }
                    tgStatements.add(objectId);
                }
                i2 -= 3;
            }
            this.statements = tgStatements.toArray();
            long statementDuration = System.nanoTime() - statementTime;
            inverses = null;
            while (valueInput.available() > 0) {
                int s = valueInput.readInt();
                int valueSize = valueInput.readInt();
                byte[] value = new byte[valueSize];
                valueInput.readFully(value);
                Variant variant = (Variant)variantSerializer.deserialize(value);
                this.values.put(s, (Object)variant);
            }
            final TGResourceUtil util = new TGResourceUtil();
            final SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
            this.values.forEachValue((TObjectProcedure)new TObjectProcedure<Variant>(){

                public boolean execute(Variant variant) {
                    try {
                        util.adaptValue(variant.getBinding(), variant.getValue(), new TGResourceUtil.LongAdapter(){

                            public long adapt(long in) {
                                try {
                                    int shortId = ss.getTransientId(in);
                                    return (this).ModelTransferableGraphRequest.this.ids.get(shortId);
                                }
                                catch (DatabaseException e) {
                                    e.printStackTrace();
                                    return in;
                                }
                            }
                        });
                    }
                    catch (AccessorException e) {
                        e.printStackTrace();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return true;
                }
            });
            int resourceCount = this.ids.size();
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (TransferableGraphConfiguration2.RootSpec r : this.configuration.roots) {
                Resource type = graph.getPossibleType(r.resource, this.L0.Entity);
                if (type == null) {
                    type = this.L0.Entity;
                }
                identities.add(new Identity(this.ids.get(this.support.getTransientId(r.resource)), (IdentityDefinition)new Root(r.name, graph.getURI(type))));
            }
            int internalsPlusExternals = this.ids.size();
            int i3 = this.internalCount;
            while (i3 < internalsPlusExternals) {
                int parent = this.externalParents.get(i3 - this.internalCount);
                String name = this.externalNames.get(i3 - this.internalCount);
                identities.add(new Identity(i3, (IdentityDefinition)(parent == -1 ? new Root("", "") : new External(parent, name))));
                ++i3;
            }
            Identity[] identityArray = identities.toArray(new Identity[identities.size()]);
            final Value[] valueArray = new Value[this.values.size()];
            this.values.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Variant>(){
                int index = 0;

                public boolean execute(int subject, Variant bytes) {
                    int r = ModelTransferableGraphRequest.this.getInternalId(subject);
                    if (r == -1) {
                        System.err.println("No id for value resource " + subject);
                    } else {
                        valueArray[this.index++] = new Value(r, bytes);
                    }
                    return true;
                }
            });
            this.ids = null;
            this.values = null;
            TransferableGraph1 result = new TransferableGraph1(resourceCount, identityArray, this.statements, valueArray, extensions);
            long totalEnd = System.nanoTime();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
            ModelTransferableGraphRequest.dumpHeap("crash.hprof");
        }
        return null;
    }

    public static void getDomain2(ReadGraph graph, TIntIntHashMap ids, Collection<Resource> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput, TreeMap<String, Variant> extensions, TIntHashSet excludedShared, boolean ignoreVirtual) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin("getDomain2");
        final DomainProcessor3 processor = new DomainProcessor3(graph, ids, roots, preStatus, ignoreVirtual);
        processor.process(graph, otherStatementsOutput, valueOutput);
        SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        ClusteringSupport cls = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        TLongObjectHashMap clusterMap = new TLongObjectHashMap();
        for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : processor.status.entrySet()) {
            if (SubgraphExtent.ExtentStatus.INTERNAL != entry.getValue()) continue;
            long cluster = cls.getCluster(entry.getKey());
            TIntArrayList list = (TIntArrayList)clusterMap.get(cluster);
            if (list == null) {
                list = new TIntArrayList();
                clusterMap.put(cluster, (Object)list);
            }
            list.add(support.getTransientId(entry.getKey()));
        }
        final TIntArrayList clustering = new TIntArrayList();
        clusterMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TIntArrayList>(){

            public boolean execute(long cluster, TIntArrayList b) {
                clustering.add(b.size());
                b.forEach(new TIntProcedure(){

                    public boolean execute(int rId) {
                        processor.ids.put(rId, processor.id++);
                        return true;
                    }
                });
                return true;
            }
        });
        extensions.put("clustering", new Variant((Binding)Bindings.INT_ARRAY, (Object)clustering.toArray()));
        long total = processor.startupTime + processor.expandTime + processor.composedPredicateTime + processor.composedObjectTime + processor.extentSeedTime + processor.fullResolveTime + processor.fastResolveTime + processor.parentResolveTime + processor.otherStatementTime;
        task.finish();
    }

    private static void dumpHeap(String path) {
        try {
            Object bean = ModelTransferableGraphRequest.getBean();
            if (bean == null) {
                return;
            }
            Method m = bean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(bean, path, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object getBean() {
        Class<?> beanClass = ModelTransferableGraphRequest.getBeanClass();
        if (beanClass == null) {
            return null;
        }
        try {
            Object bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClass);
            return bean;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Class<?> getBeanClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            Datatype dt = Datatypes.translate((String)"{ parts : ( | ResourceRVIPart { role : |CHILD|PROPERTY, resource : Long(unit=\"resource\") } | StringRVIPart { role : |CHILD|PROPERTY, string : String } ) [] }");
            Binding b = Bindings.getBinding((Datatype)dt);
            Object value = b.createDefault();
            Variant variant = new Variant(b, value);
            TGResourceUtil util = new TGResourceUtil();
            TGResourceUtil.LongAdapter la = new TGResourceUtil.LongAdapter(){

                public long adapt(long in) {
                    return in;
                }
            };
            util.adaptValue(variant.getBinding(), variant.getValue(), la);
        }
        catch (DataTypeSyntaxError e) {
            e.printStackTrace();
        }
        catch (BindingException e) {
            e.printStackTrace();
        }
        catch (RuntimeSerializerConstructionException e) {
            e.printStackTrace();
        }
        catch (AccessorException e) {
            e.printStackTrace();
        }
    }

    static class DomainProcessor3 {
        Serializer variantSerializer;
        boolean ignoreVirtual;
        int id = 0;
        Set<Resource> fringe = null;
        Set<Resource> internalDomain = new HashSet<Resource>();
        Set<Resource> exclusions = null;
        Set<Resource> predicates = null;
        Set<Resource> isRelatedToPredicates = null;
        TIntIntHashMap ids = null;
        Map<Resource, SubgraphExtent.ExtentStatus> status = null;
        private long composedObjectCounter = 0L;
        private long fastInternalCounter = 0L;
        private long parentExternalCounter = 0L;
        private long fullInternalCounter = 0L;
        private long fullExternalCounter = 0L;
        private long startupTime = 0L;
        private long expandTime = 0L;
        private long fullResolveTime = 0L;
        private long fastResolveTime = 0L;
        private long otherStatementTime = 0L;
        private long parentResolveTime = 0L;
        private long extentSeedTime = 0L;
        private long composedPredicateTime = 0L;
        private long composedObjectTime = 0L;
        private Set<Resource> strongInverseSet = new HashSet<Resource>();

        public DomainProcessor3(ReadGraph graph, TIntIntHashMap _ids, Collection<Resource> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtual) {
            this.ignoreVirtual = ignoreVirtual;
            this.startupTime = System.nanoTime();
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            this.ids = _ids;
            this.status = (Map)cs.createMap(SubgraphExtent.ExtentStatus.class);
            this.predicates = cs.createSet();
            this.exclusions = cs.createSet();
            this.isRelatedToPredicates = cs.createSet();
            for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : preStatus.entrySet()) {
                this.status.put(entry.getKey(), entry.getValue());
                if (!SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)entry.getValue())) continue;
                this.exclusions.add(entry.getKey());
            }
            this.startupTime = System.nanoTime() - this.startupTime;
            this.fringe = cs.createSet();
            this.fringe.addAll(roots);
            this.internalDomain.addAll(roots);
        }

        public void expand(ReadGraph graph, Set<Resource> fringe, Collection<DirectStatements>[] expansion) throws DatabaseException {
            long start = System.nanoTime();
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            int i = 0;
            while (i < control.getAmountOfQueryThreads()) {
                expansion[i] = new ArrayList<DirectStatements>();
                ++i;
            }
            graph.syncRequest((AsyncRead)new Subgraphs.Expansion2(fringe, expansion, this.ignoreVirtual));
            fringe.clear();
            this.expandTime += System.nanoTime() - start;
        }

        public void classifyPredicates(ReadGraph graph, final Set<Resource> schedule) throws DatabaseException {
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            final Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            long start = System.nanoTime();
            final ConcurrentLinkedQueue composedResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue singleResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue singles = new ConcurrentLinkedQueue();
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : schedule) {
                        graph.forPossibleSuperrelation(predicate, (AsyncProcedure)new AsyncProcedure<Resource>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Resource single) {
                                singles.add(Pair.make((Object)predicate, (Object)single));
                            }
                        });
                    }
                }
            });
            final Set singleSchedule = cs.createSet();
            for (Pair pair : singles) {
                Resource single = (Resource)pair.second;
                if (single == null || !this.predicates.add(single)) continue;
                singleSchedule.add(single);
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : singleSchedule) {
                        graph.forIsSubrelationOf(predicate, L0.IsRelatedTo, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean strong) {
                                if (strong.booleanValue()) {
                                    singleResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            this.isRelatedToPredicates.addAll(singleResult);
            final Set specialSchedule = cs.createSet();
            for (Pair pair : singles) {
                Resource single = (Resource)pair.second;
                if (single != null) {
                    if (!this.isRelatedToPredicates.contains(single)) continue;
                    this.isRelatedToPredicates.add((Resource)pair.first);
                    continue;
                }
                specialSchedule.add((Resource)pair.first);
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : specialSchedule) {
                        graph.forIsSubrelationOf(predicate, L0.IsRelatedTo, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean composed) {
                                if (composed.booleanValue()) {
                                    composedResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            this.isRelatedToPredicates.addAll(composedResult);
            this.composedPredicateTime += System.nanoTime() - start;
        }

        public void classifyPredicates(ReadGraph graph, Collection<DirectStatements>[] expansion) throws DatabaseException {
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Set schedule = cs.createSet();
            Map newPredicates = (Map)cs.createMap(Resource.class);
            Collection<DirectStatements>[] collectionArray = expansion;
            int n = expansion.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<DirectStatements> coll = collectionArray[n2];
                for (DirectStatements stms : coll) {
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        if (!this.predicates.add(predicate)) continue;
                        Resource inverse = graph.getPossibleInverse(predicate);
                        schedule.add(predicate);
                        if (inverse == null) continue;
                        newPredicates.put(predicate, inverse);
                        if (!this.predicates.add(inverse)) continue;
                        schedule.add(inverse);
                    }
                }
                ++n2;
            }
            this.classifyPredicates(graph, schedule);
            for (Map.Entry entry : newPredicates.entrySet()) {
                if (this.isRelatedToPredicates.contains(entry.getValue())) {
                    this.strongInverseSet.add((Resource)entry.getKey());
                }
                if (!this.isRelatedToPredicates.contains(entry.getKey())) continue;
                this.strongInverseSet.add((Resource)entry.getValue());
            }
        }

        public void processFringe(ReadGraph graph, Collection<DirectStatements>[] expansion, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException, IOException {
            SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            long start = System.nanoTime();
            Collection<DirectStatements>[] collectionArray = expansion;
            int n = expansion.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<DirectStatements> coll = collectionArray[n2];
                for (DirectStatements stms : coll) {
                    Resource subject = stms.getSubject();
                    boolean partOf = false;
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        if (!L0.PartOf.equals(predicate)) continue;
                        partOf = true;
                        break;
                    }
                    SubgraphExtent.ExtentStatus subjectStatus = this.status.get(subject);
                    if (subjectStatus == SubgraphExtent.ExtentStatus.EXTERNAL || subjectStatus == SubgraphExtent.ExtentStatus.EXCLUDED) continue;
                    if (partOf && subjectStatus == null && graph.getPossibleURI(subject) != null) {
                        this.status.put(subject, SubgraphExtent.ExtentStatus.EXTERNAL);
                        continue;
                    }
                    this.status.put(subject, SubgraphExtent.ExtentStatus.INTERNAL);
                    int sId = support.getTransientId(subject);
                    if (graph.hasValue(subject)) {
                        Datatype dt = (Datatype)graph.getRelatedValue(subject, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                        Binding b = Bindings.getBinding((Datatype)dt);
                        Object _value = graph.getValue(subject, b);
                        Variant variant = new Variant(b, _value);
                        byte[] value = this.variantSerializer.serialize((Object)variant);
                        valueOutput.writeInt(sId);
                        valueOutput.writeInt(value.length);
                        assert (value.length > 0);
                        valueOutput.write(value);
                    }
                    TIntArrayList stream = new TIntArrayList();
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        Resource object = stm.getObject();
                        SubgraphExtent.ExtentStatus objectStatus = this.status.get(object);
                        if (this.isRelatedToPredicates.contains(predicate) && objectStatus != SubgraphExtent.ExtentStatus.EXCLUDED) {
                            this.logStatementWithExtent(graph, "related", objectStatus, subject, predicate, object);
                            stream.add(support.getTransientId(predicate));
                            stream.add(support.getTransientId(object));
                            if (objectStatus != null) continue;
                            this.fringe.add(object);
                            continue;
                        }
                        if (objectStatus == SubgraphExtent.ExtentStatus.EXCLUDED) {
                            this.logStatementWithExtent(graph, "weak reference to excluded object ", objectStatus, subject, predicate, object);
                            continue;
                        }
                        if (!this.strongInverseSet.contains(predicate)) {
                            stream.add(support.getTransientId(predicate));
                            stream.add(support.getTransientId(object));
                            this.logStatementWithExtent(graph, "fully weak internal", objectStatus, subject, predicate, object);
                            continue;
                        }
                        this.logStatementWithExtent(graph, "strong inverse internal ", objectStatus, subject, predicate, object);
                    }
                    if (stream.isEmpty()) continue;
                    otherStatementsOutput.writeInt(sId);
                    otherStatementsOutput.writeInt(stream.size() / 2);
                    int i = 0;
                    while (i < stream.size()) {
                        otherStatementsOutput.writeInt(stream.getQuick(i));
                        ++i;
                    }
                }
                ++n2;
            }
            this.composedObjectTime += System.nanoTime() - start;
        }

        public void process(ReadGraph graph, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException {
            try {
                this.variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
                QueryControl control = (QueryControl)graph.getService(QueryControl.class);
                for (Resource r : ConsistsOfProcess.walk(graph, this.fringe, this.exclusions, this.ignoreVirtual)) {
                    if (this.status.put(r, SubgraphExtent.ExtentStatus.INTERNAL) != null) continue;
                    String URI2 = graph.getPossibleURI(r);
                    if (URI2 != null) {
                        ModelTransferableGraphRequest.log("URI INTERNAL " + URI2);
                    } else {
                        ModelTransferableGraphRequest.log("URI has no URI for " + r);
                    }
                    this.fringe.add(r);
                    this.internalDomain.add(r);
                }
                while (!this.fringe.isEmpty()) {
                    ArrayList[] expansion = new ArrayList[control.getAmountOfQueryThreads()];
                    this.expand(graph, this.fringe, expansion);
                    this.classifyPredicates(graph, expansion);
                    this.processFringe(graph, expansion, otherStatementsOutput, valueOutput);
                }
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        void logStatementWithExtent(ReadGraph graph, String header, SubgraphExtent.ExtentStatus status, int sId, int pId, int oId) throws DatabaseException {
        }

        void logStatementWithExtent(ReadGraph graph, String header, SubgraphExtent.ExtentStatus status, Resource sId, Resource pId, Resource oId) throws DatabaseException {
        }
    }
}

