/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Metadata;
import org.simantics.db.Operation;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.PossibleChild;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.migration.OntologiesFromLibrary;
import org.simantics.db.layer0.property.OrderedResource;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RelationContextImpl;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.DebugSupport;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;

public class Layer0Utils {
    public static final ThreadLocal SCL_GRAPH = new ThreadLocal();
    public static final Binding datatype_binging = Bindings.getBindingUnchecked(Datatype.class);
    public static final Function1<Resource, Resource> resourceCluster = new FunctionImpl1<Resource, Resource>(){

        public Resource apply(Resource p0) {
            return p0;
        }
    };

    public static Resource literal(WriteGraph g, String value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claimValue(r, (Object)value, (Binding)Bindings.STRING);
        g.claim(r, L0.InstanceOf, L0.String);
        return r;
    }

    public static Resource literal(WriteGraph g, double value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claimValue(r, (Object)value, (Binding)Bindings.DOUBLE);
        g.claim(r, L0.InstanceOf, L0.Double);
        return r;
    }

    public static Resource literal(WriteGraph g, int value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claimValue(r, (Object)value, (Binding)Bindings.INTEGER);
        g.claim(r, L0.InstanceOf, L0.Integer);
        return r;
    }

    public static void assert_(WriteGraph g, Resource type, Resource predicate, Resource object) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource assertion = g.newResource();
        g.claim(type, L0.Asserts, assertion);
        g.claim(assertion, L0.InstanceOf, L0.Assertion);
        g.claim(assertion, L0.HasPredicate, predicate);
        g.claim(assertion, L0.HasObject, object);
    }

    public static Resource relation(WriteGraph g, Resource parent, String name, Resource superrelation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource relation = g.newResource();
        g.claim(relation, L0.SubrelationOf, superrelation);
        g.claim(relation, L0.HasName, Layer0Utils.literal(g, name));
        g.claim(parent, L0.ConsistsOf, relation);
        Resource superrelationInverse = g.getInverse(superrelation);
        if (superrelationInverse != null) {
            Resource inverse = g.newResource();
            g.claim(inverse, L0.SubrelationOf, superrelationInverse);
            g.claim(relation, L0.ConsistsOf, inverse);
            g.claim(inverse, L0.HasName, Layer0Utils.literal(g, "Inverse"));
        }
        return relation;
    }

    private static Resource getLiteralType(ReadGraph graph, Datatype type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (type instanceof DoubleType) {
            return L0.Double;
        }
        if (type instanceof StringType) {
            return L0.String;
        }
        if (type instanceof IntegerType) {
            return L0.Integer;
        }
        if (type instanceof FloatType) {
            return L0.Float;
        }
        if (type instanceof ByteType) {
            return L0.Byte;
        }
        if (type instanceof BooleanType) {
            return L0.Boolean;
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            if (at.componentType instanceof DoubleType) {
                return L0.DoubleArray;
            }
            if (at.componentType instanceof StringType) {
                return L0.StringArray;
            }
            if (at.componentType instanceof IntegerType) {
                return L0.IntegerArray;
            }
            if (at.componentType instanceof FloatType) {
                return L0.FloatArray;
            }
            if (at.componentType instanceof ByteType) {
                return L0.ByteArray;
            }
            if (at.componentType instanceof BooleanType) {
                return L0.BooleanArray;
            }
        }
        throw new DatabaseException("Unidentified literal type for datatype " + type);
    }

    private static Resource getLiteralType(ReadGraph graph, String type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if ("Double".equals(type)) {
            return L0.Double;
        }
        if ("String".equals(type)) {
            return L0.String;
        }
        if ("Integer".equals(type)) {
            return L0.Integer;
        }
        if ("Float".equals(type)) {
            return L0.Float;
        }
        if ("Byte".equals(type)) {
            return L0.Byte;
        }
        if ("Boolean".equals(type)) {
            return L0.Boolean;
        }
        if ("[Double]".equals(type)) {
            return L0.DoubleArray;
        }
        if ("[String]".equals(type)) {
            return L0.StringArray;
        }
        if ("[Integer]".equals(type)) {
            return L0.IntegerArray;
        }
        if ("[Float]".equals(type)) {
            return L0.FloatArray;
        }
        if ("[Byte]".equals(type)) {
            return L0.ByteArray;
        }
        if ("[Boolean]".equals(type)) {
            return L0.BooleanArray;
        }
        if ("Array Double".equals(type)) {
            return L0.DoubleArray;
        }
        if ("Array String".equals(type)) {
            return L0.StringArray;
        }
        if ("Array Integer".equals(type)) {
            return L0.IntegerArray;
        }
        if ("Array Float".equals(type)) {
            return L0.FloatArray;
        }
        if ("Array Byte".equals(type)) {
            return L0.ByteArray;
        }
        if ("Array Boolean".equals(type)) {
            return L0.BooleanArray;
        }
        throw new DatabaseException("Unidentified literal type for datatype " + type);
    }

    public static Resource getLiteralType(ReadGraph graph, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, L0.HasRange);
        if (range != null && !L0.Value.equals(range)) {
            return range;
        }
        Datatype requiredDataType = (Datatype)graph.getPossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging);
        if (requiredDataType != null) {
            return Layer0Utils.getLiteralType(graph, requiredDataType);
        }
        String requiredValueType = (String)graph.getPossibleRelatedValue(property, L0.RequiresValueType, (Binding)Bindings.STRING);
        if (requiredValueType == null) {
            return null;
        }
        return Layer0Utils.getLiteralType(graph, requiredValueType);
    }

    public static String getSCLType(ReadGraph graph, Variable variable) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource literal = variable.getRepresents(graph);
        Datatype literalDatatype = (Datatype)graph.getPossibleRelatedValue2(literal, L0.HasDataType, (Object)new StandardGraphPropertyVariable(variable, literal, L0.HasDataType), datatype_binging);
        if (literalDatatype != null) {
            return literalDatatype.toSingleLineString();
        }
        String literalValueType = (String)graph.getPossibleRelatedValue2(literal, L0.HasValueType, (Object)new StandardGraphPropertyVariable(variable, literal, L0.HasValueType), (Binding)Bindings.STRING);
        if (literalValueType != null) {
            return literalValueType;
        }
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null) {
            Datatype requiredDataType = (Datatype)graph.getPossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging);
            if (requiredDataType != null) {
                return requiredDataType.toSingleLineString();
            }
            String requiredValueType = (String)graph.getPossibleRelatedValue(property, L0.RequiresValueType, (Binding)Bindings.STRING);
            if (requiredValueType != null) {
                return requiredValueType;
            }
        }
        throw new DatabaseException("Unidentified literal data type for property " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)property));
    }

    public static Datatype getDatatype(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype literalDatatype;
        Datatype requiredDataType;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null && (requiredDataType = (Datatype)graph.syncRequest((AsyncRead)new PossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging))) != null) {
            return requiredDataType;
        }
        Resource literal = variable.getPossibleRepresents(graph);
        if (literal != null && (literalDatatype = (Datatype)graph.getPossibleRelatedValue2(literal, L0.HasDataType, (Object)new StandardGraphPropertyVariable(variable, literal, L0.HasDataType), datatype_binging)) != null) {
            return literalDatatype;
        }
        if (property != null) {
            Datatype datatype;
            String requiredValueType = (String)graph.getPossibleRelatedValue(property, L0.RequiresValueType, (Binding)Bindings.STRING);
            if (requiredValueType != null && (datatype = Layer0Utils.getPossibleDatatypeForValueType(requiredValueType)) != null) {
                return datatype;
            }
            Resource subject = variable.getParent(graph).getPossibleRepresents(graph);
            if (subject != null) {
                Resource ass;
                Datatype dt;
                HashSet asses = new HashSet();
                for (Resource type : graph.getTypes(subject)) {
                    asses.addAll(graph.getAssertedObjects(type, property));
                }
                if (asses.size() == 1 && (dt = (Datatype)graph.getPossibleRelatedValue(ass = (Resource)asses.iterator().next(), L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class))) != null) {
                    return dt;
                }
            }
        }
        throw new DatabaseException("Unidentified literal data type for property " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)property));
    }

    private static Datatype getPossibleDatatypeForValueType(String requiredValueType) throws DatabaseException {
        Datatype arrayDataType;
        String[] split = requiredValueType.split(" ");
        String arrayType = null;
        if (split.length == 2 && "Array".equals(split[0])) {
            arrayType = split[1];
        } else if (requiredValueType.startsWith("[") && requiredValueType.endsWith("]")) {
            arrayType = requiredValueType.substring(1, requiredValueType.length() - 1);
        }
        if (arrayType != null && (arrayDataType = Layer0Utils.getArrayDataTypeForType(arrayType)) != null) {
            return arrayDataType;
        }
        Datatype dt = Datatypes.getDatatype((String)requiredValueType);
        if (dt != null) {
            return dt;
        }
        try {
            return Datatypes.translate((String)requiredValueType);
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private static Datatype getArrayDataTypeForType(String type) {
        if ("Double".equals(type)) {
            return Datatypes.DOUBLE_ARRAY;
        }
        if ("String".equals(type)) {
            return Datatypes.STRING_ARRAY;
        }
        if ("Integer".equals(type)) {
            return Datatypes.INTEGER_ARRAY;
        }
        if ("Float".equals(type)) {
            return Datatypes.FLOAT_ARRAY;
        }
        if ("Byte".equals(type)) {
            return Datatypes.BYTE_ARRAY;
        }
        if ("Boolean".equals(type)) {
            return Datatypes.BOOLEAN_ARRAY;
        }
        return null;
    }

    public static Binding getDefaultBinding(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype type;
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null) {
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(property), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (info.defaultBinding != null) {
                return info.defaultBinding;
            }
        }
        if ((type = Layer0Utils.getDatatype(graph, variable)) == null) {
            throw new DatabaseException("No datatype available for variable " + variable.getURI(graph));
        }
        return Bindings.getBinding((Datatype)type);
    }

    public static String getPossibleUnit(Datatype dt) {
        ArrayType at;
        Datatype cdt;
        if (dt == null) {
            return null;
        }
        if (dt instanceof NumberType) {
            return ((NumberType)dt).getUnit();
        }
        if (dt instanceof ArrayType && (cdt = (at = (ArrayType)dt).componentType()) instanceof NumberType) {
            return ((NumberType)cdt).getUnit();
        }
        return null;
    }

    public static String getUnit(ReadGraph graph, Variable variable) throws DatabaseException {
        String unit;
        Datatype requiredDataType;
        String unit2;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource literal = variable.getPossibleRepresents(graph);
        if (literal == null) {
            return "";
        }
        Datatype literalDatatype = (Datatype)graph.getPossibleRelatedValue2(literal, L0.HasDataType, (Object)new StandardGraphPropertyVariable(variable, literal, L0.HasDataType), datatype_binging);
        if (literalDatatype != null && (unit2 = Layer0Utils.getPossibleUnit(literalDatatype)) != null) {
            return unit2;
        }
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null && (requiredDataType = (Datatype)graph.getPossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging)) != null && (unit = Layer0Utils.getPossibleUnit(requiredDataType)) != null) {
            return unit;
        }
        return "";
    }

    public static void claimAdaptedValue(WriteGraph graph, Resource objectResource, Object value, Binding binding, Datatype datatype) throws DatabaseException {
        try {
            Datatype source = binding.type();
            if (source.equals((Object)datatype)) {
                graph.claimValue(objectResource, value, binding);
            } else {
                Binding target = Bindings.getBinding((Datatype)datatype);
                Adapter adapter = Bindings.getAdapter((Binding)binding, (Binding)target);
                graph.claimValue(objectResource, adapter.adapt(value), target);
            }
        }
        catch (AdapterConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static String toString(Object value, Binding binding) throws DatabaseException {
        try {
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder sb = new StringBuilder();
            DataValueRepository rep = new DataValueRepository();
            binding.printValue(value, (Appendable)sb, rep, false);
            return sb.toString();
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Object parseValue(String text, Binding binding) throws DatabaseException {
        try {
            if (binding.isInstance((Object)text)) {
                return text;
            }
            DataValueRepository rep = new DataValueRepository();
            return binding.parseValue(text, rep);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static <T> T getValueAdaptedToBinding(ReadGraph graph, Resource literal, Binding targetBinding) throws DatabaseException {
        Datatype targetDatatype;
        Datatype sourceDatatype = graph.getDataType(literal);
        if (sourceDatatype.equals((Object)(targetDatatype = targetBinding.type()))) {
            return (T)graph.getValue(literal, targetBinding);
        }
        Binding sourceBinding = Bindings.getBinding((Datatype)sourceDatatype);
        try {
            Adapter adapter = Bindings.adapterFactory.getAdapter(Bindings.getBinding((Datatype)sourceDatatype), targetBinding, true, false);
            Object value = graph.getValue(literal, sourceBinding);
            return (T)adapter.adaptUnchecked(value);
        }
        catch (AdapterConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Statement getStatementInLocal(Resource subject, Statement statement) {
        if (statement.isAsserted(subject)) {
            return new StandardStatement(subject, statement.getPredicate(), statement.getObject());
        }
        return statement;
    }

    public static Resource browsePossible(ReadGraph graph, Resource root, String suffix) throws DatabaseException {
        return graph.getPossibleResource(String.valueOf(graph.getURI(root)) + suffix);
    }

    public static Resource getPossibleChild(ReadGraph graph, Resource resource, String name) throws DatabaseException {
        return (Resource)graph.sync((ReadInterface)new PossibleChild(resource, name));
    }

    public static RelationContext relationContext(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        Statement stm = graph.getSingleStatement(subject, predicate);
        return new RelationContextImpl(subject, stm);
    }

    public static RelationContext relationContext(Statement stm) throws DatabaseException {
        return new RelationContextImpl(stm.getSubject(), stm);
    }

    public static <T> T valueInRelationContext(ReadGraph graph, Resource subject, Statement stm) throws DatabaseException {
        return (T)graph.getValue2(subject, (Object)Layer0Utils.relationContext(stm));
    }

    public static <T> T valueInRelationContext(ReadGraph graph, Resource subject, Statement stm, Binding binding) throws DatabaseException {
        return (T)graph.getValue2(subject, (Object)Layer0Utils.relationContext(stm), binding);
    }

    public static <T> T relatedValueInRelationContext(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        Statement stm = Layer0Utils.getStatementInLocal(subject, graph.getSingleStatement(subject, relation));
        return Layer0Utils.valueInRelationContext(graph, stm.getObject(), stm);
    }

    public static <T> T relatedValueInRelationContext(ReadGraph graph, Resource subject, Resource relation, Binding binding) throws DatabaseException {
        Statement stm = Layer0Utils.getStatementInLocal(subject, graph.getSingleStatement(subject, relation));
        return Layer0Utils.valueInRelationContext(graph, stm.getObject(), stm, binding);
    }

    public static Statement possibleObtainedStatementInternal(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        for (Resource ob : graph.getObjects(subject, L0X.DefinesObtainedStatement)) {
            Resource pred = graph.getSingleObject(ob, L0X.ObtainedStatement_predicate);
            if (!graph.isSubrelationOf(pred, relation)) continue;
            Resource object = graph.getSingleObject(ob, L0X.ObtainedStatement_object);
            return new StandardStatement(subject, pred, object);
        }
        ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
        for (Statement stm : graph.getStatements(subject, L0X.ObtainsProperty)) {
            Integer position = (Integer)graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation, (Binding)Bindings.INTEGER);
            order.add(new OrderedResource(position, stm.getObject()));
        }
        for (OrderedResource or : order) {
            Statement stm = Layer0Utils.possibleObtainedStatementInternal(graph, or.r, relation);
            if (stm == null) continue;
            return stm;
        }
        return null;
    }

    public static <T> T possibleObtainedValue(ReadGraph graph, RelationContext ctx, Binding binding) throws DatabaseException {
        Statement stm = ctx.getStatement();
        Statement obj = Layer0Utils.possibleObtainedStatementInternal(graph, stm.getSubject(), stm.getPredicate());
        if (obj != null) {
            return Layer0Utils.valueInRelationContext(graph, obj.getObject(), obj, binding);
        }
        return null;
    }

    public static void addObtainedStatement(WriteGraph graph, Resource subject, Resource predicate, Resource object) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource ob = graph.newResource();
        graph.claim(ob, L0.InstanceOf, null, L0X.ObtainedStatement);
        graph.claim(ob, L0X.ObtainedStatement_predicate, null, predicate);
        graph.claim(ob, L0X.ObtainedStatement_object, null, object);
        graph.claim(subject, L0X.DefinesObtainedStatement, null, ob);
    }

    public static void addObtainedValue(WriteGraph graph, Resource subject, Resource predicate, Resource type, Object value, Binding binding) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource object = graph.newResource();
        graph.claim(object, L0.InstanceOf, type);
        graph.claimValue(object, value, binding);
        Layer0Utils.addObtainedStatement(graph, subject, predicate, object);
    }

    public static void waitIndexPending() {
        Indexing.waitIndexPending();
    }

    public static boolean setDependenciesIndexingDisabled(WriteOnlyGraph graph, boolean disabled) {
        return Indexing.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)disabled);
    }

    public static String undo() throws DatabaseException {
        Session session = Simantics.getSession();
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.undoAndReturnOperations(session, 1);
        if (ops.isEmpty()) {
            return "Undo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection ids = management.getChangeSetIdentifiers(csId, csId);
        return "Undo reverted " + ids.size() + " change sets.";
    }

    public static String undoOperations(int amountOfOperations) throws DatabaseException {
        Session session = Simantics.getSession();
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.undoAndReturnOperations(session, amountOfOperations);
        if (ops.isEmpty()) {
            return "Undo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection ids = management.getChangeSetIdentifiers(csId, csId);
        return "Undo reverted " + ids.size() + " change sets.";
    }

    public static String redo() throws DatabaseException {
        Session session = Simantics.getSession();
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.redo(session, 1);
        if (ops.isEmpty()) {
            return "Redo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection ids = management.getChangeSetIdentifiers(csId, csId);
        return "Redo redid " + ids.size() + " change sets.";
    }

    public static String getComment(Session session, ChangeSetIdentifier id) {
        byte[] data = (byte[])id.getMetadata().get(CommentMetadata.class.getName());
        if (data == null) {
            return "Undescribed operation.";
        }
        String comment = CommentMetadata.deserialise((Session)session, (byte[])data).toString().trim();
        if (comment.isEmpty()) {
            return "Undescribed operation.";
        }
        return comment;
    }

    public static void addCommentMetadata(WriteGraph graph, String string) throws ServiceException {
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)string)));
    }

    public static void copyTo(WriteGraph graph, Resource targetContainer, Resource source) throws DatabaseException {
        Layer0Utils.copyTo(graph, targetContainer, source, null);
    }

    public static void copyTo(WriteGraph graph, Resource targetContainer, Resource source, PasteEventHandler handler) throws DatabaseException {
        CopyHandler ch = (CopyHandler)graph.adapt(source, CopyHandler.class);
        SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
        ch.copyToClipboard((ReadGraph)graph, clipboard);
        PasteHandler ph = (PasteHandler)graph.adapt(targetContainer, PasteHandler.class);
        ph.pasteFromClipboard(graph, clipboard, handler);
    }

    public static ClusterCollectorPolicy setClusterCollectorPolicy(ClusterCollectorPolicy policy) {
        Session session = Simantics.getSession();
        ClusterControl cc = (ClusterControl)session.getService(ClusterControl.class);
        return cc.setPolicy(policy);
    }

    private static String decodeType(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype dt = Layer0Utils.getDatatype(graph, variable);
        return dt.toSingleLineString();
    }

    private static boolean isAsserted(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        Statement stm = graph.getPossibleStatement(subject, predicate);
        return stm.isAsserted(subject);
    }

    public static void setExpression(WriteGraph graph, Variable context, String text, Resource expressionValueType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource object = context.getRepresents((ReadGraph)graph);
        Resource predicateResource = context.getPredicateResource((ReadGraph)graph);
        Variable parent = context.getParent((ReadGraph)graph);
        Resource parentResource = parent.getRepresents((ReadGraph)graph);
        boolean hasExpression = graph.isInstanceOf(object, expressionValueType);
        String t = Layer0Utils.getSCLType((ReadGraph)graph, context);
        if (Layer0Utils.isAsserted((ReadGraph)graph, parentResource, predicateResource)) {
            Resource newValue = graph.newResource();
            graph.claim(newValue, L0.InstanceOf, expressionValueType);
            graph.claimLiteral(newValue, L0.HasValueType, (Object)t, (Binding)Bindings.STRING);
            graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)text.substring(1), (Binding)Bindings.STRING);
            graph.claim(parentResource, predicateResource, newValue);
        } else if (hasExpression) {
            graph.claimLiteral(object, L0.SCLValue_expression, (Object)text.substring(1), (Binding)Bindings.STRING);
        } else {
            Resource newValue = graph.newResource();
            graph.claim(newValue, L0.InstanceOf, expressionValueType);
            graph.claimLiteral(newValue, L0.HasValueType, (Object)t, (Binding)Bindings.STRING);
            graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)text.substring(1), (Binding)Bindings.STRING);
            graph.deny(parentResource, predicateResource);
            graph.claim(parentResource, predicateResource, newValue);
        }
    }

    public static void clearExpression(WriteGraph graph, Variable property, Resource expressionValueType) throws DatabaseException {
        Resource predicate;
        Resource subject;
        boolean hasExpression;
        Resource object = property.getPossibleRepresents((ReadGraph)graph);
        if (object != null && (hasExpression = graph.isInstanceOf(object, expressionValueType)) && (subject = property.getParent((ReadGraph)graph).getPossibleRepresents((ReadGraph)graph)) != null && (predicate = property.getPossiblePredicateResource((ReadGraph)graph)) != null) {
            graph.deny(subject, predicate, object);
            RemoverUtil.remove(graph, object);
        }
    }

    public static boolean setOrClearExpression(WriteGraph graph, Variable property, String text, Resource expressionValueType) throws DatabaseException {
        if (text.startsWith("=")) {
            Layer0Utils.setExpression(graph, property, text, expressionValueType);
            return true;
        }
        Layer0Utils.clearExpression(graph, property, expressionValueType);
        return false;
    }

    public static void setValueAsString(WriteGraph graph, Variable property, String text, Resource expressionValueType) throws DatabaseException {
        try {
            Layer0Utils.setOrClearExpression(graph, property, text, expressionValueType);
            Object value = text;
            Datatype type = (Datatype)property.getPossiblePropertyValue((ReadGraph)graph, "DATATYPE");
            if (type != null) {
                Binding binding = Bindings.getBinding((Datatype)type);
                if (binding instanceof StringBinding) {
                    value = binding instanceof MutableStringBinding ? new MutableString(text) : text;
                } else {
                    if (binding instanceof NumberBinding) {
                        text = text.replace(",", ".");
                    }
                    value = binding.parseValue(text, new DataValueRepository());
                }
                property.setValue(graph, value, binding);
            } else {
                property.setValue(graph, value);
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)value)));
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static String queryDebugSupport(String query) {
        Session session = Simantics.getSession();
        DebugSupport ds = (DebugSupport)session.getService(DebugSupport.class);
        return (String)ds.query(session, "exec " + query);
    }

    public static String queryListSupport(String query) {
        Session session = Simantics.getSession();
        DebugSupport ds = (DebugSupport)session.getService(DebugSupport.class);
        return (String)ds.query(session, "list " + query);
    }

    public static List<Object> sortByCluster(ReadGraph graph, List<Object> list, final Function1<Object, Resource> fn) {
        final ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        ArrayList<Object> result = new ArrayList<Object>(list);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                Resource r1 = (Resource)fn.apply(o1);
                Resource r2 = (Resource)fn.apply(o2);
                long l1 = cs.getCluster(r1);
                if (l1 < (l2 = cs.getCluster(r2))) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return 0;
            }
        });
        return result;
    }

    public static <T> List<T> sortByClusterT(ReadGraph graph, List<T> list, final Function1<T, Resource> fn) {
        final ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                Resource r1 = (Resource)fn.apply(o1);
                Resource r2 = (Resource)fn.apply(o2);
                long l1 = cs.getCluster(r1);
                if (l1 < (l2 = cs.getCluster(r2))) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return 0;
            }
        });
        return result;
    }

    public static void makeSynchronous(ReadGraph graph, boolean value) throws DatabaseException {
        graph.setSynchronous(value);
    }

    public static List<Resource> listOntologies(ReadGraph graph) throws DatabaseException {
        return (List)graph.syncRequest((Read)new OntologiesFromLibrary(graph.getRootLibrary()));
    }

    public static <T> T applySCL(String module, String function, ReadGraph graph, Object ... args) throws DatabaseException {
        try {
            SCL_GRAPH.set(graph);
            Object t = ((Function)SCLOsgi.INSTANCE.getValue(String.valueOf(module) + "/" + function)).applyArray(args);
            SCL_GRAPH.set(null);
            return (T)t;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
    }

    public static boolean isContainerPublished(ReadGraph graph, Resource resource) throws DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        if (indexRoot == null) {
            return false;
        }
        if (resource.equals(indexRoot)) {
            return false;
        }
        return Layer0Utils.isPublished(graph, indexRoot);
    }

    public static boolean isPublished(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Boolean value = (Boolean)graph.getPossibleRelatedValue(resource, L0.Entity_published, (Binding)Bindings.BOOLEAN);
        if (value != null && value.booleanValue()) {
            return true;
        }
        Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        return root != null && (value = (Boolean)graph.getPossibleRelatedValue(root, L0.Entity_published, (Binding)Bindings.BOOLEAN)) != null && value != false;
    }
}

