/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.primitiverequest.Value;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ConsistsOfProcess;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.layer0.Layer0;

public class DomainProcessor3 {
    Serializer variantSerializer;
    Serializer datatypeSerializer;
    Binding datatypeBinding;
    boolean ignoreVirtual;
    int id = 0;
    Set<Resource> fringe = null;
    Set<Resource> exclusions = null;
    Set<Resource> predicates = null;
    Map<Resource, Boolean> isRelatedToPredicates = null;
    Set<Resource> deadPredicates = null;
    Set<Resource> strongInverseSet = null;
    TIntIntHashMap ids = null;
    Map<Resource, SubgraphExtent.ExtentStatus> status = null;
    Map<Datatype, byte[]> bindings = new HashMap<Datatype, byte[]>();
    final SerialisationSupport support;
    private Layer0 L0;
    private long composedObjectCounter = 0L;
    private long fastInternalCounter = 0L;
    private long parentExternalCounter = 0L;
    private long fullInternalCounter = 0L;
    private long fullExternalCounter = 0L;
    long startupTime = 0L;
    long expandTime = 0L;
    long fullResolveTime = 0L;
    long fastResolveTime = 0L;
    long otherStatementTime = 0L;
    long parentResolveTime = 0L;
    long extentSeedTime = 0L;
    long classifyPredicateTime = 0L;
    long processFringeTime = 0L;
    long valueOutputTime = 0L;
    long statementOutputTime = 0L;

    public DomainProcessor3(ReadGraph graph, TransferableGraphConfiguration2 conf, DomainProcessorState state, boolean ignoreVirtual) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        this.ignoreVirtual = ignoreVirtual;
        this.startupTime = System.nanoTime();
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        this.ids = state.ids;
        this.status = (Map)cs.createMap(SubgraphExtent.ExtentStatus.class);
        this.predicates = cs.createSet();
        this.exclusions = cs.createSet();
        this.fringe = cs.createSet();
        this.isRelatedToPredicates = (Map)cs.createMap(Boolean.class);
        this.deadPredicates = cs.createSet();
        this.strongInverseSet = cs.createSet();
        for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : conf.preStatus.entrySet()) {
            this.status.put(entry.getKey(), entry.getValue());
            if (!SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)entry.getValue())) continue;
            this.exclusions.add(entry.getKey());
        }
        this.startupTime = System.nanoTime() - this.startupTime;
        for (TransferableGraphConfiguration2.RootSpec p : conf.roots) {
            if (!p.internal) continue;
            this.fringe.add(p.resource);
        }
    }

    public Map<Resource, SubgraphExtent.ExtentStatus> getStatus() {
        return this.status;
    }

    public Collection<DirectStatements> extractFromFringe(ReadGraph graph, int maxAmount) throws DatabaseException {
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Collection list = cs.createList();
        Iterator<Resource> it = this.fringe.iterator();
        int i = 0;
        while (i < maxAmount) {
            if (!it.hasNext()) break;
            list.add(it.next());
            it.remove();
            ++i;
        }
        return (Collection)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest.Expansion3(cs.asSortedList(list), this.ignoreVirtual));
    }

    public Collection<DirectStatements> expand(ReadGraph graph) throws DatabaseException {
        long start = System.nanoTime();
        Collection<DirectStatements> result = this.extractFromFringe(graph, 2048);
        this.expandTime += System.nanoTime() - start;
        return result;
    }

    public void classifyPredicates(ReadGraph graph, Set<Resource> schedule, DomainProcessorState state) throws DatabaseException {
        for (Resource predicate : schedule) {
            Boolean isRelatedTo = Boolean.FALSE;
            Resource single = graph.getPossibleSuperrelation(predicate);
            if (single != null) {
                Boolean singleIsRelatedTo = this.isRelatedToPredicates.get(single);
                if (singleIsRelatedTo == null) {
                    singleIsRelatedTo = graph.isSubrelationOf(single, this.L0.IsRelatedTo);
                    this.isRelatedToPredicates.put(single, singleIsRelatedTo);
                }
                isRelatedTo = singleIsRelatedTo;
            } else if (graph.isSubrelationOf(predicate, this.L0.IsRelatedTo)) {
                isRelatedTo = Boolean.TRUE;
            } else if (!graph.hasStatement(predicate)) {
                this.deadPredicates.add(predicate);
                state.inverses.remove(this.support.getTransientId(predicate));
            }
            this.isRelatedToPredicates.put(predicate, isRelatedTo);
        }
    }

    public void classifyPredicates(ReadGraph graph, DomainProcessorState state, Collection<DirectStatements> expansion) throws DatabaseException {
        long start = System.nanoTime();
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set schedule = cs.createSet();
        Map newPredicates = (Map)cs.createMap(Resource.class);
        for (DirectStatements directStatements : expansion) {
            for (Statement stm : directStatements) {
                Resource predicate = stm.getPredicate();
                Resource object = stm.getObject();
                if (this.exclusions.contains(object) || this.exclusions.contains(predicate) || !this.predicates.add(predicate)) continue;
                Resource inverse = graph.getPossibleInverse(predicate);
                schedule.add(predicate);
                if (inverse != null) {
                    newPredicates.put(predicate, inverse);
                    if (this.predicates.add(inverse)) {
                        schedule.add(inverse);
                    }
                    state.inverses.put(this.support.getTransientId(predicate), this.support.getTransientId(inverse));
                    state.inverses.put(this.support.getTransientId(inverse), this.support.getTransientId(predicate));
                    continue;
                }
                state.inverses.put(this.support.getTransientId(predicate), 0);
            }
        }
        this.classifyPredicates(graph, schedule, state);
        for (Map.Entry entry : newPredicates.entrySet()) {
            Boolean isRelatedToKey;
            Boolean isRelatedToValue = this.isRelatedToPredicates.get(entry.getValue());
            if (isRelatedToValue.booleanValue()) {
                this.strongInverseSet.add((Resource)entry.getKey());
            }
            if (!(isRelatedToKey = this.isRelatedToPredicates.get(entry.getKey())).booleanValue()) continue;
            this.strongInverseSet.add((Resource)entry.getValue());
        }
        this.classifyPredicateTime += System.nanoTime() - start;
    }

    private Datatype getDatatype(ReadGraph graph, Resource subject) throws DatabaseException {
        Statement stm = graph.getSingleStatement(subject, this.L0.HasDataType);
        return (Datatype)graph.syncRequest((Read)new Value(stm.getObject(), this.datatypeBinding), (Listener)TransientCacheListener.instance());
    }

    public void processFringe(ReadGraph graph, Collection<DirectStatements> expansion, final DomainProcessorState state) throws DatabaseException, IOException {
        TransferableGraphSupport tgs = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
        long start = System.nanoTime();
        for (DirectStatements stms : expansion) {
            Resource subject = stms.getSubject();
            boolean partOf = false;
            for (Statement stm : stms) {
                Resource predicate = stm.getPredicate();
                if (!this.L0.PartOf.equals(predicate)) continue;
                partOf = true;
                break;
            }
            SubgraphExtent.ExtentStatus subjectStatus = this.status.get(subject);
            if (subjectStatus == SubgraphExtent.ExtentStatus.EXTERNAL || subjectStatus == SubgraphExtent.ExtentStatus.EXCLUDED) continue;
            if (partOf && (subjectStatus == null || SubgraphExtent.ExtentStatus.PENDING == subjectStatus) && graph.getPossibleURI(subject) != null) {
                this.status.put(subject, SubgraphExtent.ExtentStatus.EXTERNAL);
                continue;
            }
            this.status.put(subject, SubgraphExtent.ExtentStatus.INTERNAL);
            int sId = this.support.getTransientId(subject);
            long start2 = System.nanoTime();
            final InputStream valueStream = tgs.getValueStream(graph, subject);
            if (valueStream != null) {
                Datatype dt = this.getDatatype(graph, subject);
                byte[] typeBytes = this.bindings.get(dt);
                if (typeBytes == null) {
                    typeBytes = this.datatypeSerializer.serialize((Object)dt);
                    this.bindings.put(dt, typeBytes);
                }
                state.valueOutput.writeInt(sId);
                state.valueOutput.write(typeBytes);
                Serializer s = Bindings.getSerializerUnchecked((Binding)Bindings.getBinding((Datatype)dt));
                s.skip(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        int value = valueStream.read();
                        state.valueOutput.write(value);
                        return value;
                    }
                });
                ++state.valueCount;
            }
            this.valueOutputTime += System.nanoTime() - start2;
            long start3 = System.nanoTime();
            TIntArrayList stream = new TIntArrayList();
            for (Statement stm : stms) {
                Resource predicate = stm.getPredicate();
                Resource object = stm.getObject();
                SubgraphExtent.ExtentStatus objectStatus = this.status.get(object);
                Boolean isRelatedTo = this.isRelatedToPredicates.get(predicate);
                if (objectStatus != SubgraphExtent.ExtentStatus.EXCLUDED && isRelatedTo.booleanValue()) {
                    stream.add(this.support.getTransientId(predicate));
                    stream.add(this.support.getTransientId(object));
                    if (objectStatus != null && objectStatus != SubgraphExtent.ExtentStatus.PENDING) continue;
                    this.fringe.add(object);
                    continue;
                }
                if (this.deadPredicates.contains(predicate) || objectStatus == SubgraphExtent.ExtentStatus.EXCLUDED || this.strongInverseSet.contains(predicate)) continue;
                stream.add(this.support.getTransientId(predicate));
                stream.add(this.support.getTransientId(object));
                if (objectStatus != null) continue;
                this.status.put(object, SubgraphExtent.ExtentStatus.PENDING);
            }
            if (!stream.isEmpty()) {
                state.statementsOutput.writeInt(sId);
                state.statementsOutput.writeInt(stream.size() / 2);
                int i = 0;
                while (i < stream.size()) {
                    state.statementsOutput.writeInt(stream.getQuick(i));
                    ++i;
                }
                state.statementCount += 2 * stream.size();
            }
            this.statementOutputTime += System.nanoTime() - start3;
        }
        this.processFringeTime += System.nanoTime() - start;
    }

    public void process(ReadGraph graph, DomainProcessorState state) throws DatabaseException {
        try {
            this.variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
            this.datatypeBinding = Bindings.getBindingUnchecked(Datatype.class);
            this.datatypeSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked(this.datatypeBinding);
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            for (Resource r : ConsistsOfProcess.walk(graph, this.fringe, this.exclusions, this.ignoreVirtual)) {
                if (this.status.put(r, SubgraphExtent.ExtentStatus.INTERNAL) != null) continue;
                this.fringe.add(r);
            }
            while (!this.fringe.isEmpty()) {
                Collection<DirectStatements> expansion = this.expand(graph);
                this.classifyPredicates(graph, state, expansion);
                this.processFringe(graph, expansion, state);
            }
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    void logStatementWithExtent(ReadGraph graph, String header, SubgraphExtent.ExtentStatus status, int sId, int pId, int oId) throws DatabaseException {
    }

    void logStatementWithExtent(ReadGraph graph, String header, SubgraphExtent.ExtentStatus status, Resource sId, Resource pId, Resource oId) throws DatabaseException {
    }
}

