/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ClassificationsRequest;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.datastructures.Pair;

public final class PropertyInfoRequest
extends ResourceRead<PropertyInfo> {
    private static int classHash = 31 * PropertyInfo.class.hashCode();

    public PropertyInfoRequest(Resource resource) {
        super(resource);
    }

    public PropertyInfo perform(ReadGraph graph) throws DatabaseException {
        Collection subliterals;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        boolean isHasProperty = graph.isSubrelationOf(this.resource, L0.HasProperty);
        String name = (String)graph.getPossibleRelatedValue(this.resource, L0.HasName, (Binding)Bindings.STRING);
        Set classifications = (Set)graph.sync((ReadInterface)new ClassificationsRequest(graph.getPrincipalTypes(this.resource)));
        VariableBuilder variableBuilder = (VariableBuilder)graph.getPossibleAdapter(this.resource, VariableBuilder.class);
        Datatype requiredDataType = (Datatype)graph.getPossibleRelatedValue(this.resource, L0X.RequiresDataType, Layer0Utils.datatype_binging);
        Binding defaultBinding = requiredDataType != null ? Bindings.getBinding((Datatype)requiredDataType) : null;
        String requiredValueType = (String)graph.getPossibleRelatedValue(this.resource, L0.RequiresValueType, (Binding)Bindings.STRING);
        Resource possibleRange = graph.getPossibleObject(this.resource, L0.HasRange);
        if (possibleRange != null && !(subliterals = graph.getObjects(possibleRange, L0.HasSubliteralPredicate)).isEmpty()) {
            HashMap<String, Pair<Resource, ChildReference>> map = new HashMap<String, Pair<Resource, ChildReference>>();
            for (Resource p : subliterals) {
                NameReference r;
                String pN = (String)graph.getPossibleRelatedValue(p, L0.HasName, (Binding)Bindings.STRING);
                if (pN == null) continue;
                if (pN.startsWith("n-")) {
                    r = new NameReference(pN.substring(2));
                    map.put(pN, (Pair<Resource, ChildReference>)Pair.make((Object)p, (Object)r));
                    continue;
                }
                if (!pN.startsWith("i-")) continue;
                r = new IndexReference(Integer.parseInt(pN.substring(2)));
                map.put(pN, (Pair<Resource, ChildReference>)Pair.make((Object)p, (Object)r));
            }
            return new PropertyInfo(this.resource, name, isHasProperty, classifications, variableBuilder, requiredDataType, requiredValueType, defaultBinding, map);
        }
        return new PropertyInfo(this.resource, name, isHasProperty, classifications, variableBuilder, requiredDataType, requiredValueType, defaultBinding, Collections.<String, Pair<Resource, ChildReference>>emptyMap());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PropertyInfoRequest)) {
            return false;
        }
        PropertyInfoRequest r = (PropertyInfoRequest)((Object)object);
        return r.resource.equals(this.resource);
    }

    public int hashCode() {
        return this.resource.hashCode() + classHash;
    }
}

