/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.Layer0X;

public class ActivateModel
extends WriteRequest {
    final Resource project;
    final Resource model;

    public ActivateModel(Resource project, Resource model, VirtualGraph vg) {
        super(vg);
        if (project == null) {
            throw new IllegalArgumentException("project can not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be null");
        }
        this.project = project;
        this.model = model;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        if (!graph.hasStatement(this.model, L0X.IsActivatedBy, this.project)) {
            graph.deny(this.project, L0X.Activates);
            graph.claim(this.project, L0X.Activates, this.model);
        }
    }
}

