/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.realization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.VirtualGraphContext;
import org.simantics.db.VirtualGraphSource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.single.SingleSetSyncListener;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.transientgraph.StatementBuilder;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.RuntimeValuations;
import org.simantics.db.layer0.realization.IntBuiltins;
import org.simantics.db.layer0.realization.RealizationValue;
import org.simantics.db.layer0.realization.ResourceData;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

public class RealizationVirtualGraph
implements VirtualGraphSource {
    private static final int[] NO_STATEMENTS = new int[0];
    protected final ConcurrentHashMap<Integer, ResourceData> undiscovered = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Integer, RealizationValue> undiscoveredValues = new ConcurrentHashMap();
    protected final Layer0 L0;
    protected final Layer0X L0X;
    protected final Resource model;
    protected final Resource valuation;
    private IntBuiltins ib;
    private int defaultTypeIndex;

    public RealizationVirtualGraph(Session session, Resource model, Resource valuation) throws DatabaseException {
        assert (session != null);
        assert (model != null);
        this.L0 = Layer0.getInstance((RequestProcessor)session);
        this.L0X = Layer0X.getInstance((RequestProcessor)session);
        this.model = model;
        this.valuation = valuation;
    }

    public void initialize(final VirtualGraphContext context, WriteGraph graph) throws DatabaseException {
        final SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource configuration = graph.getPossibleObject(this.model, SIMU.HasConfiguration);
        Resource baseRealizationResource = graph.newResource();
        int defaultsNode = context.getIndex(baseRealizationResource);
        graph.claim(this.model, this.L0.ConsistsOf, this.L0.PartOf, baseRealizationResource);
        graph.claim(this.model, L0X.HasBaseRealization, null, baseRealizationResource);
        graph.claim(baseRealizationResource, this.L0.InstanceOf, null, this.valuation);
        graph.addLiteral(baseRealizationResource, this.L0.HasName, this.L0.NameOf, this.L0.String, (Object)"BaseRealization", (Binding)Bindings.STRING);
        for (Resource part : graph.getObjects(configuration, this.L0.ConsistsOf)) {
            int partNode = context.newResource(true);
            Resource partResource = context.getResource(partNode);
            graph.claim(baseRealizationResource, this.L0.ConsistsOf, null, partResource);
            this.undiscovered.put(partNode, new ResourceData(defaultsNode, part));
        }
        graph.asyncRequest((Read)new Read<Collection<Resource>>(){

            public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                HashSet<Resource> result = new HashSet<Resource>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource config : graph.getObjects(RealizationVirtualGraph.this.model, L0.ConsistsOf)) {
                    if (!graph.isInstanceOf(config, SIMU.Experiment)) continue;
                    for (Resource run : graph.getObjects(config, L0.ConsistsOf)) {
                        if (!graph.isInstanceOf(run, SIMU.Run)) continue;
                        result.add(run);
                    }
                }
                return result;
            }
        }, (AsyncListener)new SingleSetSyncListener<Resource>(){

            public void add(ReadGraph graph, final Resource run) throws DatabaseException {
                final String experimentName = (String)graph.getPossibleRelatedValue(run, RealizationVirtualGraph.this.L0.HasName, (Binding)Bindings.STRING);
                System.out.println("RealizationVirtualGraph new experiment " + experimentName);
                RuntimeValuations vs = (RuntimeValuations)graph.getService(RuntimeValuations.class);
                if (vs.supports(experimentName)) {
                    System.out.println("RealizationVirtualGraph scheduling " + experimentName);
                    graph.getSession().asyncRequest((Write)new WriteRequest((VirtualGraph)graph.getService(VirtualGraph.class)){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            System.out.println("RealizationVirtualGraph about to serve " + experimentName);
                            int runNode = context.getIndex(run);
                            Resource configuration = graph.getPossibleObject((this).RealizationVirtualGraph.this.model, SIMU.HasConfiguration);
                            ArrayList roots = new ArrayList(graph.getObjects(configuration, (this).RealizationVirtualGraph.this.L0.ConsistsOf));
                            for (Resource part : roots) {
                                int partNode = context.newResource(true);
                                Resource partResource = context.getResource(partNode);
                                graph.claim(run, (this).RealizationVirtualGraph.this.L0.ConsistsOf, null, partResource);
                                (this).RealizationVirtualGraph.this.undiscovered.put(partNode, new ResourceData(runNode, part));
                            }
                        }
                    });
                }
            }

            public void exception(ReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }

            public boolean isDisposed() {
                return false;
            }
        });
    }

    public void attach(final VirtualGraphContext context) {
        this.ib = new IntBuiltins(context, this.L0, this.L0X);
        this.defaultTypeIndex = context.getIndex(this.valuation);
        context.initialise((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                RealizationVirtualGraph.this.initialize(context, graph);
            }
        });
    }

    public void getStatements(ReadGraph graph, VirtualGraphContext context, int resource) throws DatabaseException {
        this.getStatements(graph, context, resource, this.ib.InstanceOf);
        this.getStatements(graph, context, resource, this.ib.PartOf);
        this.getStatements(graph, context, resource, this.ib.HasName);
        this.getStatements(graph, context, resource, this.ib.ConsistsOf);
        this.getStatements(graph, context, resource, this.ib.Represents);
    }

    public void getStatements(ReadGraph graph, VirtualGraphContext context, int resource, int predicate) throws DatabaseException {
        if (!this.undiscovered.containsKey(resource)) {
            return;
        }
        ResourceData config = this.undiscovered.get(resource);
        int type = this.defaultTypeIndex;
        if (this.ib.InstanceOf == predicate) {
            StatementBuilder resourceStatements = new StatementBuilder(new int[]{this.ib.InstanceOf, type});
            resourceStatements.commit(context, resource);
        } else if (this.ib.PartOf == predicate) {
            StatementBuilder resourceStatements = new StatementBuilder(new int[]{this.ib.PartOf, config.parentValue});
            resourceStatements.commit(context, resource);
        } else if (this.ib.HasName == predicate) {
            String literal = (String)graph.getPossibleRelatedValue(config.structureResource, this.L0.HasName, (Binding)Bindings.STRING);
            if (literal != null) {
                int name = context.newResource(false);
                StatementBuilder.commit((VirtualGraphContext)context, (int)name, (int[])new int[]{this.ib.NameOf, resource, this.ib.InstanceOf, this.ib.String});
                context.updateValue(name, (Object)literal, (Binding)Bindings.STRING);
                StatementBuilder resourceStatements = new StatementBuilder(new int[]{this.ib.HasName, name});
                resourceStatements.commit(context, resource);
            }
        } else if (this.ib.Represents == predicate) {
            StatementBuilder resourceStatements = new StatementBuilder(new int[]{this.ib.Represents, context.getIndex(config.structureResource)});
            resourceStatements.commit(context, resource);
        } else if (this.ib.ConsistsOf == predicate) {
            StatementBuilder resourceStatements = new StatementBuilder(new int[0]);
            for (Resource child : graph.getObjects(config.structureResource, this.L0.ConsistsOf)) {
                int part = context.newResource(true);
                resourceStatements.add(new int[]{this.ib.ConsistsOf, part});
                this.undiscovered.put(part, new ResourceData(resource, child));
            }
            resourceStatements.commit(context, resource);
        }
    }

    public void getValue(AsyncReadGraph graph, VirtualGraphContext context, int resource, AsyncProcedure<byte[]> value) {
        System.err.println("asdasd2");
    }
}

