/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.realization;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraphContext;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.NamedTypedResource;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.adapter.StagedAsyncListener;
import org.simantics.db.common.procedure.adapter.SyncProcedureAdapter;
import org.simantics.db.common.procedure.single.SingleSetAsyncListener;
import org.simantics.db.common.request.AsyncMappedParts;
import org.simantics.db.common.request.BinaryAsyncRead;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Realization;
import org.simantics.db.layer0.realization.RealizationResult;
import org.simantics.db.layer0.realization.RealizationValue;
import org.simantics.db.layer0.realization.ResourceData;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.WriteOnly;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class RealizationRequest
extends BinaryAsyncRead<Resource, Integer, RealizationResult> {
    private final ConcurrentHashMap<Integer, ResourceData> undiscovered;
    private final VirtualGraphContext context;
    private final Layer0 L0;
    private final Layer0X L0X;
    private final String experiment;
    private final String browseName;

    public RealizationRequest(ConcurrentHashMap<Integer, ResourceData> undiscovered, VirtualGraphContext context, Layer0 L0, Layer0X L0X, int valuationResource, Resource configurationResource, String experiment, String browseName) {
        super((Object)configurationResource, (Object)valuationResource);
        this.undiscovered = undiscovered;
        this.context = context;
        this.L0 = L0;
        this.L0X = L0X;
        this.experiment = experiment;
        this.browseName = browseName;
    }

    public int getFlags() {
        return 0;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<RealizationResult> procedure) {
        final AtomicInteger ready = new AtomicInteger(0);
        final ConcurrentLinkedQueue<NamedTypedResource> names = new ConcurrentLinkedQueue<NamedTypedResource>();
        ConcurrentLinkedQueue<RealizationValue> values = new ConcurrentLinkedQueue<RealizationValue>();
        final RealizationResult result = new RealizationResult(names, values);
        graph.forPossibleAdapted((Resource)this.parameter, Realization.class, (AsyncProcedure)new AsyncProcedure<Realization>(){

            public void execute(AsyncReadGraph graph, final Realization factory) {
                if (factory == null) {
                    procedure.execute(graph, (Object)result);
                    return;
                }
                ready.incrementAndGet();
                factory.forChildren(graph, (AsyncProcedure<Collection<Resource>>)new SingleSetAsyncListener<Resource>(false){

                    public void first(AsyncReadGraph graph, Collection<Resource> first) {
                        for (final Resource child : first) {
                            ready.incrementAndGet();
                            graph.asyncRequest((AsyncRead)new NameAndType(child, factory), (AsyncListener)new StagedAsyncListener<NamedResource>(){

                                public void first(AsyncReadGraph graph, NamedResource nr) {
                                    if (nr == null) {
                                        return;
                                    }
                                    names.add(new NamedTypedResource(nr.getName(), child, nr.getResource()));
                                    if (ready.decrementAndGet() == 0) {
                                        procedure.execute(graph, (Object)result);
                                    }
                                }

                                public void rest(AsyncReadGraph graph, final NamedResource nr) {
                                    if (nr == null) {
                                        return;
                                    }
                                    Resource realizationParent = RealizationRequest.this.context.getResource(((Integer)RealizationRequest.this.parameter2).intValue());
                                    graph.asyncRequest((AsyncRead)new AsyncMappedParts(realizationParent), (SyncProcedure)new SyncProcedureAdapter<Map<Resource, Resource>>(){

                                        public void execute(ReadGraph graph, Map<Resource, Resource> result) throws DatabaseException {
                                            Resource realizationToUpdate = result.get(child);
                                            if (realizationToUpdate != null) {
                                                final Resource nameResource = graph.getPossibleObject(realizationToUpdate, ((RealizationRequest)(((this).this).this).RealizationRequest.this).L0.HasName);
                                                RealizationRequest.this.context.postModification((AsyncRequestProcessor)graph, (WriteOnly)new WriteOnlyRequest(){

                                                    public void perform(WriteOnlyGraph graph) throws DatabaseException {
                                                        graph.claimValue(nameResource, (Object)nr.getName());
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        if (ready.decrementAndGet() == 0) {
                            procedure.execute(graph, (Object)result);
                        }
                    }

                    public void add(AsyncReadGraph graph, final Resource child) {
                        graph.asyncRequest((AsyncRead)new NameAndType(child, factory), (AsyncListener)new StagedAsyncListener<NamedResource>(){

                            public void first(AsyncReadGraph graph, NamedResource nr) {
                                if (nr == null) {
                                    return;
                                }
                                RealizationRequest.this.context.postModification((AsyncRequestProcessor)graph, (WriteOnly)new WriteOnlyRequest(){

                                    public void perform(WriteOnlyGraph graph) throws DatabaseException {
                                        Resource part = graph.newResource();
                                        graph.claim(RealizationRequest.this.context.getResource(((Integer)RealizationRequest.this.parameter2).intValue()), ((RealizationRequest)(((this).this).this).RealizationRequest.this).L0.ConsistsOf, null, part);
                                        RealizationRequest.this.undiscovered.put(RealizationRequest.this.context.getIndex(part), new ResourceData((Integer)RealizationRequest.this.parameter2, child));
                                    }
                                });
                            }

                            public void rest(AsyncReadGraph graph, final NamedResource nr) {
                                if (nr == null) {
                                    return;
                                }
                                Resource realizationParent = RealizationRequest.this.context.getResource(((Integer)RealizationRequest.this.parameter2).intValue());
                                graph.asyncRequest((AsyncRead)new AsyncMappedParts(realizationParent), (SyncProcedure)new SyncProcedureAdapter<Map<Resource, Resource>>(){

                                    public void execute(ReadGraph graph, Map<Resource, Resource> result) throws DatabaseException {
                                        Resource realizationToUpdate = result.get(child);
                                        if (realizationToUpdate != null) {
                                            final Resource nameResource = graph.getPossibleObject(realizationToUpdate, ((RealizationRequest)(((this).this).this).RealizationRequest.this).L0.HasName);
                                            RealizationRequest.this.context.postModification((AsyncRequestProcessor)graph, (WriteOnly)new WriteOnlyRequest(){

                                                public void perform(WriteOnlyGraph graph) throws DatabaseException {
                                                    graph.claimValue(nameResource, (Object)nr.getName());
                                                }
                                            });
                                        }
                                    }
                                });
                            }

                            public void exception(AsyncReadGraph graph, Throwable t) {
                                t.printStackTrace();
                            }
                        });
                    }

                    public void remove(AsyncReadGraph graph, final Resource removedItem) {
                        final Resource realizationParent = RealizationRequest.this.context.getResource(((Integer)RealizationRequest.this.parameter2).intValue());
                        graph.asyncRequest((AsyncRead)new AsyncMappedParts(realizationParent), (AsyncProcedure)new AsyncProcedureAdapter<Map<Resource, Resource>>(){

                            public void execute(AsyncReadGraph graph, Map<Resource, Resource> result) {
                                final Resource realizationToRemove = result.get(removedItem);
                                if (realizationToRemove != null) {
                                    graph.forPossibleObject(realizationToRemove, ((RealizationRequest)((this).this).RealizationRequest.this).L0.HasName, (AsyncProcedure)new AsyncProcedure<Resource>(){

                                        public void execute(AsyncReadGraph graph, final Resource name) {
                                            if (name == null) {
                                                System.err.println("No name in remove in RealizationRequest!");
                                                return;
                                            }
                                            RealizationRequest.this.context.postModification((AsyncRequestProcessor)graph, (WriteOnly)new WriteOnlyRequest(){

                                                public void perform(WriteOnlyGraph graph) throws DatabaseException {
                                                    graph.deny(realizationToRemove, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.InstanceOf, null, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0X.Realization, null);
                                                    graph.deny(realizationParent, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.ConsistsOf, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.PartOf, realizationToRemove, null);
                                                    if (name != null) {
                                                        graph.deny(realizationToRemove, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.HasName, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.NameOf, name, null);
                                                        graph.deny(name, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.InstanceOf, null, ((RealizationRequest)((((this).this).this).this).RealizationRequest.this).L0.String, null);
                                                        graph.denyValue(name);
                                                    }
                                                }
                                            });
                                        }

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            throwable.printStackTrace();
                                        }
                                    });
                                }
                            }

                            public void exception(AsyncReadGraph graph, Throwable t) {
                                t.printStackTrace();
                            }
                        });
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        t.printStackTrace();
                    }

                    public boolean isDisposed() {
                        return false;
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }

    static class NameAndType
    extends BinaryAsyncRead<Resource, Realization, NamedResource> {
        public NameAndType(Resource resource, Realization values) {
            super((Object)resource, (Object)values);
        }

        public void perform(AsyncReadGraph graph, final AsyncProcedure<NamedResource> procedure) {
            ((Realization)this.parameter2).forType(graph, (Resource)this.parameter, new AsyncProcedure<Resource>(){

                public void execute(AsyncReadGraph graph, final Resource type) {
                    ((Realization)NameAndType.this.parameter2).forName(graph, (Resource)NameAndType.this.parameter, new AsyncProcedure<String>(){

                        public void execute(AsyncReadGraph graph, String name) {
                            if (name == null) {
                                procedure.execute(graph, null);
                            } else {
                                procedure.execute(graph, (Object)new NamedResource(name, type));
                            }
                        }

                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                            procedure.exception(graph, throwable);
                        }
                    });
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    procedure.exception(graph, throwable);
                }
            });
        }
    }
}

