/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.FreshEscapedName;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.VersionMap;
import org.simantics.db.common.utils.VersionMapRequest;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.adapter.impl.SharedOntologyImportAdvisor;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStateImpl;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.layer0.util.TGTransferableGraphSource;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class MigrationUtils {
    public static final boolean DEBUG = false;

    public static MigrationState newState() {
        return new MigrationStateImpl();
    }

    public static MigrationStep getStep(Session session, String uri) throws DatabaseException {
        return (MigrationStep)session.sync((ReadInterface)new UnaryRead<String, MigrationStep>(uri){

            public MigrationStep perform(ReadGraph graph) throws DatabaseException {
                Resource r = graph.getResource((String)this.parameter);
                return (MigrationStep)graph.adapt(r, MigrationStep.class);
            }
        });
    }

    public static void clearTempResource(Session session, final Resource resource) {
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.deny(resource, Layer0.getInstance((ReadGraph)graph).PartOf);
            }
        });
    }

    public static Collection<Resource> importTo(IProgressMonitor monitor, Session session, MigrationState state, final Resource parent, final IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        final Resource resource = MigrationUtils.getResource(monitor, session, state);
        final ArrayList<Resource> result = new ArrayList<Resource>();
        if (resource != null) {
            session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    for (Resource root : graph.getObjects(resource, L0.ConsistsOf)) {
                        String baseName = Versions.getBaseName((ReadGraph)graph, (Resource)root);
                        String version = Versions.getVersion((ReadGraph)graph, (Resource)root);
                        if (version != null) {
                            VersionMap map = (VersionMap)graph.syncRequest((Read)new VersionMapRequest(parent));
                            if (map.contains(baseName, version)) {
                                String newName = (String)graph.syncRequest((Read)new FreshEscapedName(parent, Layer0.getInstance((ReadGraph)graph).ConsistsOf, baseName));
                                graph.claimLiteral(root, L0.HasName, (Object)(String.valueOf(newName) + "@1"), (Binding)Bindings.STRING);
                            }
                        } else {
                            String newName = (String)graph.syncRequest((Read)new FreshEscapedName(parent, Layer0.getInstance((ReadGraph)graph).ConsistsOf, baseName));
                            if (!newName.equals(baseName)) {
                                graph.claimLiteral(root, L0.HasName, (Object)newName, (Binding)Bindings.STRING);
                            }
                        }
                        graph.deny(root, L0.PartOf);
                        graph.claim(root, L0.PartOf, parent);
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Imported " + graph.getURI(root) + ", resource " + root));
                        result.add(root);
                    }
                    graph.deny(resource, L0.PartOf);
                }
            });
        } else {
            TransferableGraph1 tg = MigrationUtils.getTG(session, state);
            if (tg != null) {
                DefaultPasteHandler.defaultExecute(tg, parent, new IImportAdvisor(){

                    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
                        Resource r = advisor.createRoot(graph, root);
                        result.add(r);
                        return r;
                    }

                    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
                        return advisor.analyzeRoot(graph, root);
                    }
                });
            }
        }
        return result;
    }

    public static Collection<MigrationStep> getMigrationSteps(DataContainer header, final String baseURI) throws DatabaseException {
        if (baseURI.isEmpty()) {
            return Collections.emptyList();
        }
        return (Collection)Simantics.sync(new BinaryRead<String, Integer, Collection<MigrationStep>>(header.format, Integer.valueOf(header.version)){

            public Collection<MigrationStep> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ArrayList<Pair> steps = new ArrayList<Pair>();
                Resource base = graph.getResource(baseURI);
                for (Resource migration : (Collection)graph.sync((ReadInterface)new ObjectsWithType(base, L0.ConsistsOf, L0.Migration))) {
                    String format = (String)graph.getRelatedValue(migration, L0.Migration_format);
                    if (!((String)this.parameter).equals(format)) continue;
                    Integer from = (Integer)graph.getRelatedValue(migration, L0.Migration_from);
                    Resource step = graph.getSingleObject(migration, L0.Migration_step);
                    if (this.parameter2 != from) continue;
                    Double priority = (Double)graph.getRelatedValue(migration, L0.Migration_priority);
                    steps.add(Pair.make((Object)(-priority.doubleValue()), (Object)((MigrationStep)graph.adapt(step, MigrationStep.class))));
                }
                return CollectionUtils.sortByFirst(steps);
            }
        });
    }

    public static Resource importMigrated(IProgressMonitor monitor, Session session, File modelFile, MigrationState state, IImportAdvisor advisor, Resource target) throws Exception {
        Collection<Resource> roots = MigrationUtils.importMigratedMany(monitor, session, modelFile, state, advisor, target);
        if (roots.size() == 1) {
            return roots.iterator().next();
        }
        return null;
    }

    public static Collection<Resource> importMigratedMany(IProgressMonitor monitor, Session session, File modelFile, MigrationState state, IImportAdvisor advisor, Resource target) throws Exception {
        assert (target != null);
        assert (advisor != null);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String baseURI = (String)state.getProperty("baseURI");
        state.setProperty("modelFile", modelFile);
        state.setProperty("session", session);
        state.setProperty("progressMonitor", monitor);
        DataContainer dc = (DataContainer)state.getProperty("currentDataContainer");
        Collection<MigrationStep> migration = MigrationUtils.getMigrationSteps(dc, baseURI);
        for (MigrationStep step : migration) {
            step.applyTo(monitor, session, state);
        }
        return MigrationUtils.importTo(monitor, session, state, target, advisor);
    }

    public static TransferableGraph1 getTG(Session session, MigrationState state) throws DatabaseException {
        return (TransferableGraph1)state.getProperty("currentTG");
    }

    public static Resource getResource(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        return (Resource)state.getProperty("currentResource");
    }

    public static void importSharedOntology(Session session, TransferableGraph1 tg) throws DatabaseException {
        Collection roots = TransferableGraphUtils.getRoots((TransferableGraph1)tg);
        if (roots.size() == 1) {
            try {
                TGTransferableGraphSource tgSource = new TGTransferableGraphSource(tg);
                TransferableGraphs.importGraph1((Session)session, (TransferableGraphSource)tgSource, (IImportAdvisor)new SharedOntologyImportAdvisor());
            }
            catch (TransferableGraphException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }
}

