/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.StreamingTransferableGraphFileReader;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.ByteFileReader;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphFileReader;
import org.simantics.layer0.Layer0;

public class MigrationStateImpl
implements MigrationState {
    private final HashMap<String, Object> properties = new HashMap();

    public <T> T probeProperty(String key) throws DatabaseException {
        return (T)this.properties.get(key);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getProperty(String key) throws DatabaseException {
        Object property = this.properties.get(key);
        if (property != null) {
            return (T)property;
        }
        if ("baseURI".equals(key)) {
            throw new IllegalStateException("Base URI needs to be supplied for migration.");
        }
        if ("session".equals(key)) {
            throw new IllegalStateException("Session needs to be supplied for migration.");
        }
        if ("modelFile".equals(key)) {
            throw new IllegalStateException("Model file needs to be supplied for migration.");
        }
        if ("currentTG".equals(key)) {
            TransferableGraph1 transferableGraph1;
            final Resource resource = (Resource)this.probeProperty("currentResource");
            if (resource != null) {
                Session session = (Session)this.getProperty("session");
                TransferableGraph1 tg = (TransferableGraph1)session.syncRequest((Read)new Read<TransferableGraph1>(){

                    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Collection roots = graph.getObjects(resource, L0.ConsistsOf);
                        TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, roots, true, false);
                        TransferableGraphSource source = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
                        return TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)source);
                    }
                });
                MigrationUtils.clearTempResource(session, resource);
                this.setProperty("currentResource", null);
                this.setProperty("currentTG", tg);
                return (T)tg;
            }
            TransferableGraphFileReader reader = null;
            try {
                File modelFile = (File)this.getProperty("modelFile");
                reader = new TransferableGraphFileReader(modelFile);
                TransferableGraph1 tg = reader.readTG();
                this.setProperty("currentTG", tg);
                transferableGraph1 = tg;
            }
            catch (DatabaseException e) {
                try {
                    throw e;
                    catch (Throwable t) {
                        throw new DatabaseException(t);
                    }
                }
                catch (Throwable throwable) {
                    MigrationStateImpl.uncheckedClose(reader);
                    throw throwable;
                }
            }
            MigrationStateImpl.uncheckedClose((ByteFileReader)reader);
            return (T)transferableGraph1;
        }
        if ("currentTGS".equals(key)) {
            File modelFile = (File)this.getProperty("modelFile");
            try {
                StreamingTransferableGraphFileReader reader = new StreamingTransferableGraphFileReader(modelFile);
                TransferableGraphSource tgs = reader.readTG();
                this.setProperty("currentTGSReader", reader);
                this.setProperty("currentTGS", tgs);
                return (T)tgs;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (IOException e) {
                throw new DatabaseException("An I/O exception occurred during reading '" + modelFile.getAbsolutePath() + "'", (Throwable)e);
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        if ("currentDataContainer".equals(key)) {
            try {
                TransferableGraphSource tgs = (TransferableGraphSource)this.getProperty("currentTGS");
                DataContainer dc = tgs.getHeader();
                this.setProperty("currentDataContainer", dc);
                return (T)dc;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        if ("tgExtensions".equals(key)) {
            try {
                TransferableGraphSource tgs = (TransferableGraphSource)this.getProperty("currentTGS");
                TreeMap extensions = tgs.getExtensions();
                this.setProperty("tgExtensions", extensions);
                return (T)extensions;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        if ("currentResource".equals(key)) {
            Session session = (Session)this.getProperty("session");
            final IProgressMonitor monitor = (IProgressMonitor)this.probeProperty("progressMonitor");
            final TransferableGraph1 tg = (TransferableGraph1)this.probeProperty("currentTG");
            if (tg != null) {
                Resource indexRoot = (Resource)session.syncRequest((WriteResult)new WriteResultRequest<Resource>(){

                    public Resource perform(WriteGraph graph) throws DatabaseException {
                        Boolean dep = (Boolean)MigrationStateImpl.this.getProperty("updateDependencies");
                        if (dep != null && !dep.booleanValue()) {
                            Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, true);
                        }
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Resource project = Simantics.getProject();
                        Resource root = graph.getPossibleObject(project, Layer0.getInstance((ReadGraph)graph).PartOf);
                        Resource temp = Layer0Utils.getPossibleChild((ReadGraph)graph, root, "Temp");
                        if (temp == null) {
                            return null;
                        }
                        Resource indexRoot = graph.newResource();
                        String indexRootName = DateFormat.getDateTimeInstance(0, 0).format(new Date());
                        graph.claim(indexRoot, L0.InstanceOf, L0.IndexRoot);
                        graph.addLiteral(indexRoot, L0.HasName, L0.String, (Object)indexRootName, (Binding)Bindings.STRING);
                        graph.claim(temp, L0.ConsistsOf, indexRoot);
                        DefaultPasteImportAdvisor ia = new DefaultPasteImportAdvisor(indexRoot);
                        TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)ia, (TGStatusMonitor)new TGStatusMonitor(){

                            public void status(int percentage) {
                                if (monitor != null) {
                                    monitor.subTask("Importing model from file (" + percentage + "%)");
                                }
                            }
                        });
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Creating indexRoot resource " + indexRoot + " and importing model from file. "));
                        return indexRoot;
                    }
                });
                if (indexRoot == null) return (T)indexRoot;
                this.setProperty("currentResource", indexRoot);
                this.setProperty("currentTG", null);
                return (T)indexRoot;
            }
            TransferableGraphSource tgs = (TransferableGraphSource)this.getProperty("currentTGS");
            if (tgs == null) return null;
            Resource indexRoot = (Resource)session.syncRequest((WriteResult)new WriteResultRequest<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Boolean dep = (Boolean)MigrationStateImpl.this.getProperty("updateDependencies");
                    if (dep != null && !dep.booleanValue()) {
                        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, true);
                    }
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource project = Simantics.getProject();
                    Resource root = graph.getPossibleObject(project, Layer0.getInstance((ReadGraph)graph).PartOf);
                    Resource temp = Layer0Utils.getPossibleChild((ReadGraph)graph, root, "Temp");
                    if (temp == null) {
                        return null;
                    }
                    Resource indexRoot = graph.newResource();
                    String indexRootName = DateFormat.getDateTimeInstance(0, 0).format(new Date());
                    graph.claim(indexRoot, L0.InstanceOf, L0.IndexRoot);
                    graph.addLiteral(indexRoot, L0.HasName, L0.String, (Object)indexRootName, (Binding)Bindings.STRING);
                    graph.claim(temp, L0.ConsistsOf, indexRoot);
                    return indexRoot;
                }
            });
            DefaultPasteImportAdvisor ia = new DefaultPasteImportAdvisor(indexRoot){

                public void beforeWrite(WriteOnlyGraph graph) throws DatabaseException {
                    boolean update = (Boolean)MigrationStateImpl.this.getProperty("updateDependencies");
                    if (!update) {
                        Layer0Utils.setDependenciesIndexingDisabled(graph, true);
                    }
                }
            };
            TransferableGraphs.importGraph1((Session)session, (TransferableGraphSource)tgs, (IImportAdvisor)ia, (TGStatusMonitor)new TGStatusMonitor(){

                public void status(int percentage) {
                    monitor.subTask("Importing model from file (" + percentage + "%)");
                }
            });
            if (indexRoot == null) return (T)indexRoot;
            this.setProperty("currentResource", indexRoot);
            this.setProperty("currentTG", null);
            return (T)indexRoot;
        } else {
            if (!"updateDependencies".equals(key)) return null;
            return null;
        }
    }

    @Override
    public <T> void setProperty(String key, T value) {
        this.properties.put(key, value);
    }

    public void dispose() {
        try {
            StreamingTransferableGraphFileReader tgs = (StreamingTransferableGraphFileReader)this.probeProperty("currentTGSReader");
            MigrationStateImpl.uncheckedClose((ByteFileReader)tgs);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    private static void uncheckedClose(ByteFileReader closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

